/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol;

import java.util.List;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.EMFStoreSessions;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.Messages;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.authentication.ESUserVerifierFactory;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESAuthenticationInformationImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESSessionIdImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESUserImpl;
import org.eclipse.emf.emfstore.server.auth.ESAuthenticationControlType;
import org.eclipse.emf.emfstore.server.auth.ESOrgUnitResolver;
import org.eclipse.emf.emfstore.server.auth.ESUserVerifier;
import org.eclipse.emf.emfstore.server.model.ESAuthenticationInformation;
import org.eclipse.emf.emfstore.server.model.ESClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;
import org.eclipse.emf.emfstore.server.model.ESSessionId;

public class LoginService {
    private static final String USER_VERIFIER_SERVICE_CLASS = "userVerifierServiceClass";
    private static final String MONITOR_NAME = "authentication";
    private static final String ACCESSCONTROL_EXTENSION_ID = "org.eclipse.emf.emfstore.server.accessControl";
    private final EMFStoreSessions sessions;
    private final ESOrgUnitResolver orgUnitResolver;
    private final ESOrgUnitProvider orgUnitProvider;
    private final ESAuthenticationControlType authenticationControlType;
    private ESUserVerifier userVerifier;

    public LoginService(ESAuthenticationControlType authenticationControlType, EMFStoreSessions sessions, ESOrgUnitProvider orgUnitProvider, ESOrgUnitResolver orgUnitResolver) {
        this.authenticationControlType = authenticationControlType;
        this.sessions = sessions;
        this.orgUnitProvider = orgUnitProvider;
        this.orgUnitResolver = orgUnitResolver;
    }

    private ESUserVerifier initUserVerifierService() {
        try {
            ESExtensionPoint ext = new ESExtensionPoint(ACCESSCONTROL_EXTENSION_ID, false);
            List elements = ext.getExtensionElements();
            ESUserVerifier verifier = null;
            for (ESExtensionElement el : elements) {
                verifier = (ESUserVerifier)el.getClass(USER_VERIFIER_SERVICE_CLASS, ESUserVerifier.class);
                if (verifier == null) continue;
                verifier.init(this.orgUnitProvider);
                return verifier;
            }
            return ESUserVerifierFactory.getInstance().createUserVerifier(this.authenticationControlType, this.orgUnitProvider);
        }
        catch (ESExtensionPointException ex) {
            ModelUtil.logException((String)Messages.LoginService_CustomLoginServiceInitFailed, (Throwable)ex);
            return null;
        }
        catch (FatalESException ex) {
            ModelUtil.logException((String)Messages.LoginService_CustomLoginServiceInitFailed, (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESAuthenticationInformation logIn(String username, String password, ESClientVersionInfo clientVersionInfo) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor(MONITOR_NAME);
        synchronized (object) {
            ESAuthenticationInformation authInfo = this.getUserVerifierService().verifyUser(username, password, clientVersionInfo);
            AuthenticationInformation authenticationInformation = (AuthenticationInformation)((ESAuthenticationInformationImpl)ESAuthenticationInformationImpl.class.cast(authInfo)).toInternalAPI();
            ESSessionId existingSession = this.sessions.resolveByUser(authInfo.getUser());
            if (existingSession == null) {
                this.sessions.add(authInfo);
            } else {
                authenticationInformation.setSessionId((SessionId)((ESSessionIdImpl)ESSessionIdImpl.class.cast(existingSession)).toInternalAPI());
            }
            ACUser resolvedUser = (ACUser)((ESUserImpl)ESUserImpl.class.cast(this.orgUnitResolver.resolveRoles(authInfo))).toInternalAPI();
            authenticationInformation.setResolvedACUser(resolvedUser);
            return authInfo;
        }
    }

    private ESUserVerifier getUserVerifierService() {
        if (this.userVerifier == null) {
            this.userVerifier = this.initUserVerifierService();
        }
        return this.userVerifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(ESSessionId sessionId) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor(MONITOR_NAME);
        synchronized (object) {
            if (sessionId == null) {
                throw new AccessControlException(Messages.AccessControlImpl_SessionID_Is_Null);
            }
            this.sessions.remove(sessionId);
        }
    }

    public boolean verifyUser(String username, String password, ESClientVersionInfo clientVersionInfo) {
        try {
            this.getUserVerifierService().verifyUser(username, password, clientVersionInfo);
            return true;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }
}

