/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EAttributeTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.TreeElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public final class CustomizedContentProviderUtils {
    private CustomizedContentProviderUtils() {
    }

    public static ISelection resolveSelection(ISelection selection) {
        ArrayList<Object> resolvedElements;
        Assert.isNotNull((Object)selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strSelection = (IStructuredSelection)selection;
            resolvedElements = new ArrayList<Object>();
            for (Object element : strSelection) {
                resolvedElements.add(CustomizedContentProviderUtils.resolve(element));
            }
        } else {
            throw new IllegalArgumentException("Unhandled selection type: " + selection.getClass().getName());
        }
        StructuredSelection result = new StructuredSelection(resolvedElements);
        return result;
    }

    public static Object resolve(Object element) {
        Object resolved = element;
        if (element instanceof EObjectTreeElement) {
            resolved = ((EObjectTreeElement)element).getEObject();
        } else if (element instanceof EAttributeTreeElement) {
            resolved = ((EAttributeTreeElement)element).getEAttribute();
        } else if (element instanceof EReferenceTreeElement) {
            resolved = ((EReferenceTreeElement)element).getEReference();
        }
        return resolved;
    }

    public static EStructuralFeature getEStructuralFeature(Object treeElt) {
        EReference result = null;
        if (treeElt instanceof EReferenceTreeElement) {
            EReferenceTreeElement refTreeElt = (EReferenceTreeElement)treeElt;
            result = refTreeElt.getEReference();
        }
        return result;
    }

    public static EObject getParentEObject(Object object) {
        Object supposedTreeElt = null;
        if (!(object instanceof EObjectTreeElement) && object instanceof TreeElement) {
            TreeElement treeElt = (TreeElement)object;
            supposedTreeElt = treeElt.getParent();
        } else {
            supposedTreeElt = object;
        }
        return CustomizedContentProviderUtils.getEObject(supposedTreeElt);
    }

    public static EObject getEObject(Object object) {
        EObject result = null;
        if (object instanceof EObjectTreeElement) {
            EObjectTreeElement eObjTreeElt = (EObjectTreeElement)object;
            result = eObjTreeElt.getEObject();
        }
        return result;
    }
}

