/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.ui.internal.exported.util.wizard.page;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.emf.ui.internal.Activator;
import org.eclipse.emf.facet.util.emf.ui.internal.Messages;
import org.eclipse.emf.facet.util.emf.ui.internal.exported.util.composite.EClassifierSelectionControl;
import org.eclipse.emf.facet.util.emf.ui.internal.exported.util.wizard.page.SelectEPackageWizardPage;
import org.eclipse.emf.facet.util.emf.ui.internal.exported.util.wizard.page.exception.SelectedEClassifierRuntimeException;
import org.eclipse.emf.facet.util.emf.ui.internal.exported.wizard.page.ISelectEClassifierWizardPage;
import org.eclipse.emf.facet.util.emf.ui.internal.exported.wizard.page.ISelectEPackageWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.FilteredList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectEClassifierWizardPage<T extends EClassifier>
extends WizardPage
implements ISelectEClassifierWizardPage<T> {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private EClassifierSelectionControl<T> eClassSelection;
    private final Class<? extends T> eTypeOption;
    private String metamodelNsUri;

    public SelectEClassifierWizardPage(Class<? extends T> eTypeOption, EPackage ePackage) {
        super("Whatever");
        if (eTypeOption == EClass.class) {
            this.setTitle(Messages.Select_EClass);
        } else if (eTypeOption == EDataType.class) {
            this.setTitle(Messages.Select_EDataType);
        } else if (eTypeOption == EClassifier.class) {
            this.setTitle(Messages.Select_EClassifier);
        } else if (eTypeOption == ETypedElement.class) {
            this.setTitle(Messages.Select_ETypedElement);
        }
        if (ePackage != null) {
            this.metamodelNsUri = ePackage.getNsURI();
        }
        this.eTypeOption = eTypeOption;
    }

    public boolean isPageComplete() {
        return this.eClassSelection.getSelectedEClassifier() != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getPreviousPage() instanceof SelectEPackageWizardPage) {
            ISelectEPackageWizardPage selectEPackage = (ISelectEPackageWizardPage)this.getPreviousPage();
            this.metamodelNsUri = selectEPackage.getSelectedEPackage().getNsURI();
            if (this.metamodelNsUri != null) {
                this.setDescription(selectEPackage.getSelectedEPackage().getNsURI());
            }
        }
        this.eClassSelection.updateList(this.metamodelNsUri);
    }

    public void createControl(Composite parent) {
        this.eClassSelection = new EClassifierSelectionControl<T>(parent, this.metamodelNsUri, this.eTypeOption);
        FilteredList filteredList = this.eClassSelection.getFilteredList();
        filteredList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (event.item != null) {
                    SelectEClassifierWizardPage.this.updateButton();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                if (SelectEClassifierWizardPage.this.getWizard().canFinish()) {
                    SelectEClassifierWizardPage.this.getWizard().performFinish();
                }
                if (SelectEClassifierWizardPage.this.getNextPage() != null) {
                    SelectEClassifierWizardPage.this.goToNextPage();
                }
            }
        });
        this.eClassSelection.getFilterText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SelectEClassifierWizardPage.this.updateButton();
            }
        });
        filteredList.setSelection(new int[0]);
        this.setPageComplete(false);
        this.setControl((Control)this.eClassSelection);
    }

    protected void goToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    protected void updateButton() {
        if (this.getContainer() != null && this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    @Override
    public T getSelectedEClassifier() {
        return this.eClassSelection.getSelectedEClassifier();
    }

    @Override
    public void selectEClassifier(String eclassifierName) {
        DebugUtils.debug((boolean)DEBUG);
        boolean doItNow = true;
        Job[] jobArray = Job.getJobManager().find(null);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getClass().getName().startsWith(FilteredList.class.getName())) {
                this.asyncSelectionClassifier(eclassifierName);
                DebugUtils.debug((boolean)DEBUG, (String)"Selection defered.");
                doItNow = false;
                break;
            }
            ++n2;
        }
        if (doItNow) {
            this.internalSelectEClassifier(eclassifierName);
        }
    }

    private void asyncSelectionClassifier(final String eclassifierName) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SelectEClassifierWizardPage.this.selectEClassifier(eclassifierName);
            }
        });
    }

    private void internalSelectEClassifier(String packageName) {
        FilteredList filteredList = this.eClassSelection.getFilteredList();
        filteredList.setSelection((Object[])new String[]{packageName});
        if (this.getSelectedEClassifier() == null) {
            throw new SelectedEClassifierRuntimeException();
        }
        DebugUtils.debug((boolean)DEBUG, (String)"Selection setting finished.");
        DebugUtils.debug((boolean)DEBUG, (String)("selectedEClassifier=" + this.getSelectedEClassifier()));
    }
}

