/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.widget.facetcustom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.EClassCustomization;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactory;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactoryFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.FalseLiteralQuery;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.IsOneOfQuery;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.QueryFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.QueryPackage;
import org.eclipse.emf.facet.util.emf.core.command.EmfCommandUtils;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResult;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResultFactory;
import org.eclipse.emf.facet.util.emf.core.internal.exported.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.BasicCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.widget.command.CommandList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCustomCommandFactory {
    private final Table table;
    private final BasicCommandFactory basicCmdFactory;
    private final ICustomizationCommandFactory customCmdFactory;

    public LocalCustomCommandFactory(Table table, BasicCommandFactory basicCmdFactory) {
        this.table = table;
        this.basicCmdFactory = basicCmdFactory;
        ICommandFactory cmdFactory = basicCmdFactory.getCmdFactory();
        EditingDomain editingDomain = basicCmdFactory.getEditingDomain();
        this.customCmdFactory = ICustomizationCommandFactoryFactory.DEFAULT.createCustomizationCommandFactory(editingDomain, cmdFactory);
    }

    public Command createAddLocalCustomCommand(EPackage ePackage) {
        CommandList cmdList = new CommandList();
        ICommandFactoryResult<Customization> cmdFactoryResult = this.createCreateLocalCustom(ePackage);
        Customization newCustom = (Customization)cmdFactoryResult.getResult();
        cmdList.add(cmdFactoryResult.getCommand());
        ArrayList<Customization> customs = new ArrayList<Customization>();
        customs.addAll((Collection<Customization>)this.table.getCustomizations());
        EList localCustoms = this.table.getLocalCustomizations();
        int index = 0;
        for (Customization custom : customs) {
            if (localCustoms.contains(custom)) break;
            ++index;
        }
        customs.add(index, newCustom);
        Command setCustomCmd = this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_Customizations(), customs);
        cmdList.add(setCustomCmd);
        String msg = String.format("Add of a new customization for the ePackage '%s'", ePackage.getName());
        return EmfCommandUtils.createResult((List)cmdList, (String)msg);
    }

    public Command createCustomPropertyCommand(String label, FacetOperation customProperty, Set<ETypedElement> features) {
        IsOneOfQuery conformanceQuery;
        Facet typeCustomization;
        CommandList commandList = new CommandList();
        EList localCustoms = this.table.getLocalCustomizations();
        Customization customization = null;
        if (!localCustoms.isEmpty()) {
            customization = (Customization)localCustoms.get(0);
        }
        if (customization == null) {
            ICommandFactoryResult<Customization> cmdFactoryResult = this.createCreateLocalCustom((EPackage)EcorePackage.eINSTANCE);
            customization = (Customization)cmdFactoryResult.getResult();
            commandList.add(cmdFactoryResult.getCommand());
        }
        if ((typeCustomization = LocalCustomCommandFactory.findFacetByExtendedMetaclass(FacetUtils.getFacets(customization), EcorePackage.eINSTANCE.getETypedElement())) == null) {
            conformanceQuery = QueryFactory.eINSTANCE.createIsOneOfQuery();
            ICommandFactoryResult crtClassCustom = this.customCmdFactory.createEClassCustomization(customization, EcorePackage.eINSTANCE.getETypedElement(), (Query)conformanceQuery);
            typeCustomization = (Facet)crtClassCustom.getResult();
            commandList.add(crtClassCustom.getCommand());
        } else {
            if (!(typeCustomization instanceof EClassCustomization)) {
                throw new TableWidgetRuntimeException("Unexpected type for the variable 'featureContainer'");
            }
            DerivedTypedElement conformanceTE = (DerivedTypedElement)typeCustomization.getConformanceTypedElement();
            conformanceQuery = (IsOneOfQuery)conformanceTE.getQuery();
        }
        Command initQuery = this.basicCmdFactory.createSetCommand(conformanceQuery, QueryPackage.eINSTANCE.getIsOneOfQuery_ExpectedEObjects(), new ArrayList<ETypedElement>(features));
        commandList.add(initQuery);
        FalseLiteralQuery query = QueryFactory.eINSTANCE.createFalseLiteralQuery();
        ICommandFactoryResult propConfigCmd = this.customCmdFactory.setPropertyConfig(typeCustomization, null, customProperty, (Query)query);
        commandList.add(propConfigCmd.getCommand());
        return EmfCommandUtils.createResult((List)commandList, (String)label);
    }

    private ICommandFactoryResult<Customization> createCreateLocalCustom(EPackage ePackage) {
        CommandList cmdList = new CommandList();
        String name = String.format("Column hiding customization for %s", ePackage.getName());
        ICommandFactoryResult cmdFactoryResult = this.customCmdFactory.createCustomization(name);
        Customization customization = (Customization)cmdFactoryResult.getResult();
        cmdList.add(cmdFactoryResult.getCommand());
        Command addToLocalCmd = this.basicCmdFactory.createAddCommand(this.table, TablePackage.eINSTANCE.getTable_LocalCustomizations(), customization);
        cmdList.add(addToLocalCmd);
        Command addAllCmd = this.basicCmdFactory.createAddCommand(this.table, TablePackage.eINSTANCE.getTable_Customizations(), customization);
        cmdList.add(addAllCmd);
        Command cmd = EmfCommandUtils.createResult((List)cmdList, (String)"Create a local custom.");
        return ICommandFactoryResultFactory.DEFAULT.createCommandFactoryResult(cmd, (Object)customization);
    }

    public Command createPutLocalCustomizationOnTheTopCommand() {
        Command cmd = null;
        EList localCustoms = this.table.getLocalCustomizations();
        ArrayList customizations = new ArrayList();
        customizations.addAll(this.table.getCustomizations());
        customizations.removeAll((Collection<?>)localCustoms);
        customizations.addAll(0, localCustoms);
        if (!customizations.equals(this.table.getCustomizations())) {
            cmd = this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_Customizations(), customizations);
        }
        return cmd;
    }

    public Command createPutLocalCustomizationOnTheBottomCommand() {
        EList locals = this.table.getLocalCustomizations();
        ArrayList customizations = new ArrayList();
        customizations.addAll(this.table.getCustomizations());
        customizations.removeAll((Collection<?>)locals);
        customizations.addAll(customizations.size(), locals);
        return this.basicCmdFactory.createSetCommand(this.table, TablePackage.eINSTANCE.getTable_Customizations(), customizations);
    }

    private static Facet findFacetByExtendedMetaclass(Collection<Facet> facets, EClass extendedMetaClass) {
        Facet result = null;
        for (Facet facet : facets) {
            Facet candidate = facet;
            if (candidate.getExtendedMetaclass() != extendedMetaClass) continue;
            result = candidate;
            break;
        }
        return result;
    }
}

