/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.workbench.expression;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.NavigationTable;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.internal.workbench.handler.HandlerUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TableTester
extends PropertyTester {
    private static final String DEBUG_ID = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + "/debug/" + HandlerUtils.class.getSimpleName();
    private static final boolean DEBUG = Activator.getDefault().isDebugging() && Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_ID));
    public static final String IS_TABLE = "isTable";
    public static final String IS_TABLE_EDITOR = "isTableEditor";
    public static final String IS_TABLE_VIEW = "isTableView";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean answer = false;
        if (IS_TABLE.equals(property) && expectedValue instanceof Boolean) {
            answer = TableTester.testIsTable();
        }
        if (IS_TABLE_EDITOR.equals(property) && expectedValue instanceof Boolean && receiver instanceof IWorkbenchPart) {
            answer = TableTester.testIsTableEditor((IWorkbenchPart)receiver);
        }
        if (IS_TABLE_VIEW.equals(property) && expectedValue instanceof Boolean && receiver instanceof IWorkbenchPart) {
            answer = TableTester.testIsTableView((IWorkbenchPart)receiver);
        }
        Boolean expectedBoolean = (Boolean)expectedValue;
        DebugUtils.debug((boolean)DEBUG, (String)(String.valueOf(property) + '=' + answer));
        return expectedBoolean == answer;
    }

    private static boolean testIsTableView(IWorkbenchPart part) {
        ITableWidgetProvider natTableWidgetProvider;
        Table tableInstance;
        Object adapter;
        boolean result = false;
        if (part instanceof IViewPart && (adapter = part.getAdapter(ITableWidgetProvider.class)) != null && !((tableInstance = (natTableWidgetProvider = (ITableWidgetProvider)adapter).getTableWidget().getTable()) instanceof NavigationTable)) {
            result = true;
        }
        return result;
    }

    public static boolean testIsTableEditor(IWorkbenchPart part) {
        boolean result = false;
        if (part instanceof IEditorPart) {
            Object adapter = part.getAdapter(ITableWidgetProvider.class);
            result = adapter != null;
        }
        return result;
    }

    private static boolean testIsTable() {
        boolean result = false;
        IWorkbenchPart activePart = TableTester.getActivePart();
        if (activePart != null) {
            Object adapter = activePart.getAdapter(ITableWidgetProvider.class);
            result = adapter != null;
        }
        return result;
    }

    private static IWorkbenchPart getActivePart() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbenchPart activePart = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            activePart = page.getActivePart();
        }
        return activePart;
    }
}

