/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.workbench.handler;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SortByColumnHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITableWidgetProvider widgetPart;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart != null && (widgetPart = (ITableWidgetProvider)activePart.getAdapter(ITableWidgetProvider.class)) != null) {
            ColumnSortDirection direction;
            ITableWidgetInternal tableWidget = (ITableWidgetInternal)widgetPart.getTableWidget();
            List<Column> columns = tableWidget.getSelectedColumns();
            String cmdId = event.getCommand().getId();
            if ("org.eclipse.emf.facet.widgets.table.descendingSortByColumn".equals(cmdId)) {
                direction = ColumnSortDirection.DESCENDING;
            } else if ("org.eclipse.emf.facet.widgets.table.ascendingSortByColumn".equals(cmdId)) {
                direction = ColumnSortDirection.ASCENDING;
            } else {
                String message = String.format("Unexpectid command id : %s", cmdId);
                throw new IllegalStateException(message);
            }
            for (Column column : columns) {
                tableWidget.sortRows(column, direction);
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        ITableWidgetInternal tableWidget;
        IWorkbenchPart workbenchPart;
        ITableWidgetProvider twProvider;
        IEvaluationContext context;
        Object activePart;
        boolean result = false;
        if (evaluationContext instanceof IEvaluationContext && (activePart = (context = (IEvaluationContext)evaluationContext).getVariable("activePart")) instanceof IWorkbenchPart && (twProvider = (ITableWidgetProvider)(workbenchPart = (IWorkbenchPart)activePart).getAdapter(ITableWidgetProvider.class)) != null && (tableWidget = (ITableWidgetInternal)twProvider.getTableWidget()) != null && tableWidget.isColumnSelected()) {
            result = true;
        }
        this.setBaseEnabled(result);
    }

    public boolean isHandled() {
        return this.isEnabled();
    }
}

