/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.eclipse.gef.common.activate.ActivatableSupport;
import org.eclipse.gef.common.activate.IActivatable;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.gestures.IGesture;
import org.eclipse.gef.mvc.fx.gestures.IHandlerResolver;
import org.eclipse.gef.mvc.fx.handlers.IHandler;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public abstract class AbstractGesture
implements IGesture {
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private ReadOnlyObjectWrapper<IDomain> domainProperty = new ReadOnlyObjectWrapper();
    private Map<IViewer, List<IHandler>> activeHandlers = new IdentityHashMap<IViewer, List<IHandler>>();

    public final void activate() {
        this.acs.activate(null, this::doActivate);
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IDomain> adaptableProperty() {
        return this.domainProperty.getReadOnlyProperty();
    }

    protected void clearActiveHandlers(IViewer viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given viewer may not be null.");
        }
        this.activeHandlers.remove(viewer);
    }

    public final void deactivate() {
        this.acs.deactivate(this::doDeactivate, null);
    }

    protected void doActivate() {
    }

    protected void doDeactivate() {
    }

    @Override
    public List<? extends IHandler> getActiveHandlers(IViewer viewer) {
        if (this.activeHandlers.containsKey(viewer)) {
            return Collections.unmodifiableList(this.activeHandlers.get(viewer));
        }
        return Collections.emptyList();
    }

    public IDomain getAdaptable() {
        return (IDomain)this.domainProperty.get();
    }

    @Override
    public IDomain getDomain() {
        return this.getAdaptable();
    }

    protected IHandlerResolver getHandlerResolver() {
        return (IHandlerResolver)this.getDomain().getAdapter(IHandlerResolver.class);
    }

    public final boolean isActive() {
        return this.acs.isActive();
    }

    protected void setActiveHandlers(IViewer viewer, Collection<? extends IHandler> activeHandlers) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given viewer may not be null.");
        }
        if (activeHandlers == null) {
            throw new IllegalArgumentException("The given activePolicies may not be null.");
        }
        for (IHandler iHandler : activeHandlers) {
            if (iHandler.getHost().getViewer() == viewer) continue;
            throw new IllegalArgumentException("Resolved handler is not hosted within viewer.");
        }
        this.clearActiveHandlers(viewer);
        this.activeHandlers.put(viewer, new ArrayList<IHandler>(activeHandlers));
    }

    public void setAdaptable(IDomain adaptable) {
        if (this.isActive()) {
            throw new IllegalStateException("The reference to the IDomain may not be changed while the gesture is active. Please deactivate the gesture before setting the IEditDomain and re-activate it afterwards.");
        }
        this.domainProperty.set((Object)adaptable);
    }
}

