/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.util.gef.MouseWheelHorizontalScrollHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;

public class GraphitiScrollingGraphicalViewer
extends ScrollingGraphicalViewer {
    private DiagramBehavior diagramBehavior;

    public GraphitiScrollingGraphicalViewer(DiagramBehavior diagramBehavior) {
        this.setDiagramBehavior(diagramBehavior);
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), MouseWheelZoomHandler.SINGLETON);
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD2), MouseWheelHorizontalScrollHandler.SINGLETON);
    }

    public void select(EditPart editpart) {
        IToolBehaviorProvider tbp = this.getDiagramBehavior().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        boolean connectionPossible = tbp.isConnectionSelectionEnabled();
        if (connectionPossible) {
            super.select(editpart);
            return;
        }
        Object model = editpart.getModel();
        if (!(model instanceof Connection)) {
            super.select(editpart);
            return;
        }
    }

    public void setSelection(ISelection newSelection) {
        IToolBehaviorProvider tbp = this.getDiagramBehavior().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        boolean multiPossible = tbp.isMultiSelectionEnabled();
        boolean connectionPossible = tbp.isConnectionSelectionEnabled();
        if (multiPossible && connectionPossible) {
            super.setSelection(newSelection);
            return;
        }
        if (multiPossible && !connectionPossible) {
            boolean change = false;
            ArrayList<Object> l = new ArrayList<Object>();
            if (newSelection instanceof IStructuredSelection) {
                IStructuredSelection strSel = (IStructuredSelection)newSelection;
                int i = 0;
                while (i < strSel.toArray().length) {
                    EditPart editpart;
                    Object o = strSel.toArray()[i];
                    if (o instanceof EditPart && (editpart = (EditPart)o).getModel() instanceof Connection) {
                        change = true;
                    } else {
                        l.add(o);
                    }
                    ++i;
                }
            }
            if (change) {
                newSelection = new StructuredSelection(l);
            }
            super.setSelection(newSelection);
            return;
        }
        if (!multiPossible && connectionPossible) {
            if (newSelection instanceof IStructuredSelection) {
                IStructuredSelection strSel = (IStructuredSelection)newSelection;
                int i = 0;
                while (i < strSel.toArray().length) {
                    Object o = strSel.toArray()[i];
                    if (o instanceof EditPart) {
                        EditPart ep = (EditPart)o;
                        this.select(ep);
                        return;
                    }
                    ++i;
                }
                this.deselectAll();
            }
            return;
        }
        if (!multiPossible && !connectionPossible) {
            if (newSelection instanceof IStructuredSelection) {
                IStructuredSelection strSel = (IStructuredSelection)newSelection;
                int i = 0;
                while (i < strSel.toArray().length) {
                    EditPart ep;
                    Object o = strSel.toArray()[i];
                    if (o instanceof EditPart && !((ep = (EditPart)o).getModel() instanceof Connection)) {
                        this.select(ep);
                        return;
                    }
                    ++i;
                }
                this.deselectAll();
            }
            return;
        }
    }

    public void appendSelection(EditPart editpart) {
        IToolBehaviorProvider tbp = this.getDiagramBehavior().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        boolean multiPossible = tbp.isMultiSelectionEnabled();
        boolean connectionPossible = tbp.isConnectionSelectionEnabled();
        if (multiPossible && connectionPossible) {
            super.appendSelection(editpart);
            return;
        }
        if (multiPossible && !connectionPossible) {
            Object model = editpart.getModel();
            if (model instanceof Connection) {
                return;
            }
            super.appendSelection(editpart);
            return;
        }
        if (!multiPossible && connectionPossible) {
            this.deselectAll();
            super.appendSelection(editpart);
            return;
        }
        if (!multiPossible && !connectionPossible) {
            Object model = editpart.getModel();
            if (model instanceof Connection) {
                return;
            }
            this.deselectAll();
            super.appendSelection(editpart);
            return;
        }
    }

    private void setDiagramBehavior(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    protected DiagramBehavior getDiagramBehavior() {
        return this.diagramBehavior;
    }
}

