/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.command;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.text.Document;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;

public class CreateEntityTypeHierarchy
implements Command {
    private PersistentType subclass;
    private PersistentType superclass;
    private boolean shouldCreate;

    public CreateEntityTypeHierarchy(PersistentType superclass, PersistentType subclass, boolean shouldCreate) {
        this.superclass = superclass;
        this.subclass = subclass;
        this.shouldCreate = shouldCreate;
    }

    public void execute() {
        this.buildHierarchy(this.superclass, this.subclass, this.shouldCreate);
        JavaResourceType jrt = this.subclass.getJavaResourceType();
        jrt.getJavaResourceCompilationUnit().synchronizeWithJavaSource();
    }

    private void buildHierarchy(PersistentType superclass, PersistentType subclass, boolean build) {
        try {
            ICompilationUnit subCU = JPAEditorUtil.getCompilationUnit(subclass);
            Document document = new Document(subCU.getBuffer().getContents());
            MultiTextEdit edit = new MultiTextEdit();
            String str = document.get();
            if (build) {
                int offset = str.indexOf(subclass.getSimpleName()) + subclass.getSimpleName().length();
                edit.addChild((TextEdit)new InsertEdit(offset, " extends " + superclass.getSimpleName()));
            } else {
                int length = ("extends " + superclass.getSimpleName() + " ").length();
                int offset = str.indexOf("extends");
                edit.addChild((TextEdit)new DeleteEdit(offset, length));
            }
            TextEditCopier copier = new TextEditCopier((TextEdit)edit);
            TextEdit copy = copier.perform();
            subCU.applyTextEdit(copy, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException exception) {
            JPADiagramEditorPlugin.logError(exception);
        }
        catch (MalformedTreeException exception) {
            JPADiagramEditorPlugin.logError(exception);
        }
    }
}

