/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.source;

public class ISymbolConstants {
    public static final int SYMBOL_SCOPE_REQUEST = 1;
    public static final int SYMBOL_SCOPE_SESSION = 2;
    public static final int SYMBOL_SCOPE_APPLICATION = 4;
    public static final int SYMBOL_SCOPE_NONE = 8;
    public static final int SYMBOL_SCOPE_VIEW = 16;
    public static final int SYMBOL_SCOPE_FLASH = 32;
    public static final String SYMBOL_SCOPE_VIEW_STRING = "view";
    public static final String SYMBOL_SCOPE_FLASH_STRING = "flash";
    public static final int SYMBOL_SCOPE_ALL = 63;
    public static final String SYMBOL_SCOPE_REQUEST_STRING = "request";
    public static final String SYMBOL_SCOPE_SESSION_STRING = "session";
    public static final String SYMBOL_SCOPE_APPLICATION_STRING = "application";
    public static final String SYMBOL_SCOPE_NONE_STRING = "none";

    public static boolean isValid(int scope) {
        return scope == 4 || scope == 1 || scope == 2 || scope == 8 || scope == 16 || scope == 32;
    }

    public static String getStringForMask(int scopeMask) {
        if (scopeMask == 1) {
            return SYMBOL_SCOPE_REQUEST_STRING;
        }
        if (scopeMask == 2) {
            return SYMBOL_SCOPE_SESSION_STRING;
        }
        if (scopeMask == 4) {
            return SYMBOL_SCOPE_APPLICATION_STRING;
        }
        if (scopeMask == 8) {
            return SYMBOL_SCOPE_NONE_STRING;
        }
        if (scopeMask == 16) {
            return SYMBOL_SCOPE_VIEW_STRING;
        }
        if (scopeMask == 32) {
            return SYMBOL_SCOPE_FLASH_STRING;
        }
        return null;
    }

    public static int getMaskForString(String scopeString) {
        if (SYMBOL_SCOPE_REQUEST_STRING.equals(scopeString)) {
            return 1;
        }
        if (SYMBOL_SCOPE_SESSION_STRING.equals(scopeString)) {
            return 2;
        }
        if (SYMBOL_SCOPE_APPLICATION_STRING.equals(scopeString)) {
            return 4;
        }
        if (SYMBOL_SCOPE_NONE_STRING.equals(scopeString)) {
            return 8;
        }
        if (SYMBOL_SCOPE_VIEW_STRING.equals(scopeString)) {
            return 16;
        }
        if (SYMBOL_SCOPE_FLASH_STRING.equals(scopeString)) {
            return 32;
        }
        return -1;
    }
}

