/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ldt.core.LuaUtils;
import org.eclipse.ldt.ui.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class LuaDialogUtil {
    private LuaDialogUtil() {
    }

    public static final IProject openSelectLuaProjectDialog(Shell shell, String projectName) {
        return LuaDialogUtil.openSelectLuaProjectDialog(shell, projectName, null, null);
    }

    public static final IProject openSelectLuaProjectDialog(Shell shell, String projectName, String title, String message) {
        Object result;
        IProject project;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider());
        if (title == null) {
            dialog.setTitle(Messages.LuaDialogUtil_title);
        } else {
            dialog.setTitle(title);
        }
        if (message == null) {
            dialog.setMessage(Messages.LuaDialogUtil_message);
        } else {
            dialog.setMessage(message);
        }
        dialog.setElements((Object[])LuaUtils.getLuaProjects());
        if (projectName != null && !projectName.isEmpty() && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof IProject) {
            return (IProject)result;
        }
        return null;
    }

    public static final IFile openSelectScriptFromProjectDialog(Shell shell, IProject project) {
        return LuaDialogUtil.openSelectScriptFromProjectDialog(shell, project, null, null);
    }

    public static final IFile openSelectScriptFromProjectDialog(Shell shell, IProject project, String title, String message) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                Object[] elements = super.getElements(element);
                ArrayList<Object> newElementList = new ArrayList<Object>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object anElement = objectArray[n2];
                    if (anElement instanceof IFile) {
                        IFile file = (IFile)anElement;
                        if ("lua".equals(file.getFileExtension())) {
                            newElementList.add(file);
                        }
                    } else if (anElement instanceof IContainer) {
                        newElementList.add(anElement);
                    }
                    ++n2;
                }
                return newElementList.toArray();
            }
        });
        dialog.setInput((Object)project);
        if (title == null) {
            dialog.setTitle(Messages.LuaDialogUtil_selectScript_title);
        } else {
            dialog.setTitle(title);
        }
        if (message == null) {
            dialog.setMessage(Messages.LuaDialogUtil_selectScript_message);
        } else {
            dialog.setMessage(message);
        }
        if (dialog.open() == 0) {
            return (IFile)dialog.getResult()[0];
        }
        return null;
    }
}

