/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.ICaseInsensitivityHelper;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.AbstractDeclarativeQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.ISimilarityMatcher;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.Messages;
import org.eclipse.xtext.ui.editor.quickfix.ReplaceModification;
import org.eclipse.xtext.util.StopWatch;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

public class ExtensibleQuickfixProvider
extends AbstractDeclarativeQuickfixProvider {
    private static final Logger logger = Logger.getLogger(ExtensibleQuickfixProvider.class);
    @Inject
    private ISimilarityMatcher similarityMatcher;
    @Inject
    private IssueModificationContext.Factory modificationContextFactory;
    @Inject
    private Provider<IssueResolutionAcceptor> issueResolutionAcceptorProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    protected IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    protected IValueConverterService valueConverter;
    @Inject
    private ICaseInsensitivityHelper caseInsensitivityHelper;

    private CrossReference findCrossReference(EObject context, INode node) {
        if (node == null || node.hasDirectSemanticElement() && context.equals(node.getSemanticElement())) {
            return null;
        }
        EObject grammarElement = node.getGrammarElement();
        if (grammarElement instanceof CrossReference) {
            return (CrossReference)grammarElement;
        }
        return this.findCrossReference(context, (INode)node.getParent());
    }

    public List<IssueResolution> getResolutionsForLinkingIssue(Issue issue) {
        IssueResolutionAcceptor issueResolutionAcceptor = (IssueResolutionAcceptor)this.issueResolutionAcceptorProvider.get();
        this.createLinkingIssueResolutions(issue, issueResolutionAcceptor);
        return issueResolutionAcceptor.getIssueResolutions();
    }

    public void createLinkingIssueResolutions(Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        IModificationContext modificationContext = this.modificationContextFactory.createModificationContext(issue);
        IXtextDocument xtextDocument = modificationContext.getXtextDocument();
        if (xtextDocument == null) {
            return;
        }
        xtextDocument.readOnly((IUnitOfWork)this.createQuickfixProcessor(xtextDocument, issue, issueResolutionAcceptor));
    }

    protected QuickfixProcessor createQuickfixProcessor(IXtextDocument xtextDocument, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
        return new QuickfixProcessor(xtextDocument, issue, issueResolutionAcceptor);
    }

    protected Iterable<IEObjectDescription> queryScope(IScope scope) {
        return scope.getAllElements();
    }

    protected EReference getUnresolvedEReference(Issue issue, EObject target) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)target);
        if (node == null) {
            return null;
        }
        @NonNull ICompositeNode rootNode = node.getRootNode();
        ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(issue.getOffset() + 1));
        CrossReference crossReference = this.findCrossReference(target, (INode)leaf);
        if (crossReference != null) {
            return GrammarUtil.getReference((CrossReference)crossReference, (EClass)target.eClass());
        }
        return null;
    }

    protected String fixCrossReferenceLabel(String issueString, String replacement) {
        return String.valueOf(Messages.DefaultQuickfixProvider_changeTo) + replacement + Messages.DefaultQuickfixProvider_1;
    }

    protected String fixCrossReferenceImage(String issueString, String replacement) {
        return "";
    }

    public List<IssueResolution> getResolutions(Issue issue) {
        StopWatch stopWatch = new StopWatch(logger);
        try {
            if ("org.eclipse.xtext.diagnostics.Diagnostic.Linking".equals(issue.getCode())) {
                ArrayList<IssueResolution> result = new ArrayList<IssueResolution>();
                result.addAll(this.getResolutionsForLinkingIssue(issue));
                result.addAll(super.getResolutions(issue));
                ArrayList<IssueResolution> arrayList = result;
                return arrayList;
            }
            List list = super.getResolutions(issue);
            return list;
        }
        finally {
            stopWatch.resetAndLog("#getResolutions");
        }
    }

    public boolean hasResolutionFor(String issueCode) {
        return "org.eclipse.xtext.diagnostics.Diagnostic.Linking".equals(issueCode) || super.hasResolutionFor(issueCode);
    }

    protected IssueModificationContext.Factory getModificationContextFactory() {
        return this.modificationContextFactory;
    }

    protected IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    protected IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    protected ISimilarityMatcher getSimilarityMatcher() {
        return this.similarityMatcher;
    }

    protected class QuickfixProcessor
    extends IUnitOfWork.Void<XtextResource> {
        protected final IXtextDocument xtextDocument;
        protected final Issue issue;
        protected final IssueResolutionAcceptor issueResolutionAcceptor;

        protected QuickfixProcessor(IXtextDocument xtextDocument, Issue issue, IssueResolutionAcceptor issueResolutionAcceptor) {
            this.xtextDocument = xtextDocument;
            this.issue = issue;
            this.issueResolutionAcceptor = issueResolutionAcceptor;
        }

        public void process(XtextResource state) throws Exception {
            EObject target = state.getEObject(this.issue.getUriToProblem().fragment());
            EReference reference = ExtensibleQuickfixProvider.this.getUnresolvedEReference(this.issue, target);
            if (reference == null) {
                return;
            }
            boolean caseInsensitive = ExtensibleQuickfixProvider.this.caseInsensitivityHelper.isIgnoreCase(reference);
            AbstractElement crossReferenceTerminal = this.getCrossReference(this.issue, target);
            String ruleName = null;
            Keyword keyword = null;
            if (crossReferenceTerminal instanceof RuleCall) {
                RuleCall ruleCall = (RuleCall)crossReferenceTerminal;
                ruleName = ruleCall.getRule().getName();
            } else if (crossReferenceTerminal instanceof Keyword) {
                keyword = (Keyword)crossReferenceTerminal;
            }
            String issueString = this.xtextDocument.get(this.issue.getOffset().intValue(), this.issue.getLength().intValue());
            IScope scope = ExtensibleQuickfixProvider.this.scopeProvider.getScope(target, reference);
            ArrayList discardedDescriptions = Lists.newArrayList();
            HashSet qualifiedNames = Sets.newHashSet();
            int addedDescriptions = 0;
            int checkedDescriptions = 0;
            for (IEObjectDescription referableElement : ExtensibleQuickfixProvider.this.queryScope(scope)) {
                String referableElementQualifiedName = ExtensibleQuickfixProvider.this.qualifiedNameConverter.toString(referableElement.getQualifiedName());
                if (ExtensibleQuickfixProvider.this.similarityMatcher.isSimilar(issueString, ExtensibleQuickfixProvider.this.qualifiedNameConverter.toString(referableElement.getName()))) {
                    ++addedDescriptions;
                    this.createResolution(issueString, referableElement, ruleName, keyword, caseInsensitive);
                    qualifiedNames.add(referableElementQualifiedName);
                } else if (qualifiedNames.add(referableElementQualifiedName)) {
                    discardedDescriptions.add(referableElement);
                }
                if (++checkedDescriptions > 100) break;
            }
            if (discardedDescriptions.size() + addedDescriptions <= 5) {
                for (IEObjectDescription referableElement : discardedDescriptions) {
                    this.createResolution(issueString, referableElement, ruleName, keyword, caseInsensitive);
                }
            }
        }

        protected AbstractElement getCrossReference(Issue issue, EObject target) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)target);
            if (node == null) {
                throw new IllegalStateException("Cannot happen since we found a reference");
            }
            @NonNull ICompositeNode rootNode = node.getRootNode();
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(issue.getOffset() + 1));
            CrossReference crossReference = ExtensibleQuickfixProvider.this.findCrossReference(target, (INode)leaf);
            return crossReference.getTerminal();
        }

        public void createResolution(String issueString, IEObjectDescription solution, String ruleName, Keyword keyword, boolean caseInsensitive) {
            String replacement = ExtensibleQuickfixProvider.this.qualifiedNameConverter.toString(solution.getName());
            String replaceLabel = ExtensibleQuickfixProvider.this.fixCrossReferenceLabel(issueString, replacement);
            if (keyword != null) {
                if (caseInsensitive && !replacement.equalsIgnoreCase(keyword.getValue())) {
                    return;
                }
                if (!caseInsensitive && !replacement.equals(keyword.getValue())) {
                    return;
                }
            } else if (ruleName != null) {
                replacement = ExtensibleQuickfixProvider.this.valueConverter.toString((Object)replacement, ruleName);
            } else {
                logger.error((Object)"either keyword or ruleName have to present", (Throwable)new IllegalStateException());
            }
            this.issueResolutionAcceptor.accept(this.issue, replaceLabel, replaceLabel, ExtensibleQuickfixProvider.this.fixCrossReferenceImage(issueString, replacement), (IModification)new ReplaceModification(this.issue, replacement));
        }
    }
}

