/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.handler;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.WorkspaceThemesHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.dialog.CSSThemeCreationDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.dialog.CSSThemeEditionDialog;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.Theme;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.WorkspaceThemes;
import org.eclipse.papyrus.infra.gmfdiag.css.theme.ThemeManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CSSFileHandler
extends AbstractHandler
implements IHandler {
    private static final String THEME_EDIT_COMMAND_ID = "org.eclipse.papyrus.infra.gmfdiag.css.theme.edit";
    private static final String THEME_DEFINE_COMMAND_ID = "org.eclipse.papyrus.infra.gmfdiag.css.theme.define";
    private WorkspaceThemesHelper cssHelper = new WorkspaceThemesHelper();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Theme theme = null;
        int dialogResult = -1;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            String commandID = event.getCommand().getId();
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (THEME_DEFINE_COMMAND_ID.equals(commandID)) {
                theme = this.cssHelper.defineCSSStyleSheetFilesAsTheme((IStructuredSelection)selection);
                CSSThemeCreationDialog dialog = new CSSThemeCreationDialog(shell, theme);
                dialogResult = dialog.open();
            } else if (THEME_EDIT_COMMAND_ID.equals(commandID)) {
                IPath workspaceThemesFilePath = this.cssHelper.getThemeWorkspacePreferenceFilePath();
                WorkspaceThemes workspaceThemes = null;
                if (workspaceThemesFilePath.toFile().exists()) {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    Resource resource = resourceSet.getResource(URI.createFileURI((String)workspaceThemesFilePath.toOSString()), true);
                    workspaceThemes = (WorkspaceThemes)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)StylesheetsPackage.Literals.WORKSPACE_THEMES);
                }
                if (workspaceThemes != null && !workspaceThemes.getThemes().isEmpty()) {
                    CSSThemeEditionDialog dialog = new CSSThemeEditionDialog(shell, workspaceThemes, (IStructuredSelection)selection);
                    dialogResult = dialog.open();
                    theme = dialog.getEditedTheme();
                } else {
                    MessageDialog.openWarning((Shell)shell, (String)Messages.getString("CSSFileHandler.edition.warning.title"), (String)Messages.getString("CSSFileHandler.edition.warning.message"));
                }
            }
            if (dialogResult == 0) {
                if (THEME_DEFINE_COMMAND_ID.equals(commandID)) {
                    this.cssHelper.saveNewThemeWorkspacePreference(theme);
                } else if (THEME_EDIT_COMMAND_ID.equals(commandID)) {
                    this.cssHelper.saveWorkspaceThemesPreferenceResource(theme);
                }
                ThemeManager.instance.reloadThemes();
            }
        }
        return null;
    }
}

