/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.pim.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FontStyle implements Enumerator
{
    NORMAL(0, "Normal", "Normal"),
    ITALIC(1, "Italic", "Italic"),
    BOLD(2, "Bold", "Bold");

    public static final int NORMAL_VALUE = 0;
    public static final int ITALIC_VALUE = 1;
    public static final int BOLD_VALUE = 2;
    private static final FontStyle[] VALUES_ARRAY;
    public static final List<FontStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FontStyle[]{NORMAL, ITALIC, BOLD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FontStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FontStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FontStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FontStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FontStyle get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return ITALIC;
            }
            case 2: {
                return BOLD;
            }
        }
        return null;
    }

    private FontStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

