/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.ui.widgets;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.internal.core.preferences.Preferences;
import org.eclipse.remote.internal.ui.RemoteUIPlugin;
import org.eclipse.remote.internal.ui.messages.Messages;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteConnectionWidget
extends Composite {
    public static final String DEFAULT_CONNECTION_NAME = "Remote Host";
    public static int FLAG_FORCE_CONNECTION_TYPE_SELECTION = 1;
    public static int FLAG_NO_LOCAL_SELECTION = 2;
    private Combo fConnectionTypeCombo;
    private Button fLocalButton;
    private Button fRemoteButton;
    private final Combo fConnectionCombo;
    private final Button fNewConnectionButton;
    private List<IRemoteConnectionType> fConnectionTypes;
    private IRemoteConnection fSelectedConnection;
    private IRemoteServicesManager fRemoteServicesManager = RemoteUIPlugin.getService(IRemoteServicesManager.class);
    private IRemoteConnectionType fDefaultConnectionType;
    private boolean fSelectionListernersEnabled = true;
    private boolean fEnabled = true;
    private final ListenerList fSelectionListeners = new ListenerList();
    private final WidgetListener fWidgetListener = new WidgetListener();

    public RemoteConnectionWidget(Composite parent, int style, String title, int flags) {
        this(parent, style, title, flags, null, null);
    }

    public RemoteConnectionWidget(Composite parent, int style, String title, int flags, IRunnableContext context) {
        this(parent, style, title, flags, context, null);
    }

    public RemoteConnectionWidget(Composite parent, int style, String title, int flags, List<IRemoteConnectionType> connectionTypes) {
        this(parent, style, title, flags, null, connectionTypes);
    }

    public RemoteConnectionWidget(Composite parent, int style, String title, int flags, IRunnableContext context, List<IRemoteConnectionType> connectionTypes) {
        super(parent, style);
        if (connectionTypes != null) {
            flags |= FLAG_FORCE_CONNECTION_TYPE_SELECTION | FLAG_NO_LOCAL_SELECTION;
        }
        RemoteConnectionWidget body = this;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (title != null) {
            Group group = new Group((Composite)this, 0);
            group.setText(title);
            GridLayout groupLayout = new GridLayout(1, false);
            groupLayout.marginHeight = 0;
            groupLayout.marginWidth = 0;
            groupLayout.numColumns = 4;
            group.setLayout((Layout)groupLayout);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            layout.numColumns = 1;
            body = group;
        }
        this.fRemoteServicesManager = RemoteUIPlugin.getService(IRemoteServicesManager.class);
        if (connectionTypes != null) {
            this.fConnectionTypes = connectionTypes;
        } else {
            this.fConnectionTypes = this.fRemoteServicesManager.getRemoteConnectionTypes();
            String id = Preferences.getString((String)"connectionTypeId");
            if (id != null) {
                this.fDefaultConnectionType = this.fRemoteServicesManager.getConnectionType(id);
            }
        }
        if ((flags & FLAG_FORCE_CONNECTION_TYPE_SELECTION) != 0) {
            Label label = new Label((Composite)body, 0);
            label.setText(Messages.RemoteConnectionWidget_Connection_Type);
            label.setLayoutData((Object)new GridData());
            this.fConnectionTypeCombo = new Combo((Composite)body, 12);
            GridData gd = new GridData(4, 0x1000000, true, false);
            gd.horizontalSpan = 3;
            this.fConnectionTypeCombo.setLayoutData((Object)gd);
            this.fConnectionTypeCombo.addSelectionListener((SelectionListener)this.fWidgetListener);
            this.fConnectionTypeCombo.setFocus();
        }
        if ((flags & FLAG_NO_LOCAL_SELECTION) == 0 && (flags & FLAG_FORCE_CONNECTION_TYPE_SELECTION) == 0) {
            this.fLocalButton = new Button((Composite)body, 16);
            this.fLocalButton.setText(Messages.RemoteConnectionWidget_Local);
            this.fLocalButton.setLayoutData((Object)new GridData());
            this.fLocalButton.addSelectionListener((SelectionListener)this.fWidgetListener);
            this.fLocalButton.setSelection(false);
            this.fRemoteButton = new Button((Composite)body, 16);
            this.fRemoteButton.setText(Messages.RemoteConnectionWidget_Remote);
            this.fRemoteButton.setLayoutData((Object)new GridData());
            this.fRemoteButton.addSelectionListener((SelectionListener)this.fWidgetListener);
        } else {
            Label remoteLabel = new Label((Composite)body, 0);
            remoteLabel.setText(Messages.RemoteConnectionWidget_Connection_Name);
            remoteLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        }
        this.fConnectionCombo = new Combo((Composite)body, 12);
        this.fConnectionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fConnectionCombo.addSelectionListener((SelectionListener)this.fWidgetListener);
        if (this.fDefaultConnectionType != null) {
            this.fConnectionCombo.setFocus();
        }
        this.fConnectionCombo.setEnabled(false);
        this.fNewConnectionButton = new Button((Composite)body, 8);
        this.fNewConnectionButton.setText(Messages.RemoteConnectionWidget_New);
        this.fNewConnectionButton.setLayoutData((Object)new GridData());
        this.fNewConnectionButton.addSelectionListener((SelectionListener)this.fWidgetListener);
        if (this.fConnectionTypeCombo != null) {
            this.initializeConnectionTypeCombo();
        }
        this.handleConnectionTypeSelected(null);
        if (this.fLocalButton != null) {
            this.handleButtonSelected();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    @SafeVarargs
    public final void filterConnections(Class<? extends IRemoteConnection.Service> ... services) {
        this.fConnectionTypes = this.fRemoteServicesManager.getConnectionTypesSupporting((Class[])services);
        if (this.fConnectionTypeCombo != null) {
            this.initializeConnectionTypeCombo();
        }
        this.handleConnectionTypeSelected(null);
    }

    public Button getButton() {
        return this.fNewConnectionButton;
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    private IRemoteConnectionType getSelectedConnectionType() {
        if (this.fConnectionTypeCombo != null) {
            int selectionIndex = this.fConnectionTypeCombo.getSelectionIndex();
            if (this.fConnectionTypes.size() > 0 && selectionIndex > 0) {
                return this.fConnectionTypes.get(selectionIndex - 1);
            }
        }
        if (this.fDefaultConnectionType != null) {
            return this.fDefaultConnectionType;
        }
        return null;
    }

    private IRemoteUIConnectionService getUIConnectionManager() {
        IRemoteConnectionType services = this.getSelectedConnectionType();
        if (services != null) {
            return (IRemoteUIConnectionService)services.getService(IRemoteUIConnectionService.class);
        }
        return null;
    }

    private void handleButtonSelected() {
        this.fRemoteButton.setSelection(!this.fLocalButton.getSelection());
        this.updateEnablement();
        this.handleConnectionSelected();
    }

    protected void handleConnectionSelected() {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        IRemoteConnection selectedConnection = null;
        if (this.fLocalButton != null && this.fLocalButton.getSelection()) {
            selectedConnection = (IRemoteConnection)this.fRemoteServicesManager.getLocalConnectionType().getConnections().get(0);
        } else {
            int currentSelection = this.fConnectionCombo.getSelectionIndex();
            if (currentSelection > 0) {
                String connectionName = this.fConnectionCombo.getItem(currentSelection);
                selectedConnection = this.getSelectedConnectionType().getConnection(connectionName);
            }
        }
        if (selectedConnection == null || this.fSelectedConnection == null || !selectedConnection.getName().equals(this.fSelectedConnection.getName())) {
            this.fSelectedConnection = selectedConnection;
            Event evt = new Event();
            evt.widget = this;
            this.notifyListeners(new SelectionEvent(evt));
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    protected void handleNewRemoteConnectionSelected() {
        IRemoteUIConnectionWizard wizard;
        if (this.getUIConnectionManager() != null && (wizard = this.getUIConnectionManager().getConnectionWizard(this.getShell())) != null) {
            wizard.setConnectionName(this.initialConnectionName());
            IRemoteConnectionWorkingCopy conn = wizard.open();
            if (conn != null) {
                try {
                    this.handleConnectionTypeSelected(conn.save());
                    this.handleConnectionSelected();
                }
                catch (CoreException e) {
                    RemoteUIPlugin.log(e);
                }
            }
        }
    }

    protected void handleConnectionTypeSelected(IRemoteConnection conn) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        try {
            IRemoteConnectionType selectedConnectionType = this.getSelectedConnectionType();
            if (conn != null) {
                selectedConnectionType = conn.getConnectionType();
            }
            if (this.fDefaultConnectionType == null && conn != null) {
                int index = 0;
                while (index < this.fConnectionTypes.size()) {
                    if (this.fConnectionTypes.get(index).getId().equals(selectedConnectionType.getId())) {
                        this.fConnectionTypeCombo.select(index + 1);
                        break;
                    }
                    ++index;
                }
            }
            this.fConnectionCombo.removeAll();
            this.fConnectionCombo.add(Messages.RemoteConnectionWidget_selectConnection);
            if (selectedConnectionType == null) {
                this.fConnectionCombo.select(0);
                this.fConnectionCombo.setEnabled(false);
                this.fNewConnectionButton.setEnabled(false);
                this.handleConnectionSelected();
            } else {
                this.fConnectionCombo.setEnabled(true);
                int selected = 0;
                int offset = 1;
                List sorted = selectedConnectionType.getConnections();
                Collections.sort(sorted, new Comparator<IRemoteConnection>(){

                    @Override
                    public int compare(IRemoteConnection o1, IRemoteConnection o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (IRemoteConnection s : sorted) {
                    this.fConnectionCombo.add(s.getName());
                    if (conn != null && s.getName().equals(conn.getName())) {
                        selected = offset;
                    }
                    ++offset;
                }
                this.fConnectionCombo.select(selected);
                this.handleConnectionSelected();
                this.fNewConnectionButton.setEnabled(selectedConnectionType.canAdd());
            }
        }
        finally {
            this.fWidgetListener.setEnabled(enabled);
        }
    }

    private String initialConnectionName() {
        String name = DEFAULT_CONNECTION_NAME;
        int count = 1;
        while (this.getSelectedConnectionType().getConnection(name) != null) {
            name = "Remote Host " + count++;
        }
        return name;
    }

    protected void initializeConnectionTypeCombo() {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        this.fConnectionTypeCombo.removeAll();
        int offset = 1;
        int defIndex = 0;
        this.fConnectionTypeCombo.add(Messages.RemoteConnectionWidget_selectConnectionType);
        int i = 0;
        while (i < this.fConnectionTypes.size()) {
            this.fConnectionTypeCombo.add(this.fConnectionTypes.get(i).getName());
            if (this.fDefaultConnectionType != null && this.fConnectionTypes.get(i).equals(this.fDefaultConnectionType)) {
                defIndex = i + offset;
            }
            ++i;
        }
        if (this.fConnectionTypes.size() > 0) {
            this.fConnectionTypeCombo.select(defIndex);
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    private void notifyListeners(SelectionEvent e) {
        if (this.fSelectionListernersEnabled) {
            Object[] objectArray = this.fSelectionListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((SelectionListener)listener).widgetSelected(e);
                ++n2;
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteConnection connection) {
        this.fSelectionListernersEnabled = false;
        if (this.fLocalButton != null && connection != null && connection.getConnectionType() == this.fRemoteServicesManager.getLocalConnectionType()) {
            this.fLocalButton.setSelection(true);
            this.handleButtonSelected();
        } else {
            this.handleConnectionTypeSelected(connection);
        }
        this.handleConnectionSelected();
        this.updateEnablement();
        this.fSelectionListernersEnabled = true;
    }

    public void setConnection(String id, String name) {
        IRemoteConnection connection;
        IRemoteConnectionType connectionType = this.fRemoteServicesManager.getConnectionType(id);
        if (connectionType != null && (connection = connectionType.getConnection(name)) != null) {
            this.setConnection(connection);
        }
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.updateEnablement();
    }

    private void updateEnablement() {
        if (this.fDefaultConnectionType != null) {
            boolean isRemote = true;
            if (this.fLocalButton != null) {
                this.fLocalButton.setEnabled(this.fEnabled);
                this.fRemoteButton.setEnabled(this.fEnabled);
                isRemote = !this.fLocalButton.getSelection();
            }
            this.fConnectionCombo.setEnabled(this.fEnabled && isRemote);
            this.fNewConnectionButton.setEnabled(this.fEnabled && isRemote && this.fDefaultConnectionType.canAdd());
        } else {
            IRemoteConnectionType services = this.getSelectedConnectionType();
            this.fConnectionCombo.setEnabled(this.fEnabled && services != null);
            this.fNewConnectionButton.setEnabled(this.fEnabled && services != null && services.canAdd());
            if (this.fConnectionTypeCombo != null) {
                this.fConnectionTypeCombo.setEnabled(this.fEnabled);
            }
        }
    }

    protected class WidgetListener
    implements SelectionListener {
        private boolean listenerEnabled = true;

        protected WidgetListener() {
        }

        public void disable() {
            this.setEnabled(false);
        }

        protected void doWidgetDefaultSelected(SelectionEvent e) {
        }

        public void enable() {
            this.setEnabled(true);
        }

        public synchronized boolean isEnabled() {
            return this.listenerEnabled;
        }

        public synchronized void setEnabled(boolean enabled) {
            this.listenerEnabled = enabled;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                this.widgetSelected(e);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                Object source = e.getSource();
                if (source == RemoteConnectionWidget.this.fConnectionTypeCombo) {
                    RemoteConnectionWidget.this.handleConnectionTypeSelected(null);
                } else if (source == RemoteConnectionWidget.this.fConnectionCombo) {
                    RemoteConnectionWidget.this.handleConnectionSelected();
                } else if (source == RemoteConnectionWidget.this.fNewConnectionButton) {
                    RemoteConnectionWidget.this.handleNewRemoteConnectionSelected();
                } else if (source == RemoteConnectionWidget.this.fLocalButton) {
                    RemoteConnectionWidget.this.handleButtonSelected();
                } else if (source == RemoteConnectionWidget.this.fRemoteButton) {
                    RemoteConnectionWidget.this.handleButtonSelected();
                }
            }
        }
    }
}

