/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.ICommentSourceBuilderSpi;
import org.eclipse.scout.sdk.core.util.SdkConsole;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.classid.ClassIdValidationJob;
import org.eclipse.scout.sdk.s2e.ui.internal.ScoutImageRegistry;
import org.eclipse.scout.sdk.s2e.ui.internal.WorkbenchSdkConsoleSpi;
import org.eclipse.scout.sdk.s2e.ui.internal.util.JdtSettingsCommentSourceBuilderDelegate;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class S2ESdkUiActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.sdk.s2e.ui";
    public static final String IMAGE_PATH = "icons/";
    private static S2ESdkUiActivator plugin;
    private IPropertyChangeListener m_preferencesPropertyListener;
    private DetailFormatter m_iDataObjectDetailFormatter;

    public void start(BundleContext context) throws Exception {
        boolean isLoggingConfiguredInWorkspace;
        super.start(context);
        plugin = this;
        this.getPreferenceStore().setDefault("org.eclipse.scout.sdk.propLogLevel", SdkLog.DEFAULT_LOG_LEVEL.getName());
        boolean isLoggingConfiguredInSystem = StringUtils.isNotBlank((CharSequence)System.getProperty("org.eclipse.scout.sdk.propLogLevel"));
        boolean bl = isLoggingConfiguredInWorkspace = !this.getPreferenceStore().isDefault("org.eclipse.scout.sdk.propLogLevel");
        if (!isLoggingConfiguredInWorkspace && !isLoggingConfiguredInSystem && (Platform.inDebugMode() || Platform.inDevelopmentMode())) {
            SdkLog.setLogLevel((Level)Level.ALL);
        } else if (isLoggingConfiguredInWorkspace) {
            SdkLog.setLogLevel((String)this.getPreferenceStore().getString("org.eclipse.scout.sdk.propLogLevel"));
        }
        SdkConsole.setConsoleSpi((SdkConsole.ISdkConsoleSpi)new WorkbenchSdkConsoleSpi());
        CommentSourceBuilderFactory.setCommentSourceBuilderSpi((ICommentSourceBuilderSpi)new JdtSettingsCommentSourceBuilderDelegate());
        if (this.m_preferencesPropertyListener == null) {
            this.m_preferencesPropertyListener = new P_PreferenceStorePropertyListener();
        }
        this.getPreferenceStore().addPropertyChangeListener(this.m_preferencesPropertyListener);
        S2ESdkUiActivator.setDefaultMavenSettings();
        this.registerDetailFormatters();
        this.getPreferenceStore().setDefault("org.eclipse.scout.sdk.propAutoUpdate", true);
        ScoutSdkCore.getDerivedResourceManager().setEnabled(this.getPreferenceStore().getBoolean("org.eclipse.scout.sdk.propAutoUpdate"));
        this.getPreferenceStore().setDefault("org.eclipse.scout.sdk.propAutoCreateClassId", false);
        ClassIdGenerators.setAutomaticallyCreateClassIdAnnotation((boolean)this.getPreferenceStore().getBoolean("org.eclipse.scout.sdk.propAutoCreateClassId"));
        ClassIdValidationJob.executeAsync((long)TimeUnit.MINUTES.toMillis(5L), (boolean)false);
    }

    private void registerDetailFormatters() {
        String src = "return org.eclipse.scout.rt.platform.BEANS.get(org.eclipse.scout.rt.platform.dataobject.IPrettyPrintDataObjectMapper.class).writeValue(this);";
        this.m_iDataObjectDetailFormatter = new DetailFormatter("org.eclipse.scout.rt.platform.dataobject.IDataObject", src, true);
        JavaDetailFormattersManager.getDefault().setAssociatedDetailFormatter(this.m_iDataObjectDetailFormatter);
    }

    private void deregisterDetailFormatters() {
        this.m_iDataObjectDetailFormatter = null;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.m_preferencesPropertyListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.m_preferencesPropertyListener);
            this.m_preferencesPropertyListener = null;
        }
        CommentSourceBuilderFactory.setCommentSourceBuilderSpi(null);
        SdkConsole.setConsoleSpi(null);
        this.deregisterDetailFormatters();
        plugin = null;
        super.stop(context);
    }

    public static S2ESdkUiActivator getDefault() {
        return plugin;
    }

    private static void setDefaultMavenSettings() {
        try {
            M2EUIPluginActivator m2eUiActivator = M2EUIPluginActivator.getDefault();
            if (m2eUiActivator == null) {
                return;
            }
            IPreferenceStore m2eUiPrefs = m2eUiActivator.getPreferenceStore();
            if (m2eUiPrefs == null) {
                return;
            }
            if (m2eUiPrefs.isDefault("eclipse.m2.downloadSources") && !m2eUiPrefs.getBoolean("eclipse.m2.downloadSources")) {
                m2eUiPrefs.setDefault("eclipse.m2.downloadSources", true);
                m2eUiPrefs.firePropertyChangeEvent("eclipse.m2.downloadSources", (Object)Boolean.FALSE, (Object)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            SdkLog.info((String)"Unable to set default maven options", (Object[])new Object[]{e});
        }
    }

    protected ScoutImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ScoutImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ScoutImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    public ScoutImageRegistry getImageRegistry() {
        return (ScoutImageRegistry)super.getImageRegistry();
    }

    public static Image getImage(String name) {
        return S2ESdkUiActivator.getDefault().getImageImpl(name);
    }

    private Image getImageImpl(String name) {
        Image image = this.getImageRegistry().get(name);
        if (image == null) {
            ImageDescriptor desc = S2ESdkUiActivator.getImageDescriptor(name);
            this.getImageRegistry().put(name, desc);
            image = this.getImageRegistry().get(name);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + fileName));
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    private static final class P_PreferenceStorePropertyListener
    implements IPropertyChangeListener {
        private P_PreferenceStorePropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object newValue = event.getNewValue();
            if ("org.eclipse.scout.sdk.propAutoUpdate".equals(event.getProperty())) {
                boolean autoUpdate = newValue == null || Boolean.parseBoolean(newValue.toString());
                ScoutSdkCore.getDerivedResourceManager().setEnabled(autoUpdate);
            } else if ("org.eclipse.scout.sdk.propAutoCreateClassId".equals(event.getProperty())) {
                boolean automaticallyCreate = newValue != null && Boolean.parseBoolean(newValue.toString());
                ClassIdGenerators.setAutomaticallyCreateClassIdAnnotation((boolean)automaticallyCreate);
            } else if ("org.eclipse.scout.sdk.propLogLevel".equals(event.getProperty())) {
                if (newValue == null) {
                    SdkLog.setInitialLogLevel();
                } else {
                    SdkLog.setLogLevel((String)newValue.toString());
                }
            }
        }
    }
}

