/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.base;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.Messages;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;

public class TmfVertex
implements Comparable<TmfVertex> {
    private static final String UNKNOWN_EDGE_DIRECTION_TYPE = "Unknown edge direction type : ";
    private static long count = 0L;
    public static Comparator<TmfVertex> ascending = new Comparator<TmfVertex>(){

        @Override
        public int compare(@Nullable TmfVertex v1, @Nullable TmfVertex v2) {
            if (v1 == null) {
                return 1;
            }
            if (v2 == null) {
                return -1;
            }
            return Long.compare(v1.getTs(), v2.getTs());
        }
    };
    public static Comparator<TmfVertex> descending = new Comparator<TmfVertex>(){

        @Override
        public int compare(@Nullable TmfVertex v1, @Nullable TmfVertex v2) {
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return Long.compare(v2.getTs(), v1.getTs());
        }
    };
    private @Nullable TmfEdge fOutgoingVertical = null;
    private @Nullable TmfEdge fIncomingVertical = null;
    private @Nullable TmfEdge fOutgoingHorizontal = null;
    private @Nullable TmfEdge fIncomingHorizontal = null;
    private final long fTimestamp;
    private final long fId;

    public TmfVertex() {
        this(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfVertex(long ts) {
        this.fTimestamp = ts;
        Class<TmfVertex> clazz = TmfVertex.class;
        synchronized (TmfVertex.class) {
            this.fId = count++;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public TmfVertex(TmfVertex node) {
        this(node.fTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfVertex(TmfVertex node, long ts) {
        this.fTimestamp = ts;
        Class<TmfVertex> clazz = TmfVertex.class;
        synchronized (TmfVertex.class) {
            this.fId = count++;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            this.fOutgoingVertical = node.fOutgoingVertical;
            this.fIncomingVertical = node.fIncomingVertical;
            this.fOutgoingHorizontal = node.fOutgoingHorizontal;
            this.fIncomingHorizontal = node.fIncomingHorizontal;
            return;
        }
    }

    public long getTs() {
        return this.fTimestamp;
    }

    public long getID() {
        return this.fId;
    }

    public TmfEdge linkHorizontal(TmfVertex to) {
        this.checkTimestamps(to);
        this.checkNotSelf(to);
        return this.linkHorizontalRaw(to);
    }

    public TmfEdge linkHorizontal(TmfVertex to, TmfEdge.EdgeType type, @Nullable String linkQualifier) {
        this.checkTimestamps(to);
        this.checkNotSelf(to);
        TmfEdge link = this.linkHorizontalRaw(to);
        link.setType(type, linkQualifier);
        return link;
    }

    private TmfEdge linkHorizontalRaw(TmfVertex node) {
        TmfEdge link;
        this.fOutgoingHorizontal = link = new TmfEdge(this, node);
        node.fIncomingHorizontal = link;
        return link;
    }

    public TmfEdge linkVertical(TmfVertex to) {
        this.checkTimestamps(to);
        this.checkNotSelf(to);
        return this.linkVerticalRaw(to);
    }

    public TmfEdge linkVertical(TmfVertex to, TmfEdge.EdgeType type, @Nullable String linkQualifier) {
        this.checkTimestamps(to);
        this.checkNotSelf(to);
        TmfEdge link = this.linkVerticalRaw(to);
        link.setType(type, linkQualifier);
        return link;
    }

    private TmfEdge linkVerticalRaw(TmfVertex to) {
        TmfEdge link;
        this.fOutgoingVertical = link = new TmfEdge(this, to);
        to.fIncomingVertical = link;
        return link;
    }

    private void checkTimestamps(TmfVertex to) {
        if (this.fTimestamp > to.fTimestamp) {
            throw new IllegalArgumentException(String.valueOf(Messages.TmfVertex_ArgumentTimestampLower) + String.format(": (curr=%d,next=%d,elapsed=%d)", this.fTimestamp, to.fTimestamp, to.fTimestamp - this.fTimestamp));
        }
    }

    private void checkNotSelf(TmfVertex to) {
        if (this == to) {
            throw new IllegalArgumentException(Messages.TmfVertex_CannotLinkToSelf);
        }
    }

    public @Nullable TmfEdge getEdge(EdgeDirection dir) {
        switch (dir) {
            case OUTGOING_VERTICAL_EDGE: {
                return this.fOutgoingVertical;
            }
            case INCOMING_VERTICAL_EDGE: {
                return this.fIncomingVertical;
            }
            case OUTGOING_HORIZONTAL_EDGE: {
                return this.fOutgoingHorizontal;
            }
            case INCOMING_HORIZONTAL_EDGE: {
                return this.fIncomingHorizontal;
            }
        }
        throw new IllegalStateException(UNKNOWN_EDGE_DIRECTION_TYPE + (Object)((Object)dir));
    }

    public void removeEdge(EdgeDirection dir) {
        switch (dir) {
            case OUTGOING_VERTICAL_EDGE: {
                this.fOutgoingVertical = null;
                break;
            }
            case INCOMING_VERTICAL_EDGE: {
                this.fIncomingVertical = null;
                break;
            }
            case OUTGOING_HORIZONTAL_EDGE: {
                this.fOutgoingHorizontal = null;
                break;
            }
            case INCOMING_HORIZONTAL_EDGE: {
                this.fIncomingHorizontal = null;
                break;
            }
            default: {
                throw new IllegalStateException(UNKNOWN_EDGE_DIRECTION_TYPE + (Object)((Object)dir));
            }
        }
    }

    public static TmfVertex getNeighborFromEdge(TmfEdge edge, EdgeDirection dir) {
        switch (dir) {
            case OUTGOING_VERTICAL_EDGE: 
            case OUTGOING_HORIZONTAL_EDGE: {
                return edge.getVertexTo();
            }
            case INCOMING_VERTICAL_EDGE: 
            case INCOMING_HORIZONTAL_EDGE: {
                return edge.getVertexFrom();
            }
        }
        throw new IllegalStateException(UNKNOWN_EDGE_DIRECTION_TYPE + (Object)((Object)dir));
    }

    @Override
    public int compareTo(@Nullable TmfVertex other) {
        if (other == null) {
            return 1;
        }
        return Long.compare(this.fTimestamp, other.fTimestamp);
    }

    public String toString() {
        return "[" + this.fId + "," + this.fTimestamp + "]";
    }

    public static enum EdgeDirection {
        OUTGOING_VERTICAL_EDGE,
        INCOMING_VERTICAL_EDGE,
        OUTGOING_HORIZONTAL_EDGE,
        INCOMING_HORIZONTAL_EDGE;

    }
}

