/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.xml;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTraceTypeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TmfFilterContentHandler
extends DefaultHandler {
    private static final String EVENTTYPE_NODE_NAME = "EVENTTYPE";
    private static final String NAME_ATTR = "name";
    private static final String LTTNG_KERNEL_TRACE = "Common Trace Format : LTTng Kernel Trace";
    private static final String LINUX_KERNEL_TRACE = "Common Trace Format : Linux Kernel Trace";
    private static final String FIELD_ATTR = "field";
    private static final String EVENT_FIELD_TIMESTAMP = ":timestamp:";
    private static final String EVENT_FIELD_TYPE = ":type:";
    private static final String EVENT_FIELD_CONTENT = ":content:";
    private ITmfFilterTreeNode fRoot = null;
    private final Deque<ITmfFilterTreeNode> fFilterTreeStack = new ArrayDeque<ITmfFilterTreeNode>();

    public ITmfFilterTreeNode getTree() {
        return this.fRoot;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        TmfFilterTreeNode node = null;
        if (localName.equalsIgnoreCase("ROOT")) {
            node = new TmfFilterRootNode();
        } else if (localName.equals("FILTER")) {
            node = new TmfFilterNode(atts.getValue(NAME_ATTR));
        } else if (localName.equals("TRACETYPE")) {
            node = new TmfFilterTraceTypeNode(null);
            String traceTypeId = atts.getValue("type");
            traceTypeId = TmfTraceType.buildCompatibilityTraceTypeId(traceTypeId);
            ((TmfFilterTraceTypeNode)node).setTraceTypeId(traceTypeId);
            TraceTypeHelper helper = TmfTraceType.getTraceType(traceTypeId);
            if (helper != null) {
                ((TmfFilterTraceTypeNode)node).setTraceClass(helper.getTraceClass());
            }
            ((TmfFilterTraceTypeNode)node).setName(atts.getValue(NAME_ATTR));
        } else if (localName.equals("AND")) {
            node = new TmfFilterAndNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterAndNode)node).setNot(true);
            }
        } else if (localName.equals("OR")) {
            node = new TmfFilterOrNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterOrNode)node).setNot(true);
            }
        } else if (localName.equals("CONTAINS")) {
            node = new TmfFilterContainsNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterContainsNode)node).setNot(true);
            }
            TmfFilterContentHandler.createEventAspect((TmfFilterAspectNode)node, atts);
            ((TmfFilterContainsNode)node).setValue(atts.getValue("value"));
            value = atts.getValue("ignorecase");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterContainsNode)node).setIgnoreCase(true);
            }
        } else if (localName.equals("EQUALS")) {
            node = new TmfFilterEqualsNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterEqualsNode)node).setNot(true);
            }
            TmfFilterContentHandler.createEventAspect((TmfFilterAspectNode)node, atts);
            ((TmfFilterEqualsNode)node).setValue(atts.getValue("value"));
            value = atts.getValue("ignorecase");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterEqualsNode)node).setIgnoreCase(true);
            }
        } else if (localName.equals("MATCHES")) {
            node = new TmfFilterMatchesNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterMatchesNode)node).setNot(true);
            }
            TmfFilterContentHandler.createEventAspect((TmfFilterAspectNode)node, atts);
            ((TmfFilterMatchesNode)node).setRegex(atts.getValue("regex"));
        } else if (localName.equals("COMPARE")) {
            node = new TmfFilterCompareNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterCompareNode)node).setNot(true);
            }
            TmfFilterContentHandler.createEventAspect((TmfFilterAspectNode)node, atts);
            value = atts.getValue("type");
            if (value != null) {
                ((TmfFilterCompareNode)node).setType(TmfFilterCompareNode.Type.valueOf(value));
            }
            if ((value = atts.getValue("result")) != null) {
                if (value.equals(Integer.toString(-1))) {
                    ((TmfFilterCompareNode)node).setResult(-1);
                } else if (value.equals(Integer.toString(1))) {
                    ((TmfFilterCompareNode)node).setResult(1);
                } else {
                    ((TmfFilterCompareNode)node).setResult(0);
                }
            }
            ((TmfFilterCompareNode)node).setValue(atts.getValue("value"));
        } else if (localName.equals(EVENTTYPE_NODE_NAME)) {
            node = new TmfFilterTraceTypeNode(null);
            String label = atts.getValue(NAME_ATTR);
            if (label != null) {
                String traceTypeId;
                TraceTypeHelper helper;
                if (label.equals(LTTNG_KERNEL_TRACE)) {
                    label = LINUX_KERNEL_TRACE;
                }
                if ((helper = TmfTraceType.getTraceType(traceTypeId = TmfTraceType.getTraceTypeId(label))) == null) {
                    for (TraceTypeHelper h : TmfTraceType.getTraceTypeHelpers()) {
                        if (!h.getName().equals(label)) continue;
                        label = h.getLabel();
                        helper = h;
                        break;
                    }
                }
                if (helper != null) {
                    ((TmfFilterTraceTypeNode)node).setTraceTypeId(helper.getTraceTypeId());
                    ((TmfFilterTraceTypeNode)node).setTraceClass(helper.getTraceClass());
                }
                ((TmfFilterTraceTypeNode)node).setName(label);
            }
        }
        this.fFilterTreeStack.addFirst(node);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ITmfFilterTreeNode node = this.fFilterTreeStack.removeFirst();
        ITmfFilterTreeNode last = this.fFilterTreeStack.peekFirst();
        if (this.fFilterTreeStack.isEmpty()) {
            this.fRoot = node;
        } else if (last instanceof TmfFilterTreeNode && node instanceof TmfFilterTreeNode) {
            last.addChild(node);
        }
    }

    private static void createEventAspect(TmfFilterAspectNode node, Attributes atts) {
        String traceTypeId = atts.getValue("tracetypeid");
        traceTypeId = TmfTraceType.buildCompatibilityTraceTypeId(traceTypeId);
        String name = atts.getValue("eventaspect");
        if ("BASE.ASPECT.ID".equals(traceTypeId)) {
            for (ITmfEventAspect<?> eventAspect : TmfBaseAspects.getBaseAspects()) {
                String field;
                if (!eventAspect.getName().equals(name)) continue;
                node.setEventAspect(eventAspect);
                node.setTraceTypeId(traceTypeId);
                if (eventAspect instanceof TmfEventFieldAspect && (field = atts.getValue(FIELD_ATTR)) != null && !field.isEmpty()) {
                    node.setEventAspect(((TmfEventFieldAspect)eventAspect).forField(field));
                }
                break;
            }
        } else if (traceTypeId != null && name != null) {
            TraceTypeHelper helper = TmfTraceType.getTraceType(traceTypeId);
            if (helper != null) {
                for (ITmfEventAspect<?> eventAspect : helper.getTrace().getEventAspects()) {
                    String field;
                    if (!eventAspect.getName().equals(name)) continue;
                    node.setEventAspect(eventAspect);
                    node.setTraceTypeId(traceTypeId);
                    if (eventAspect instanceof TmfEventFieldAspect && (field = atts.getValue(FIELD_ATTR)) != null && !field.isEmpty()) {
                        node.setEventAspect(((TmfEventFieldAspect)eventAspect).forField(field));
                    }
                    break;
                }
            }
        } else {
            String field = atts.getValue(FIELD_ATTR);
            if (field != null) {
                if (field.equals(EVENT_FIELD_TIMESTAMP)) {
                    node.setEventAspect(TmfBaseAspects.getTimestampAspect());
                    node.setTraceTypeId("BASE.ASPECT.ID");
                } else if (field.equals(EVENT_FIELD_TYPE)) {
                    node.setEventAspect(TmfBaseAspects.getEventTypeAspect());
                    node.setTraceTypeId("BASE.ASPECT.ID");
                } else if (field.equals(EVENT_FIELD_CONTENT)) {
                    node.setEventAspect(TmfBaseAspects.getContentsAspect());
                    node.setTraceTypeId("BASE.ASPECT.ID");
                } else {
                    node.setEventAspect(TmfBaseAspects.getContentsAspect().forField(field));
                    node.setTraceTypeId("BASE.ASPECT.ID");
                }
            }
        }
    }
}

