/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineManager;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.ViatraQueryEngineContentProvider;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.ViatraQueryEngineLabelProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class OpenManagedEngineHandler extends AbstractHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    final IViewPart resultView = HandlerUtil.getActiveSite(event).getPage().findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      QueryResultView queryResultView = ((QueryResultView)resultView);
      final AdvancedViatraQueryEngine engine = this.openDialog(queryResultView.getSite().getShell());
      if ((engine != null)) {
        queryResultView.loadExistingEngine(engine);
      }
    }
    return null;
  }
  
  private AdvancedViatraQueryEngine openDialog(final Shell shell) {
    ViatraQueryEngineContentProvider _viatraQueryEngineContentProvider = new ViatraQueryEngineContentProvider();
    final Procedure1<ViatraQueryEngineContentProvider> _function = (ViatraQueryEngineContentProvider it) -> {
      it.setTraverseResources(true);
      it.setTraverseEObjects(true);
    };
    final ViatraQueryEngineContentProvider contentProvider = ObjectExtensions.<ViatraQueryEngineContentProvider>operator_doubleArrow(_viatraQueryEngineContentProvider, _function);
    ViatraQueryEngineLabelProvider _viatraQueryEngineLabelProvider = new ViatraQueryEngineLabelProvider();
    final ElementTreeSelectionDialog engineSelectionDialog = new ElementTreeSelectionDialog(shell, _viatraQueryEngineLabelProvider, contentProvider);
    engineSelectionDialog.setTitle("Managed engine selection");
    engineSelectionDialog.setMessage("Select a managed engine (root elements of the tree)!");
    engineSelectionDialog.setInput(ViatraQueryEngineManager.getInstance());
    engineSelectionDialog.setHelpAvailable(false);
    engineSelectionDialog.setValidator(new ISelectionStatusValidator() {
      @Override
      public IStatus validate(final Object[] selection) {
        if (((((List<Object>)Conversions.doWrapArray(selection)).size() == 1) && (IterableExtensions.size(Iterables.<AdvancedViatraQueryEngine>filter(((Iterable<?>)Conversions.doWrapArray(selection)), AdvancedViatraQueryEngine.class)) == 1))) {
          return new Status(IStatus.OK, EMFPatternLanguageUIPlugin.ID, 0, "", null);
        } else {
          return new Status(IStatus.ERROR, EMFPatternLanguageUIPlugin.ID, 0, "", null);
        }
      }
    });
    engineSelectionDialog.open();
    final Object[] result = engineSelectionDialog.getResult();
    Iterable<AdvancedViatraQueryEngine> _filter = null;
    if (((Iterable<?>)Conversions.doWrapArray(result))!=null) {
      _filter=Iterables.<AdvancedViatraQueryEngine>filter(((Iterable<?>)Conversions.doWrapArray(result)), AdvancedViatraQueryEngine.class);
    }
    AdvancedViatraQueryEngine _head = null;
    if (_filter!=null) {
      _head=IterableExtensions.<AdvancedViatraQueryEngine>head(_filter);
    }
    return _head;
  }
}
