/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part.menu;

import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public final class AsyncExecutor {
    private final Display m_display = Display.getDefault();
    private final ObjectInfo m_activeObject = GlobalState.getActiveObject();
    private final Runnable m_runnable;
    private boolean m_shouldExecute = true;
    private final Object m_broadcastListener = new ObjectEventListener(){

        @Override
        public void refreshBeforeCreate() throws Exception {
            AsyncExecutor.this.m_shouldExecute = false;
        }
    };
    private final Runnable m_schedulingRunnable = new Runnable(){

        @Override
        public void run() {
            AsyncExecutor.this.m_activeObject.removeBroadcastListener(AsyncExecutor.this.m_broadcastListener);
            if (AsyncExecutor.this.m_shouldExecute) {
                AsyncExecutor.this.m_runnable.run();
            }
        }
    };

    public static void schedule(Runnable runnable) {
        new AsyncExecutor(runnable);
    }

    private AsyncExecutor(Runnable runnable) {
        this.m_runnable = runnable;
        this.m_activeObject.addBroadcastListener(this.m_broadcastListener);
        this.m_display.asyncExec(this.m_schedulingRunnable);
    }
}

