/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import java.util.Map;
import org.eclipse.xtext.validation.CheckType;

public abstract class CheckMode {
    public static final String KEY = "check.mode";
    public static final CheckMode FAST_ONLY = new CheckMode(){

        @Override
        public boolean shouldCheck(CheckType type) {
            return type == CheckType.FAST;
        }

        public String toString() {
            return CheckType.FAST.toString();
        }
    };
    public static final CheckMode NORMAL_ONLY = new CheckMode(){

        @Override
        public boolean shouldCheck(CheckType type) {
            return type == CheckType.NORMAL;
        }

        public String toString() {
            return CheckType.NORMAL.toString();
        }
    };
    public static final CheckMode EXPENSIVE_ONLY = new CheckMode(){

        @Override
        public boolean shouldCheck(CheckType type) {
            return type == CheckType.EXPENSIVE;
        }

        public String toString() {
            return CheckType.EXPENSIVE.toString();
        }
    };
    public static final CheckMode NORMAL_AND_FAST = new CheckMode(){

        @Override
        public boolean shouldCheck(CheckType type) {
            return type == CheckType.NORMAL || type == CheckType.FAST;
        }

        public String toString() {
            return (Object)((Object)CheckType.NORMAL) + "|" + (Object)((Object)CheckType.FAST);
        }
    };
    public static final CheckMode ALL = new CheckMode(){

        @Override
        public boolean shouldCheck(CheckType type) {
            return true;
        }

        public String toString() {
            return "ALL";
        }
    };

    public abstract boolean shouldCheck(CheckType var1);

    public static CheckMode getCheckMode(Map<Object, Object> context) {
        CheckMode checkMode = ALL;
        if (context != null) {
            Object object2 = context.get(KEY);
            if (object2 instanceof CheckMode) {
                checkMode = (CheckMode)object2;
            } else if (object2 != null) {
                throw new IllegalArgumentException("Context object for key check.mode should be of Type " + CheckMode.class.getName() + " but was " + object2.getClass().getName());
            }
        }
        return checkMode;
    }
}

