/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.birt.core.preference.IPreferenceChangeListener;
import org.eclipse.birt.core.preference.PreferenceChangeEvent;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ItemSorter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerContextMenuProvider;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerProvider;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.ResourceAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.dnd.LibraryDragListener;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportElementEntry;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ResourceEntryWrapper;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeListener;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.designer.ui.widget.TreeViewerBackup;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class LibraryExplorerTreeViewPage
extends LibraryExplorerViewPage
implements IValidationListener,
IPreferenceChangeListener,
IResourceChangeListener,
IReportResourceChangeListener {
    private static final String BUNDLE_PROTOCOL = "bundleresource://";
    private TreeViewerBackup libraryBackup;
    private LibraryExplorerContextMenuProvider menuManager = null;
    private boolean allowRefreshing = true;

    public LibraryExplorerTreeViewPage() {
        SessionHandleAdapter.getInstance().getSessionHandle().addResourceChangeListener((IResourceChangeListener)this);
        IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
        if (synchronizer != null) {
            synchronizer.addListener(11, (IReportResourceChangeListener)this);
        }
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initPage();
        this.refreshRoot();
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 770);
        treeViewer.setSorter((ViewerSorter)new ItemSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ReportElementEntry || e2 instanceof ReportElementEntry) {
                    if (e1 instanceof ReportElementEntry) {
                        e1 = ((ReportElementEntry)e1).getReportElement();
                    }
                    if (e2 instanceof ReportElementEntry) {
                        e2 = ((ReportElementEntry)e2).getReportElement();
                    }
                } else if (e1 instanceof ResourceEntry && e2 instanceof ResourceEntry) {
                    boolean isEntry2File;
                    ResourceEntry entry1 = (ResourceEntry)e1;
                    ResourceEntry entry2 = (ResourceEntry)e2;
                    if (entry1 == null || entry2 == null) {
                        return entry1 == null ? -1 : 1;
                    }
                    boolean isEntry1File = entry1.isFile();
                    if (isEntry1File == (isEntry2File = entry2.isFile())) {
                        String name1 = entry1.getName();
                        String name2 = entry2.getName();
                        if (name1 != null && name2 != null) {
                            return name1.toLowerCase().compareTo(name2.toLowerCase());
                        }
                        return name1 == null ? -1 : 1;
                    }
                    return isEntry1File ? 1 : -1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.configTreeViewer(treeViewer);
        return treeViewer;
    }

    protected void configTreeViewer(final TreeViewer treeViewer) {
        ViewsTreeProvider provider = (ViewsTreeProvider)ElementAdapterManager.getAdapter((Object)((Object)this), ViewsTreeProvider.class);
        if (provider == null) {
            provider = new LibraryExplorerProvider();
        }
        treeViewer.setContentProvider((IContentProvider)provider);
        treeViewer.setLabelProvider((IBaseLabelProvider)provider);
        int ops = 5;
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new LibraryDragListener((StructuredViewer)treeViewer));
        treeViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    treeViewer.refresh();
                }
            }
        });
        treeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object input = treeViewer.getInput();
                if (input instanceof Object[]) {
                    Object[] array = (Object[])input;
                    int i = 0;
                    while (i < array.length) {
                        if (array[i] instanceof ResourceEntry) {
                            ((ResourceEntry)array[i]).dispose();
                        }
                        ++i;
                    }
                }
            }
        });
        TreeListener libraryTreeListener = new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                Item item = (Item)e.item;
                if (LibraryExplorerTreeViewPage.this.libraryBackup != null) {
                    LibraryExplorerTreeViewPage.this.libraryBackup.updateCollapsedStatus(treeViewer, item.getData());
                }
            }

            public void treeExpanded(TreeEvent e) {
                Item item = (Item)e.item;
                if (LibraryExplorerTreeViewPage.this.libraryBackup != null) {
                    LibraryExplorerTreeViewPage.this.libraryBackup.updateExpandedStatus(treeViewer, item.getData());
                }
            }
        };
        treeViewer.getTree().addTreeListener(libraryTreeListener);
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LibraryExplorerTreeViewPage.this.handleDoubleClick(event);
            }
        });
        treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                try {
                    LibraryExplorerTreeViewPage.this.handleOpen(event);
                }
                catch (IOException e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        TreeViewer viewer = this.getTreeViewer();
        if (element instanceof ResourceEntryWrapper) {
            switch (((ResourceEntryWrapper)element).getType()) {
                case 0: {
                    return;
                }
            }
        }
        if (viewer.isExpandable(element)) {
            viewer.setExpandedState(element, !viewer.getExpandedState(element));
        }
    }

    protected void handleOpen(OpenEvent event) throws IOException {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)element).isFile()) {
            switch (((ResourceEntryWrapper)element).getType()) {
                case 0: 
                case 2: {
                    File file = null;
                    URL url = ((ResourceEntryWrapper)element).getURL();
                    file = ((ResourceEntryWrapper)element).getEntry() instanceof FragmentResourceEntry ? ResourceAction.convertToFile(Platform.getBundle((String)"org.eclipse.birt.resources").getEntry(url.getPath())) : ResourceAction.convertToFile(url);
                    if (file != null && file.exists() && file.isFile()) {
                        if (((ResourceEntryWrapper)element).getType() == 0) {
                            ResourceAction.openLibrary(this, file, false);
                            break;
                        }
                        if (((ResourceEntryWrapper)element).getType() != 2) break;
                        ResourceAction.openDesigner(this, file, false);
                        break;
                    }
                    if (((ResourceEntryWrapper)element).getType() == 0) {
                        if (!MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.getString((String)"LibraryNotExist.Dialog.Title"), (String)Messages.getString((String)"LibraryNotExist.Dialog.Message"))) break;
                        this.refreshRoot();
                        break;
                    }
                    if (((ResourceEntryWrapper)element).getType() != 2 || !MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Messages.getString((String)"DesignerNotExist.Dialog.Title"), (String)Messages.getString((String)"DesignerNotExist.Dialog.Message"))) break;
                    this.refreshRoot();
                    break;
                }
            }
        }
    }

    protected void initPage() {
        this.createContextMenus();
        final Tree tree = this.getTreeViewer().getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(pt);
                    try {
                        tree.setToolTipText(LibraryExplorerTreeViewPage.this.getTooltip(item));
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    private void createContextMenus() {
        this.menuManager = new LibraryExplorerContextMenuProvider(this);
        Control control = this.getTreeViewer().getControl();
        Menu menu = this.menuManager.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.birt.report.designer.ui.lib.explorer.view", (MenuManager)this.menuManager, this.getSite().getSelectionProvider());
    }

    private String getTooltip(TreeItem item) throws IOException {
        if (item != null) {
            Object object = item.getData();
            if (object instanceof DataSourceHandle || object instanceof DataSetHandle) {
                return Messages.getString((String)"LibraryExplorerTreeViewPage.toolTips.DragAndDropOutline");
            }
            if (object instanceof ThemeHandle) {
                return Messages.getString((String)"LibraryExplorerTreeViewPage.toolTips.DragAndDropLayout");
            }
            if (object instanceof ParameterHandle || object instanceof ParameterGroupHandle || object instanceof EmbeddedImageHandle || object instanceof ReportItemHandle) {
                return Messages.getString((String)"LibraryExplorerTreeViewPage.toolTips.DragAndDropToOutlineORLayout");
            }
            if (object instanceof LibraryHandle) {
                return ((LibraryHandle)object).getFileName();
            }
            if (object instanceof CssStyleSheetHandle) {
                CssStyleSheetHandle CssStyleSheetHandle2 = (CssStyleSheetHandle)object;
                if (CssStyleSheetHandle2.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                    return CssStyleSheetHandle2.getFileName();
                }
                ModuleHandle moudleHandle = CssStyleSheetHandle2.getModule().getModuleHandle();
                URL url = moudleHandle.findResource(CssStyleSheetHandle2.getFileName(), 3);
                if (url != null) {
                    return ResourceAction.convertToFile(url).getAbsolutePath();
                }
            } else {
                if (object instanceof ResourceEntryWrapper) {
                    URL url = ((ResourceEntryWrapper)object).getURL();
                    File file = null;
                    file = ((ResourceEntryWrapper)object).getParent() instanceof FragmentResourceEntry ? ResourceAction.convertToFile(Platform.getBundle((String)"org.eclipse.birt.resources").getEntry(url.getPath())) : ResourceAction.convertToFile(url);
                    return file == null ? null : file.getAbsolutePath();
                }
                if (object instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)object).getType() == 0) {
                    LibraryHandle libHandle = (LibraryHandle)((ResourceEntryWrapper)object).getAdapter(LibraryHandle.class);
                    return libHandle.getFileName();
                }
                if (object instanceof ResourceEntryWrapper && ((ResourceEntryWrapper)object).getType() == 1) {
                    CssStyleSheetHandle cssHandle = (CssStyleSheetHandle)((ResourceEntryWrapper)object).getAdapter(CssStyleSheetHandle.class);
                    if (cssHandle.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                        return cssHandle.getFileName();
                    }
                    ModuleHandle moudleHandle = cssHandle.getModule().getModuleHandle();
                    URL url = moudleHandle.findResource(cssHandle.getFileName(), 3);
                    if (url != null) {
                        return ResourceAction.convertToFile(url).getAbsolutePath();
                    }
                } else {
                    if (object instanceof PathResourceEntry) {
                        URL url = ((PathResourceEntry)object).getURL();
                        return ResourceAction.convertToFile(url).getAbsolutePath();
                    }
                    if (object instanceof FragmentResourceEntry) {
                        URL url = ((FragmentResourceEntry)object).getURL();
                        return ResourceAction.convertToFile(Platform.getBundle((String)"org.eclipse.birt.resources").getEntry(url.getPath())).getAbsolutePath();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        SessionHandleAdapter.getInstance().getSessionHandle().removeResourceChangeListener((IResourceChangeListener)this);
        IReportResourceSynchronizer synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService();
        if (synchronizer != null) {
            synchronizer.removeListener(11, (IReportResourceChangeListener)this);
        }
        this.libraryBackup.dispose();
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
        super.dispose();
    }

    protected boolean isDisposed() {
        Control ctrl = this.getControl();
        return ctrl == null || ctrl.isDisposed();
    }

    public void elementValidated(DesignElementHandle targetElement, ValidationEvent ev) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && !treeViewer.getTree().isDisposed()) {
            treeViewer.refresh();
            treeViewer.setInput((Object)this.getRootEntries());
            this.handleTreeViewerRefresh();
        }
    }

    private void handleTreeViewerRefresh() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.libraryBackup != null) {
            this.libraryBackup.restoreBackup(treeViewer);
        } else {
            this.libraryBackup = new TreeViewerBackup();
            treeViewer.expandToLevel(2);
            this.libraryBackup.updateStatus(treeViewer);
        }
    }

    public void refreshRoot() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && !treeViewer.getTree().isDisposed()) {
            ISelection selection = this.getSelection();
            treeViewer.setSelection(null);
            treeViewer.setInput((Object)this.getRootEntries());
            this.handleTreeViewerRefresh();
            if (selection != null) {
                this.setSelection(selection);
            }
        }
    }

    public void preferenceChange(PreferenceChangeEvent event) {
        if (event.getKey().equals("special to default") || "org.eclipse.birt.report.designer.ui.preferences.resourcestore".equals(event.getKey())) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LibraryExplorerTreeViewPage.this.refreshRoot();
                }
            });
        }
    }

    public void resourceChanged(IReportResourceChangeEvent event) {
        if (event.getType() != 1 && event.getType() != 2 && event.getType() != 8) {
            return;
        }
        if (event.getSource() == this) {
            return;
        }
        if (this.allowRefreshing) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!LibraryExplorerTreeViewPage.this.isDisposed()) {
                        LibraryExplorerTreeViewPage.this.refreshRoot();
                    }
                    LibraryExplorerTreeViewPage.this.allowRefreshing = true;
                }
            });
        }
        this.allowRefreshing = false;
    }

    public void resourceChanged(ModuleHandle module, ResourceChangeEvent event) {
        if (this.isDisposed()) {
            return;
        }
        String path = event.getChangedResourcePath();
        if (path != null) {
            File file = new File(path);
            String resourcePath = ReportPlugin.getDefault().getResourceFolder();
            File resource = new File(resourcePath);
            if (file.exists() && resource.exists() && file.toURI().toString().indexOf(resource.toURI().toString()) > -1) {
                this.refreshRoot();
            }
        }
    }

    public void selectPath(final String[] paths, final boolean forceRefresh) {
        if (paths == null || paths.length <= 0) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer treeViewer = LibraryExplorerTreeViewPage.this.getTreeViewer();
                boolean needSelect = false;
                if (forceRefresh) {
                    LibraryExplorerTreeViewPage.this.refreshRoot();
                }
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    File file = new File(path);
                    if (file.exists()) {
                        needSelect = true;
                        String parent = file.getParent();
                        ArrayList<String> folders = new ArrayList<String>();
                        while (parent != null) {
                            folders.add(parent);
                            parent = new File(parent).getParent();
                        }
                        int i = folders.size() - 1;
                        while (i >= 0) {
                            treeViewer.expandToLevel(folders.get(i), 1);
                            --i;
                        }
                    }
                    ++n2;
                }
                if (needSelect) {
                    treeViewer.setSelection((ISelection)new StructuredSelection((Object[])paths));
                    treeViewer.reveal((Object)paths[0]);
                }
            }
        });
    }

    private ResourceEntry[] getRootEntries() {
        FragmentResourceEntry systemResource = new FragmentResourceEntry();
        ResourceEntry sharedResource = (ResourceEntry)ElementAdapterManager.getAdapter((Object)((Object)this), ResourceEntry.class);
        if (sharedResource == null) {
            sharedResource = new PathResourceEntry();
        }
        if (systemResource.hasChildren()) {
            return new ResourceEntry[]{systemResource, sharedResource};
        }
        return new ResourceEntry[]{sharedResource};
    }
}

