/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.ICellEventHandler;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Cell;
import org.eclipse.birt.report.engine.script.internal.instance.CellInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class CellScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(CellHandle cellHandle, ExecutionContext context) {
        try {
            Cell cell = new Cell(cellHandle);
            ICellEventHandler eh = CellScriptExecutor.getEventHandler(cellHandle, context);
            if (eh != null) {
                eh.onPrepare(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            CellScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ICellContent content, ExecutionContext context, boolean fromGrid) {
        Object generateBy = content.getGenerateBy();
        if (generateBy == null) {
            return;
        }
        ReportItemDesign cellDesign = (ReportItemDesign)generateBy;
        try {
            if (!CellScriptExecutor.needOnCreate(cellDesign)) {
                return;
            }
            CellInstance cell = new CellInstance(content, context, RunningState.CREATE, fromGrid);
            if (CellScriptExecutor.handleScript(cell, cellDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ICellEventHandler eh = CellScriptExecutor.getEventHandler(cellDesign, context);
            if (eh != null) {
                eh.onCreate(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            CellScriptExecutor.addException(context, e, cellDesign.getHandle());
        }
    }

    public static void handleOnRender(ICellContent content, ExecutionContext context) {
        Object generateBy = content.getGenerateBy();
        if (generateBy == null) {
            return;
        }
        ReportItemDesign cellDesign = (ReportItemDesign)generateBy;
        if (!CellScriptExecutor.needOnRender(cellDesign)) {
            return;
        }
        try {
            CellInstance cell = new CellInstance(content, context, RunningState.RENDER, false);
            if (CellScriptExecutor.handleScript(cell, cellDesign.getOnRender(), context).didRun()) {
                return;
            }
            ICellEventHandler eh = CellScriptExecutor.getEventHandler(cellDesign, context);
            if (eh != null) {
                eh.onRender(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            CellScriptExecutor.addException(context, e, cellDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(ICellContent content, ExecutionContext context) {
        Object generateBy = content.getGenerateBy();
        if (generateBy == null) {
            return;
        }
        ReportItemDesign cellDesign = (ReportItemDesign)generateBy;
        if (!CellScriptExecutor.needOnPageBreak(cellDesign, context)) {
            return;
        }
        try {
            CellInstance cell = new CellInstance(content, context, RunningState.RENDER, false);
            if (CellScriptExecutor.handleScript(cell, cellDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ICellEventHandler eh = CellScriptExecutor.getEventHandler(cellDesign, context);
            if (eh != null) {
                eh.onPageBreak(cell, context.getReportContext());
            }
        }
        catch (Exception e) {
            CellScriptExecutor.addException(context, e, cellDesign.getHandle());
        }
    }

    private static ICellEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (ICellEventHandler)CellScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            CellScriptExecutor.addClassCastException(context, e, design.getHandle(), ICellEventHandler.class);
        }
        catch (EngineException e) {
            CellScriptExecutor.addException(context, (Exception)((Object)e), design.getHandle());
        }
        return null;
    }

    private static ICellEventHandler getEventHandler(CellHandle handle, ExecutionContext context) {
        try {
            return (ICellEventHandler)CellScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            CellScriptExecutor.addClassCastException(context, e, (DesignElementHandle)handle, ICellEventHandler.class);
        }
        catch (EngineException e) {
            CellScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)handle);
        }
        return null;
    }
}

