/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.HashSet;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.BigNumericLiteral;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.FloatNumericLiteral;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ruby.ast.RubyConstantDeclaration;
import org.eclipse.dltk.ruby.ast.RubyDAssgnExpression;
import org.eclipse.dltk.ruby.ast.RubyDRegexpExpression;
import org.eclipse.dltk.ruby.ast.RubyDVarExpression;
import org.eclipse.dltk.ruby.ast.RubyDynamicStringExpression;
import org.eclipse.dltk.ruby.ast.RubyEvaluatableStringExpression;
import org.eclipse.dltk.ruby.ast.RubyRegexpExpression;
import org.eclipse.dltk.ruby.ast.RubySymbolReference;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.ui.text.RubyCodeScanner;
import org.eclipse.dltk.ruby.internal.ui.text.RubySemanticHighlighting;
import org.eclipse.dltk.ruby.ui.preferences.RubyPreferencesMessages;
import org.eclipse.dltk.ui.editor.highlighting.AbortSemanticHighlightingException;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighterExtension;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;

public class RubySemanticUpdateWorker
extends ASTVisitor
implements ISemanticHighlighter,
ISemanticHighlighterExtension {
    private static final String HL_REGEXP = "DLTK_string.regexp";
    private static final String HL_STRING = "DLTK_string";
    private static final String HL_SYMBOL = "ruby.symbols";
    private static final String HL_LOCAL_VARIABLE = "variable";
    private static final String HL_INSTANCE_VARIABLE = "variable.instance";
    private static final String HL_CLASS_VARIABLE = "variable.class";
    private static final String HL_GLOBAL_VARIABLE = "variable.global";
    private static final String HL_CONST = "const";
    private static final String HL_NUMBER = "DLTK_number";
    private static final String HL_EVAL_EXPR = "DLTK_string.eval";
    private static final String HL_DEFAULT = "DLTK_default";
    private ISemanticHighlightingRequestor requestor;
    private char[] content;
    private static final boolean ACTIVE = true;
    private final Stack<ASTNode> stack = new Stack();

    public SemanticHighlighting[] getSemanticHighlightings() {
        return new SemanticHighlighting[]{new RubySemanticHighlighting(HL_REGEXP, PreferencesMessages.DLTKEditorPreferencePage_regexps), new RubySemanticHighlighting(HL_STRING, null), new RubySemanticHighlighting(HL_SYMBOL, null), new RubySemanticHighlighting(HL_LOCAL_VARIABLE, RubyPreferencesMessages.RubyLocalVariable), new RubySemanticHighlighting(HL_INSTANCE_VARIABLE, null), new RubySemanticHighlighting(HL_CLASS_VARIABLE, null), new RubySemanticHighlighting(HL_GLOBAL_VARIABLE, null), new RubySemanticHighlighting(HL_CONST, RubyPreferencesMessages.RubyConstants), new RubySemanticHighlighting(HL_NUMBER, null), new RubySemanticHighlighting(HL_EVAL_EXPR, PreferencesMessages.DLTKEditorPreferencePage_evaluated_expressions), new RubySemanticHighlighting(HL_DEFAULT, null)};
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        if (node instanceof RubyRegexpExpression || node instanceof RubyDRegexpExpression) {
            this.handleRegexp(node);
        } else if (node instanceof RubySymbolReference) {
            this.requestor.addPosition(node.sourceStart(), node.sourceEnd(), HL_SYMBOL);
        } else if (node instanceof VariableReference) {
            this.handleVariableReference((VariableReference)node);
        } else if (node instanceof RubyDVarExpression) {
            this.requestor.addPosition(node.sourceStart(), node.sourceEnd(), HL_LOCAL_VARIABLE);
        } else if (node instanceof RubyDAssgnExpression) {
            ASTNode var = ((RubyDAssgnExpression)node).getLeft();
            this.requestor.addPosition(var.sourceStart(), var.sourceEnd(), HL_LOCAL_VARIABLE);
        } else if (node instanceof StringLiteral) {
            if (this.isStringLiteralNeeded(node)) {
                this.requestor.addPosition(node.sourceStart(), node.sourceEnd(), HL_STRING);
            }
        } else if (node instanceof NumericLiteral || node instanceof FloatNumericLiteral || node instanceof BigNumericLiteral) {
            this.requestor.addPosition(node.sourceStart(), node.sourceEnd(), HL_NUMBER);
        } else if (node instanceof RubyEvaluatableStringExpression) {
            this.handleEvaluatableExpression(node);
        } else if (node instanceof CallExpression) {
            SimpleReference callName;
            CallExpression call = (CallExpression)node;
            if (!(RubySyntaxUtils.isRubyOperator((String)call.getName()) || call.getReceiver() == null && RubyCodeScanner.isPseudoKeyword(call.getName()) || (callName = call.getCallName()).sourceStart() < 0 || callName.sourceEnd() <= callName.sourceStart())) {
                this.requestor.addPosition(callName.sourceStart(), callName.sourceEnd(), HL_DEFAULT);
            }
        } else if (node instanceof Declaration) {
            Declaration declaration = (Declaration)node;
            this.requestor.addPosition(declaration.getNameStart(), declaration.getNameEnd(), HL_DEFAULT);
        } else if (node instanceof RubyConstantDeclaration) {
            RubyConstantDeclaration declaration = (RubyConstantDeclaration)node;
            SimpleReference name = declaration.getName();
            this.requestor.addPosition(name.sourceStart(), name.sourceEnd(), HL_CONST);
        }
        this.stack.push(node);
        return true;
    }

    private boolean isStringLiteralNeeded(ASTNode node) {
        if (this.stack.empty()) {
            return true;
        }
        ASTNode top = this.stack.peek();
        if (top instanceof RubyDRegexpExpression) {
            return false;
        }
        if (top instanceof RubyDynamicStringExpression) {
            return node.sourceStart() >= top.sourceStart() && node.sourceEnd() <= top.sourceEnd();
        }
        return true;
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        this.stack.pop();
    }

    private void handleVariableReference(VariableReference ref) {
        String varName = ref.getName();
        if (varName.length() != 0) {
            if (varName.charAt(0) == '$') {
                this.requestor.addPosition(ref.sourceStart(), ref.sourceEnd(), HL_GLOBAL_VARIABLE);
            } else if (varName.charAt(0) == '@') {
                if (varName.length() > 2 && varName.charAt(1) == '@') {
                    this.requestor.addPosition(ref.sourceStart(), ref.sourceEnd(), HL_CLASS_VARIABLE);
                } else {
                    this.requestor.addPosition(ref.sourceStart(), ref.sourceEnd(), HL_INSTANCE_VARIABLE);
                }
            } else {
                this.requestor.addPosition(ref.sourceStart(), ref.sourceEnd(), HL_LOCAL_VARIABLE);
            }
        }
    }

    private void handleEvaluatableExpression(ASTNode node) {
        int start = node.sourceStart();
        int end = node.sourceEnd();
        if (this.content[start] == '#' && this.content[start + 1] == '{') {
            if (this.content[end - 1] == '\r') {
                --end;
            }
            if (this.content[end - 1] == '}') {
                this.requestor.addPosition(start, start + 2, HL_EVAL_EXPR);
                this.requestor.addPosition(end - 1, end - 0, HL_EVAL_EXPR);
            }
        }
    }

    private void handleRegexp(ASTNode node) {
        char terminator;
        int start = node.sourceStart();
        int end = node.sourceEnd();
        if (start >= 1 && this.content[start - 1] == '/') {
            --start;
            if (end < this.content.length && this.content[end] == '/') {
                ++end;
            }
            while (end < this.content.length && RubySyntaxUtils.isValidRegexpModifier((char)this.content[end])) {
                ++end;
            }
        } else if (start >= 3 && this.content[start - 3] == '%' && this.content[start - 2] == 'r' && (terminator = RubySyntaxUtils.getPercentStringTerminator((char)this.content[start - 1])) != '\u0000' && end < this.content.length && this.content[end] == terminator) {
            start -= 3;
            ++end;
            while (end < this.content.length && RubySyntaxUtils.isValidRegexpModifier((char)this.content[end])) {
                ++end;
            }
        }
        this.requestor.addPosition(start, end, HL_REGEXP);
    }

    public String[] getHighlightingKeys() {
        HashSet<String> result = new HashSet<String>();
        SemanticHighlighting[] semanticHighlightingArray = this.getSemanticHighlightings();
        int n = semanticHighlightingArray.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticHighlighting highlighting = semanticHighlightingArray[n2];
            result.add(highlighting.getPreferenceKey());
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public void process(IModuleSource code, ISemanticHighlightingRequestor requestor) {
        this.requestor = requestor;
        this.content = code.getContentsAsCharArray();
        try {
            ((ModuleDeclaration)this.parseCode(code)).traverse((ASTVisitor)this);
        }
        catch (ModelException e) {
            throw new AbortSemanticHighlightingException();
        }
        catch (Exception e) {
            throw new AbortSemanticHighlightingException();
        }
    }

    protected IModuleDeclaration parseCode(IModuleSource code) throws ModelException {
        if (code instanceof ISourceModule) {
            return this.parseSourceModule((ISourceModule)code);
        }
        return this.parseSourceCode(code);
    }

    private IModuleDeclaration parseSourceCode(IModuleSource code) {
        return SourceParserUtil.parse((IModuleSource)code, (String)"org.eclipse.dltk.ruby.core.nature", null);
    }

    private IModuleDeclaration parseSourceModule(ISourceModule sourceModule) {
        return SourceParserUtil.parse((ISourceModule)sourceModule, null);
    }
}

