/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeFileHandle;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeQueryHandler;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStore;
import org.eclipse.emf.cdo.server.internal.lissome.db.IndexReader;
import org.eclipse.emf.cdo.server.internal.lissome.file.Journal;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.CommitTransactionTask;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.CreateBranchTask;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.Optimizer;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.OptimizerTask;
import org.eclipse.emf.cdo.server.lissome.ILissomeStoreAccessor;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.DelegatingQueryResourcesContext;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessorBase;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LissomeStoreReader
extends StoreAccessorBase
implements ILissomeStoreAccessor {
    protected Journal journal;
    private LissomeFileHandle journalReader;
    private LissomeFileHandle vobReader;
    private IndexReader indexReader;

    public LissomeStoreReader(LissomeStore store, ISession session) {
        super((Store)store, session);
        this.init(store);
    }

    protected LissomeStoreReader(LissomeStore store, ITransaction transaction) {
        super((Store)store, transaction);
        this.init(store);
    }

    protected void init(LissomeStore store) {
        this.journal = this.getStore().getJournal();
        this.indexReader = store.getIndex().createReader();
    }

    protected LissomeFileHandle getJournalReader() {
        if (this.journalReader == null) {
            this.journalReader = this.getStore().getJournal().openReader();
        }
        return this.journalReader;
    }

    protected LissomeFileHandle getVobReader() {
        if (this.vobReader == null) {
            this.vobReader = this.getStore().getVob().openReader();
        }
        return this.vobReader;
    }

    @Override
    public LissomeStore getStore() {
        return (LissomeStore)super.getStore();
    }

    public IStoreChunkReader createChunkReader(InternalCDORevision revision, EStructuralFeature feature) {
        return null;
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        Journal journal = this.getStore().getJournal();
        return journal.readPackageUnits();
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        Journal journal = this.getStore().getJournal();
        return journal.loadPackageUnit(packageUnit);
    }

    public InternalCDORevision readRevision(CDOID id, CDOBranchPoint branchPoint, int listChunk, CDORevisionCacheAdder cache) {
        Optimizer optimizer = this.getStore().getOptimizer();
        InternalCDORevision revision = optimizer.readRevision(id, branchPoint);
        if (revision != null) {
            if (this.getStore().getRepository().isSupportingAudits()) {
                return revision;
            }
            if (revision instanceof DetachedCDORevision || revision.getRevised() != 0L) {
                return null;
            }
            return revision;
        }
        IndexReader.RevisionInfo info = this.indexReader.readRevision(id, branchPoint);
        return this.readRevision(info);
    }

    public InternalCDORevision readRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int listChunk, CDORevisionCacheAdder cache) {
        IndexReader.RevisionInfo info = this.indexReader.readRevisionByVersion(id, branchVersion);
        return this.readRevision(info);
    }

    protected InternalCDORevision readRevision(IndexReader.RevisionInfo info) {
        LissomeFileHandle reader;
        if (info == null) {
            return null;
        }
        long pointer = info.getPointer();
        if (pointer == 0L) {
            return null;
        }
        if (pointer < 0L) {
            reader = this.getJournalReader();
            pointer = -pointer;
        } else {
            reader = this.getVobReader();
        }
        try {
            long revised;
            reader.seek(pointer);
            InternalCDORevision revision = (InternalCDORevision)reader.readCDORevision();
            if (revision != null && (revised = info.getRevised()) != 0L) {
                revision.setRevised(revised);
            }
            return revision;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, long timeStamp, boolean exactTime, final CDORevisionHandler handler) {
        this.indexReader.handleRevisions(eClass, branch, timeStamp, exactTime, new IndexReader.RevisionInfo.Handler(){

            public void handleRevisionInfo(CDOID id, IndexReader.RevisionInfo info) {
                InternalCDORevision revision = LissomeStoreReader.this.readRevision(info);
                if (revision != null) {
                    handler.handleRevision((CDORevision)revision);
                }
            }
        });
        Optimizer optimizer = this.getStore().getOptimizer();
        optimizer.handleRevisions(eClass, branch, timeStamp, exactTime, handler);
    }

    public Set<CDOID> readChangeSet(OMMonitor monitor, CDOChangeSetSegment ... segments) {
        throw new UnsupportedOperationException();
    }

    public void queryResources(final IStoreAccessor.QueryResourcesContext delegate) {
        DelegatingQueryResourcesContext context = new DelegatingQueryResourcesContext(){
            private Set<CDOID> queried = new HashSet<CDOID>();

            protected IStoreAccessor.QueryResourcesContext getDelegate() {
                return delegate;
            }

            public boolean addResource(CDOID resourceID) {
                if (this.queried.add(resourceID)) {
                    return super.addResource(resourceID);
                }
                return true;
            }
        };
        Optimizer optimizer = this.getStore().getOptimizer();
        boolean moreResults = optimizer.queryResources((IStoreAccessor.QueryResourcesContext)context);
        if (moreResults) {
            this.indexReader.queryResources((IStoreAccessor.QueryResourcesContext)context);
        }
    }

    public void queryXRefs(IStoreAccessor.QueryXRefsContext context) {
        throw new UnsupportedOperationException();
    }

    public void queryLobs(List<byte[]> ids) {
    }

    public void loadLob(byte[] id, OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
    }

    public IQueryHandler getQueryHandler(CDOQueryInfo info) {
        String queryLanguage = info.getQueryLanguage();
        if (StringUtil.equalsUpperOrLowerCase((String)queryLanguage, (String)"lissome")) {
            return new LissomeQueryHandler(this);
        }
        return null;
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        return this.indexReader.loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        return this.indexReader.loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        return this.indexReader.loadBranches(startID, endID, branchHandler);
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, final CDOCommitInfoHandler handler) {
        if (endTime < 0L) {
            throw new IllegalArgumentException("Counting not supported");
        }
        InternalCDOCommitInfoManager commitInfoManager = this.getStore().getRepository().getCommitInfoManager();
        Optimizer optimizer = this.getStore().getOptimizer();
        OptimizerTask[] tasks = optimizer.getTasks();
        final Journal journal = this.getStore().getJournal();
        final LissomeFileHandle journalReader = this.getJournalReader();
        final long[] latestIndexTime = new long[1];
        this.indexReader.loadCommitInfos(branch, startTime, endTime, new IndexReader.PointerHandler(){

            public void handlePointer(long pointer) {
                CDOCommitInfo commitInfo = journal.readCommitInfo(journalReader, pointer);
                handler.handleCommitInfo(commitInfo);
                latestIndexTime[0] = commitInfo.getTimeStamp();
            }
        });
        OptimizerTask[] optimizerTaskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            CommitTransactionTask commitTask;
            CDOBranchPoint commitBranchPoint;
            long commitTime;
            OptimizerTask task = optimizerTaskArray[n2];
            if (!(!(task instanceof CommitTransactionTask) || (commitTime = (commitBranchPoint = (commitTask = (CommitTransactionTask)task).getBranchPoint()).getTimeStamp()) <= latestIndexTime[0] || branch != null && commitBranchPoint.getBranch() != branch || startTime != 0L && commitTime < startTime)) {
                if (endTime != 0L && commitTime > endTime) break;
                CDOCommitInfo commitInfo = commitTask.createCommitInfo(commitInfoManager);
                handler.handleCommitInfo(commitInfo);
            }
            ++n2;
        }
    }

    public IDurableLockingManager.LockArea getLockArea(String durableLockingID) throws IDurableLockingManager.LockAreaNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void getLockAreas(String userIDPrefix, IDurableLockingManager.LockArea.Handler handler) {
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (branchID == Integer.MAX_VALUE) {
            branchID = this.getStore().getNextBranchID();
        } else if (branchID == Integer.MIN_VALUE) {
            branchID = this.getStore().getNextLocalBranchID();
        }
        long pointer = this.journal.createBranch(branchID, branchInfo);
        InternalCDOBranchManager branchManager = this.getStore().getRepository().getBranchManager();
        InternalCDOBranch baseBranch = branchManager.getBranch(branchInfo.getBaseBranchID());
        CDOBranchPoint base = baseBranch.getPoint(branchInfo.getBaseTimeStamp());
        CreateBranchTask task = new CreateBranchTask(branchID, branchInfo.getName(), base, pointer);
        Optimizer optimizer = this.getStore().getOptimizer();
        optimizer.addTask(task);
        return Pair.create((Object)branchID, (Object)branchInfo.getBaseTimeStamp());
    }

    public IDurableLockingManager.LockArea createLockArea(String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) throws IDurableLockingManager.LockAreaAlreadyExistsException {
        throw new UnsupportedOperationException();
    }

    public IDurableLockingManager.LockArea createLockArea(String durableLockingID, String userID, CDOBranchPoint branchPoint, boolean readOnly, Map<CDOID, IDurableLockingManager.LockGrade> locks) {
        throw new UnsupportedOperationException();
    }

    public void updateLockArea(IDurableLockingManager.LockArea lockArea) {
        throw new UnsupportedOperationException();
    }

    public void deleteLockArea(String durableLockingID) {
        throw new UnsupportedOperationException();
    }

    public void lock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToLock) {
        throw new UnsupportedOperationException();
    }

    public void unlock(String durableLockingID, IRWLockManager.LockType type, Collection<? extends Object> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    public void unlock(String durableLockingID) {
        throw new UnsupportedOperationException();
    }

    public void writePackageUnits(InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    protected void doWrite(InternalCommitContext context, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    protected void doCommit(OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    protected void doRollback(IStoreAccessor.CommitContext commitContext) {
        throw new UnsupportedOperationException();
    }

    protected CDOID getNextCDOID(CDORevision revision) {
        throw new UnsupportedOperationException();
    }
}

