/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

public final class ComparisonUtil {
    private static final Predicate<Diff> CASCADING_DIFF = Predicates.not((Predicate)Predicates.or((Predicate[])new Predicate[]{EMFComparePredicates.ofKind(DifferenceKind.MOVE), Predicates.instanceOf(ResourceAttachmentChange.class), EMFComparePredicates.hasConflict(ConflictKind.REAL)}));

    private ComparisonUtil() {
    }

    public static Function<Diff, Iterable<Diff>> getSubDiffs(boolean leftToRight) {
        return ComparisonUtil.getSubDiffs(leftToRight, false, new LinkedHashSet<Diff>());
    }

    public static Function<Diff, Iterable<Diff>> getDirectSubDiffs(boolean leftToRight) {
        return ComparisonUtil.getSubDiffs(leftToRight, true, new LinkedHashSet<Diff>());
    }

    public static boolean isAddOrSetDiff(Diff difference) {
        Object feature;
        boolean result = false;
        if (difference.getKind() == DifferenceKind.ADD) {
            result = true;
        } else if (difference.getKind() == DifferenceKind.CHANGE && (feature = difference instanceof ReferenceChange ? ((ReferenceChange)difference).getReference() : (difference instanceof AttributeChange ? ((AttributeChange)difference).getAttribute() : (difference instanceof FeatureMapChange ? ((FeatureMapChange)difference).getAttribute() : null))) != null && !feature.isMany()) {
            Match match = difference.getMatch();
            EObject source = match.getComparison().isThreeWay() ? match.getOrigin() : match.getRight();
            result = source == null ? true : ComparisonUtil.isEqualToDefault(source, (EStructuralFeature)feature);
        }
        return result;
    }

    private static boolean isEqualToDefault(EObject object, EStructuralFeature feature) {
        Object value = ReferenceUtil.safeEGet(object, feature);
        Object defaultValue = feature.getDefaultValue();
        if (value == null) {
            return defaultValue == null;
        }
        return value.equals(feature.getDefaultValue()) || "".equals(value);
    }

    public static boolean isDeleteOrUnsetDiff(Diff difference) {
        Object feature;
        boolean result = false;
        if (difference.getKind() == DifferenceKind.DELETE) {
            result = true;
        } else if (difference.getKind() == DifferenceKind.CHANGE && (feature = difference instanceof ReferenceChange ? ((ReferenceChange)difference).getReference() : (difference instanceof AttributeChange ? ((AttributeChange)difference).getAttribute() : (difference instanceof FeatureMapChange ? ((FeatureMapChange)difference).getAttribute() : null))) != null && !feature.isMany()) {
            Match match = difference.getMatch();
            EObject expectedContainer = difference.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
            result = expectedContainer == null ? true : ComparisonUtil.isEqualToDefault(expectedContainer, (EStructuralFeature)feature);
        }
        return result;
    }

    public static boolean isFeatureMapContainment(Diff diff) {
        FeatureMap.Entry entry;
        Object entryValue;
        if (diff instanceof FeatureMapChange && (entryValue = (entry = (FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue()) instanceof EObject) {
            Match match;
            EObject container = ((EObject)entryValue).eContainer();
            return container == (match = diff.getMatch()).getLeft() || container == match.getRight() || container == match.getOrigin();
        }
        return false;
    }

    public static EObject moveElementGetExpectedContainer(Comparison comparison, FeatureMapChange diff, boolean rightToLeft) {
        EObject expectedContainer = !ComparisonUtil.isFeatureMapContainment(diff) ? (rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight()) : (diff.getSource() == DifferenceSource.LEFT ? (rightToLeft ? ComparisonUtil.getContainerInEquivalence(comparison, diff, rightToLeft) : diff.getMatch().getRight()) : (rightToLeft ? diff.getMatch().getLeft() : ComparisonUtil.getContainerInEquivalence(comparison, diff, rightToLeft)));
        return expectedContainer;
    }

    private static EObject getContainerInEquivalence(Comparison comparison, FeatureMapChange diff, boolean rightToLeft) {
        EObject expectedContainer = null;
        Equivalence equ = diff.getEquivalence();
        if (equ != null) {
            for (Diff equivalence : equ.getDifferences()) {
                if (!(equivalence instanceof ReferenceChange)) continue;
                Match valueMatch = comparison.getMatch(((ReferenceChange)equivalence).getValue());
                Match targetContainerMatch = rightToLeft && valueMatch.getRight() != null ? comparison.getMatch(valueMatch.getRight().eContainer()) : (!rightToLeft && valueMatch.getLeft() != null ? comparison.getMatch(valueMatch.getLeft().eContainer()) : comparison.getMatch(valueMatch.getOrigin().eContainer()));
                expectedContainer = rightToLeft ? targetContainerMatch.getLeft() : targetContainerMatch.getRight();
                break;
            }
        } else {
            expectedContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        }
        return expectedContainer;
    }

    private static Function<Diff, Iterable<Diff>> getSubDiffs(final boolean leftToRight, final boolean firstLevelOnly, final LinkedHashSet<Diff> processedDiffs) {
        return new Function<Diff, Iterable<Diff>>(){

            public Iterable<Diff> apply(Diff diff) {
                Match matchOfValue;
                ReferenceChange referenceChange;
                if (diff.getKind() != DifferenceKind.MOVE && diff instanceof ReferenceChange && (referenceChange = (ReferenceChange)diff).getReference().isContainment() && (matchOfValue = diff.getMatch().getComparison().getMatch(referenceChange.getValue())) != null) {
                    Iterable subDiffs = !firstLevelOnly ? Iterables.filter(matchOfValue.getAllDifferences(), (Predicate)CASCADING_DIFF) : Iterables.filter(matchOfValue.getDifferences(), (Predicate)CASCADING_DIFF);
                    Iterables.addAll((Collection)processedDiffs, (Iterable)subDiffs);
                    Iterable associatedDiffs = ComparisonUtil.getAssociatedDiffs(diff, subDiffs, processedDiffs, leftToRight, firstLevelOnly);
                    return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)subDiffs, (Iterable)associatedDiffs));
                }
                return ImmutableSet.of();
            }
        };
    }

    private static Iterable<Diff> getAssociatedDiffs(Diff diffRoot, Iterable<Diff> subDiffs, LinkedHashSet<Diff> processedDiffs, boolean leftToRight, boolean firstLevelOnly) {
        LinkedHashSet<Diff> associatedDiffs = new LinkedHashSet<Diff>();
        for (Diff diff : subDiffs) {
            DifferenceSource source = diff.getSource();
            Object reqs = leftToRight ? (source == DifferenceSource.LEFT ? diff.getRequires() : diff.getRequiredBy()) : (source == DifferenceSource.LEFT ? diff.getRequiredBy() : diff.getRequires());
            reqs = ((InternalEList)reqs).basicList();
            associatedDiffs.addAll((Collection<Diff>)reqs);
            associatedDiffs.remove(diffRoot);
            associatedDiffs.addAll(((InternalEList)diff.getRefines()).basicList());
            Function<Diff, Iterable<Diff>> subDiffsFunction = ComparisonUtil.getSubDiffs(leftToRight, firstLevelOnly, processedDiffs);
            Iterator iterator = reqs.iterator();
            while (iterator.hasNext()) {
                Diff req = (Diff)iterator.next();
                if (req == diffRoot || !processedDiffs.add(req)) continue;
                Iterables.addAll(associatedDiffs, (Iterable)((Iterable)subDiffsFunction.apply((Object)req)));
            }
        }
        return associatedDiffs;
    }

    public static Comparison getComparison(EObject object) {
        EList<Diff> differences;
        Diff first;
        EObject eContainer;
        Comparison comparison = object instanceof Match ? ((Match)object).getComparison() : (object instanceof Diff ? ComparisonUtil.getComparison((Diff)object) : (object instanceof MatchResource ? ((MatchResource)object).getComparison() : (object instanceof Equivalence ? ((eContainer = object.eContainer()) instanceof Comparison ? (Comparison)eContainer : ((first = (Diff)Iterables.getFirst(differences = ((Equivalence)object).getDifferences(), null)) != null ? first.getMatch().getComparison() : null)) : (object instanceof Conflict ? ((eContainer = object.eContainer()) instanceof Comparison ? (Comparison)eContainer : ((first = (Diff)Iterables.getFirst(differences = ((Conflict)object).getDifferences(), null)) != null ? first.getMatch().getComparison() : null)) : null))));
        return comparison;
    }

    public static Comparison getComparison(Diff diff) {
        Comparison comparison = diff.eContainer() instanceof MatchResource ? ((MatchResource)diff.eContainer()).getComparison() : diff.getMatch().getComparison();
        return comparison;
    }

    public static EObject getExpectedSide(Match match, DifferenceSource source, boolean mergeRightToLeft) {
        EObject result = null;
        if (match != null) {
            Comparison comparison = match.getComparison();
            result = comparison.isThreeWay() && mergeRightToLeft == (source == DifferenceSource.LEFT) && match.getOrigin() != null ? match.getOrigin() : (mergeRightToLeft ? match.getRight() : match.getLeft());
        }
        return result;
    }

    public static boolean isContainedInFeatureMap(EObject object) {
        EAnnotation annotation = object.eContainingFeature().getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        if (annotation != null) {
            String groupKind = ExtendedMetaData.FEATURE_KINDS[6];
            return annotation.getDetails().containsKey((Object)groupKind);
        }
        return false;
    }

    public static boolean bothArePlatformResourcesAndOnlyOneExists(Resource leftResource, Resource rightResource) {
        boolean existingPlatformResources = false;
        if (leftResource != null && rightResource != null) {
            ResourceSet leftResourceSet = leftResource.getResourceSet();
            ResourceSet rightResourceSet = rightResource.getResourceSet();
            if (leftResourceSet != null && rightResourceSet != null) {
                URI leftURI = leftResource.getURI();
                URI rightURI = rightResource.getURI();
                if (leftURI.isPlatformResource() && rightURI.isPlatformResource()) {
                    boolean baseExists = leftResourceSet.getURIConverter().exists(leftURI, Collections.emptyMap());
                    boolean changedExists = rightResourceSet.getURIConverter().exists(rightURI, Collections.emptyMap());
                    existingPlatformResources = baseExists && !changedExists || !baseExists && changedExists;
                }
            }
        }
        return existingPlatformResources;
    }

    public static boolean bothResourceHaveResourceSet(Resource leftResource, Resource rightResource) {
        if (leftResource != null && rightResource != null) {
            ResourceSet leftResourceSet = leftResource.getResourceSet();
            ResourceSet rightResourceSet = rightResource.getResourceSet();
            if (leftResourceSet != null && rightResourceSet != null) {
                return true;
            }
        }
        return false;
    }

    public static void delete(Diff diff) {
        Comparison comparison = diff.getMatch().getComparison();
        Conflict conflict = diff.getConflict();
        Equivalence equivalence = diff.getEquivalence();
        EcoreUtil.delete((EObject)diff);
        if (conflict != null && (conflict.getLeftDifferences().isEmpty() || conflict.getRightDifferences().isEmpty())) {
            conflict.getDifferences().clear();
            comparison.getConflicts().remove((Object)conflict);
        }
        if (equivalence != null && equivalence.getDifferences().size() < 2) {
            equivalence.getDifferences().clear();
            comparison.getEquivalences().remove((Object)equivalence);
        }
    }
}

