/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.processors.ConfigurationInfo;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.ide.processors.AbstractCachingStringProcessor;

public abstract class PlatformDetailsSectionProcessor
extends AbstractCachingStringProcessor
implements IReportProcessor {
    public String sectionTitle;

    public PlatformDetailsSectionProcessor(IProcessorDescriptor descriptor, String sectionTitle) {
        super(descriptor);
        this.sectionTitle = sectionTitle;
    }

    @Override
    public boolean canContribute(IStatus status) {
        return true;
    }

    public final boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return false;
    }

    @Override
    @VisibleForTesting
    protected String process(IStatus status) {
        String configuration = this.getPlatformDetailsConfiguration();
        int sectionStart = configuration.indexOf(this.sectionTitle);
        if (sectionStart == -1) {
            return "";
        }
        int sectionEnd = configuration.indexOf("*** ", (sectionStart += this.sectionTitle.length()) + 1) - 1;
        if (sectionEnd < 0 && (sectionEnd = configuration.indexOf(String.valueOf(System.lineSeparator()) + System.lineSeparator(), sectionStart + 1) - 1) < 0) {
            sectionEnd = configuration.length();
        }
        return configuration.substring(sectionStart, sectionEnd).trim();
    }

    private String getPlatformDetailsConfiguration() {
        return StringUtils.defaultString((String)ConfigurationInfo.getConfiguration("Platform Details"));
    }
}

