/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import javafx.beans.property.ReadOnlyMapProperty;
import javafx.scene.Group;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.zest.fx.ZestProperties;
import org.eclipse.gef.zest.fx.parts.EdgeLabelPart;

public class DotEdgeLabelPart
extends EdgeLabelPart {
    protected void doRefreshVisual(Group visual) {
        Edge edge = (Edge)this.getContent().getKey();
        ReadOnlyMapProperty attrs = edge.attributesProperty();
        if ("element-label".equals(this.getContent().getValue())) {
            String label = ZestProperties.getLabel((Edge)edge);
            if (label != null) {
                this.getText().setText(label);
            }
            if (attrs.containsKey("element-label-css-style")) {
                String textCssStyle = ZestProperties.getLabelCssStyle((Edge)edge);
                this.getText().setStyle(textCssStyle);
            }
        } else if ("element-external-label".equals(this.getContent().getValue())) {
            String label = ZestProperties.getExternalLabel((Edge)edge);
            if (label != null) {
                this.getText().setText(label);
            }
            if (attrs.containsKey("element-external-label-css-style")) {
                String textCssStyle = ZestProperties.getExternalLabelCssStyle((Edge)edge);
                this.getText().setStyle(textCssStyle);
            }
        } else if ("edge-source-label".equals(this.getContent().getValue())) {
            String label = ZestProperties.getSourceLabel((Edge)edge);
            if (label != null) {
                this.getText().setText(label);
            }
            if (attrs.containsKey("edge-source-label-css-style")) {
                String textCssStyle = ZestProperties.getSourceLabelCssStyle((Edge)edge);
                this.getText().setStyle(textCssStyle);
            }
        } else if ("edge-target-label".equals(this.getContent().getValue())) {
            String label = ZestProperties.getTargetLabel((Edge)edge);
            if (label != null) {
                this.getText().setText(label);
            }
            if (attrs.containsKey("edge-target-label-css-style")) {
                String textCssStyle = ZestProperties.getTargetLabelCssStyle((Edge)edge);
                this.getText().setStyle(textCssStyle);
            }
        }
        if (this.getFirstAnchorage() == null) {
            return;
        }
        this.refreshPosition(this.getVisual(), this.getLabelPosition());
    }
}

