/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.style.ClusterStyle;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.style.Style;
import org.eclipse.gef.dot.internal.language.style.StyleItem;
import org.eclipse.gef.dot.internal.language.style.StylePackage;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotStyleJavaValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class DotStyleJavaValidator
extends AbstractDotStyleJavaValidator {
    @Check
    public void checkStyleItemConformsToContext(StyleItem styleItem) {
        String name = styleItem.getName();
        if (name.equals("setlinewidth")) {
            return;
        }
        DotAttributes.Context attributeContext = this.getAttributeContext();
        switch (attributeContext) {
            case GRAPH: 
            case CLUSTER: {
                this.validateStyleItem(styleItem, ClusterStyle.VALUES, attributeContext);
                break;
            }
            case NODE: {
                this.validateStyleItem(styleItem, NodeStyle.VALUES, attributeContext);
                break;
            }
            case EDGE: {
                this.validateStyleItem(styleItem, EdgeStyle.VALUES, attributeContext);
                break;
            }
        }
    }

    private void validateStyleItem(StyleItem styleItem, List<?> validValues, DotAttributes.Context attributeContext) {
        for (Object validValue : validValues) {
            if (!validValue.toString().equals(styleItem.getName())) continue;
            return;
        }
        this.reportRangeBaseError("Value should be one of " + this.getFormattedValues(validValues) + ".", styleItem, attributeContext);
    }

    @Check
    public void checkDeprecatedStyleItem(StyleItem styleItem) {
        if (styleItem.getName().equals("setlinewidth")) {
            this.reportRangeBasedWarning("The usage of setlinewidth is deprecated, use the penwidth attribute instead.", styleItem);
        }
    }

    @Check
    public void checkDuplicatedStyleItem(Style style) {
        HashSet<String> definedStyles = new HashSet<String>();
        EList<StyleItem> styleItems = style.getStyleItems();
        int i = styleItems.size() - 1;
        while (i >= 0) {
            StyleItem styleItem = (StyleItem)styleItems.get(i);
            String name = styleItem.getName();
            if (!definedStyles.add(name)) {
                this.reportRangeBasedWarning("The style value '" + name + "' is duplicated.", styleItem);
            }
            --i;
        }
    }

    private void reportRangeBasedWarning(String message, StyleItem styleItem) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)styleItem, (EStructuralFeature)StylePackage.Literals.STYLE_ITEM__NAME);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        String code = null;
        String[] issueData = new String[]{styleItem.getName()};
        this.getMessageAcceptor().acceptWarning(message, (EObject)styleItem, offset, length, code, issueData);
    }

    private void reportRangeBaseError(String message, StyleItem styleItem, DotAttributes.Context attributeContext) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)styleItem, (EStructuralFeature)StylePackage.Literals.STYLE_ITEM__NAME);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        String code = null;
        String[] issueData = new String[]{styleItem.getName(), attributeContext.toString()};
        this.getMessageAcceptor().acceptError(message, (EObject)styleItem, offset, length, code, issueData);
    }

    private DotAttributes.Context getAttributeContext() {
        DotAttributes.Context attributeContext = (DotAttributes.Context)((Object)this.getContext().get(DotAttributes.Context.class.getName()));
        return attributeContext;
    }

    private String getFormattedValues(List<?> values) {
        StringBuilder sb = new StringBuilder();
        for (Object value : new TreeSet(values)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'" + value + "'");
        }
        return sb.toString();
    }
}

