/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.ClientTest;
import org.eclipse.jubula.client.core.IClientTest;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IALMReportingRulePO;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.IConditionalStatementPO;
import org.eclipse.jubula.client.core.model.IDoWhilePO;
import org.eclipse.jubula.client.core.model.IIteratePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParameterDetailsPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultAdditionPO;
import org.eclipse.jubula.client.core.model.ITestResultPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.IWhileDoPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.model.TestResultParameter;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestresultSummaryBP {
    public static final String AUTRUN = "autrun";
    public static final int TYPE_ITERATE = 9;
    public static final int TYPE_WHILEDO = 8;
    public static final int TYPE_DOWHILE = 7;
    public static final int TYPE_CONTAINER = 6;
    public static final int TYPE_CONDITION = 5;
    public static final int TYPE_COMMENT = 4;
    public static final int TYPE_TEST_STEP = 3;
    public static final int TYPE_TEST_CASE = 2;
    public static final int TYPE_TEST_SUITE = 1;
    private static Logger log = LoggerFactory.getLogger(TestresultSummaryBP.class);
    private static TestresultSummaryBP instance = null;
    private Long m_parentKeyWordId;

    public void fillTestResultSummary(TestResult result, ITestResultSummaryPO summary) {
        IAUTMainPO aut;
        TestExecution te = TestExecution.getInstance();
        ITestSuitePO ts = te.getStartedTestSuite();
        IAUTMainPO startedAut = te.getConnectedAut();
        if (result.getAutConfigMap() != null && startedAut != null) {
            String autConfigName = result.getAutConfigName();
            for (IAUTConfigPO conf : startedAut.getAutConfigSet()) {
                if (!conf.getValue("CONFIG_NAME", "invalid").equals(autConfigName)) continue;
                summary.setInternalAutConfigGuid(conf.getGuid());
                break;
            }
        } else {
            summary.setInternalAutConfigGuid(AUTRUN);
        }
        summary.setAutConfigName(result.getAutConfigName());
        summary.setAutCmdParameter(result.getAutArguments());
        summary.setAutId(result.getAutId());
        summary.setAutOS(System.getProperty("os.name"));
        IAUTMainPO iAUTMainPO = aut = startedAut != null ? startedAut : ts.getAut();
        if (aut != null) {
            summary.setInternalAutGuid(aut.getGuid());
            summary.setAutName(aut.getName());
            summary.setAutToolkit(aut.getToolkit());
        }
        summary.setTestsuiteDate(new Date());
        summary.setInternalTestsuiteGuid(ts.getGuid());
        summary.setTestsuiteName(ts.getName());
        summary.setInternalProjectGuid(result.getProjectGuid());
        summary.setInternalProjectID(result.getProjectId());
        summary.setProjectName(result.getProjectName());
        summary.setProjectMajorVersion(result.getProjectMajorVersion());
        summary.setProjectMinorVersion(result.getProjectMinorVersion());
        summary.setProjectMicroVersion(result.getProjectMicroVersion());
        summary.setProjectVersionQualifier(result.getProjectVersionQualifier());
        IClientTest clientTest = ClientTest.instance();
        Date startTime = clientTest.getTestsuiteStartTime();
        summary.setTestsuiteStartTime(startTime);
        Date endTime = new Date();
        summary.setTestsuiteEndTime(endTime);
        summary.setTestsuiteDuration(TimeUtil.getDurationString((Date)startTime, (Date)endTime));
        summary.setTestsuiteExecutedTeststeps(te.getNumberOfTestedSteps());
        summary.setTestsuiteExpectedTeststeps(te.getExpectedNumberOfSteps());
        summary.setTestsuiteEventHandlerTeststeps(te.getNumberOfEventHandlerSteps() + te.getNumberOfRetriedSteps());
        summary.setTestsuiteFailedTeststeps(te.getNumberOfFailedSteps());
        summary.setTestsuiteRelevant(te.getStartedTestSuite().getRelevant());
        ITestJobPO tj = te.getStartedTestJob();
        if (tj != null) {
            summary.setTestJobName(tj.getName());
            summary.setInternalTestJobGuid(tj.getGuid());
            summary.setTestJobStartTime(clientTest.getTestjobStartTime());
        }
        summary.setTestsuiteStatus(result.getRootResultNode().getStatus());
        summary.setInternalMonitoringId("none selected");
        summary.setReportWritten(false);
        this.determineAlmRepositoryStatus(summary, result);
        summary.setMonitoringValueType("none");
    }

    private void determineAlmRepositoryStatus(ITestResultSummaryPO summary, TestResult result) {
        IProjectPO project = result.getProject();
        IProjectPropertiesPO projectProperties = project.getProjectProperties();
        boolean reportSuccess = projectProperties.getIsReportOnSuccess();
        boolean reportFailure = projectProperties.getIsReportOnFailure();
        List<IALMReportingRulePO> reportingRules = projectProperties.getALMReportingRules();
        ArrayList<IALMReportingRulePO> reportingRulesCopy = new ArrayList<IALMReportingRulePO>();
        for (IALMReportingRulePO rule : reportingRules) {
            reportingRulesCopy.add(rule.copy());
        }
        String almRepositoryName = projectProperties.getALMRepositoryName();
        ITestResultSummaryPO.AlmReportStatus status = ITestResultSummaryPO.AlmReportStatus.NOT_CONFIGURED;
        if (StringUtils.isNotEmpty((String)almRepositoryName) && (reportSuccess || reportFailure || !reportingRules.isEmpty()) && summary.isTestsuiteRelevant()) {
            status = ITestResultSummaryPO.AlmReportStatus.NOT_YET_REPORTED;
            summary.setALMRepositoryName(almRepositoryName);
            summary.setIsReportOnSuccess(reportSuccess);
            summary.setIsReportOnFailure(reportFailure);
            summary.setALMReportingRules(reportingRulesCopy);
            summary.setDashboardURL(projectProperties.getDashboardURL());
        }
        summary.setAlmReportStatus(status);
    }

    public EntityManager createTestResultDetailsSession(TestResult result, Long summaryId) {
        EntityManager sess = Persistor.instance().openSession();
        Persistor.instance().getTransaction(sess);
        this.buildTestResultDetailsSession(result.getRootResultNode(), sess, summaryId, 1, 1);
        return sess;
    }

    private int buildTestResultDetailsSession(TestResultNode result, EntityManager sess, Long summaryId, int nodeLevel, int startingNodeSequence) {
        int nodeSequence = startingNodeSequence;
        TestResultNode resultNode = result;
        ITestResultPO keyword = PoMaker.createTestResultPO();
        keyword.setInternalTestResultSummaryID(summaryId);
        this.fillNode(keyword, resultNode);
        keyword.setKeywordLevel(nodeLevel);
        keyword.setKeywordSequence(nodeSequence);
        keyword.setInternalParentKeywordID(this.m_parentKeyWordId);
        sess.persist((Object)keyword);
        for (TestResultNode node : resultNode.getResultNodeList()) {
            this.m_parentKeyWordId = keyword.getId();
            nodeSequence = this.buildTestResultDetailsSession(node, sess, summaryId, nodeLevel + 1, nodeSequence + 1);
        }
        return nodeSequence;
    }

    private void fillNode(ITestResultPO keyword, TestResultNode resultNode) {
        INodePO node = resultNode.getNode();
        keyword.setKeywordName(node.getName());
        keyword.setInternalKeywordGuid(node.getGuid());
        keyword.setKeywordComment(node.getComment());
        keyword.setTaskId(resultNode.getTaskId());
        keyword.setInternalKeywordStatus(resultNode.getStatus());
        keyword.setKeywordStatus(resultNode.getStatusString());
        if (resultNode.getTimeStamp() != null) {
            keyword.setTimestamp(resultNode.getTimeStamp());
        }
        if (resultNode.getParent() != null) {
            keyword.setInternalParentKeywordID(resultNode.getParent().getNode().getId());
        }
        this.addParameterListToResult(keyword, resultNode);
        keyword.setKeywordType(resultNode.getTypeOfNode());
        if (node instanceof ICapPO) {
            keyword.setInternalKeywordType(3);
            ICapPO cap = (ICapPO)node;
            String compNameGuid = cap.getComponentName();
            keyword.setInternalComponentNameGuid(compNameGuid);
            keyword.setComponentName(StringUtils.defaultString((String)resultNode.getComponentName()));
            keyword.setInternalComponentType(cap.getComponentType());
            keyword.setComponentType(CompSystemI18n.getString((String)cap.getComponentType()));
            keyword.setInternalActionName(cap.getActionName());
            keyword.setActionName(CompSystemI18n.getString((String)cap.getActionName()));
            String commandlog = resultNode.getCommandLog();
            if (StringUtils.isNotBlank((String)commandlog)) {
                ITestResultAdditionPO testResultAddition = NodeMaker.createTestResultAddtionPO(commandlog);
                testResultAddition.setInternalTestResultSummaryID(keyword.getInternalTestResultSummaryID());
                keyword.addAdditon(testResultAddition);
            }
            if (resultNode.getScreenshot() != null) {
                keyword.setImage(resultNode.getScreenshot());
            }
            this.addErrorDetails(keyword, resultNode);
            keyword.setNoOfSimilarComponents(resultNode.getNoOfSimilarComponents());
            keyword.setOmHeuristicEquivalence(resultNode.getOmHeuristicEquivalence());
        } else if (node instanceof ITestCasePO) {
            keyword.setInternalKeywordType(2);
            keyword.setIsJUnitSuite(node.isJUnitTestSuite());
        } else if (node instanceof ITestSuitePO) {
            keyword.setInternalKeywordType(1);
        } else if (node instanceof ICommentPO) {
            keyword.setInternalKeywordType(4);
        } else if (node instanceof IConditionalStatementPO) {
            keyword.setInternalKeywordType(5);
        } else if (node instanceof IAbstractContainerPO) {
            keyword.setInternalKeywordType(6);
        } else if (node instanceof IDoWhilePO) {
            keyword.setInternalKeywordType(7);
        } else if (node instanceof IWhileDoPO) {
            keyword.setInternalKeywordType(8);
        } else if (node instanceof IIteratePO) {
            keyword.setInternalKeywordType(9);
        }
    }

    private void addParameterListToResult(ITestResultPO keyword, TestResultNode node) {
        for (TestResultParameter param : node.getParameters()) {
            IParameterDetailsPO parameter = PoMaker.createParameterDetailsPO();
            parameter.setParameterName(param.getName());
            parameter.setParameterType(param.getType());
            parameter.setInternalTestResultSummaryID(keyword.getInternalTestResultSummaryID());
            String value = param.getValue();
            if (value.length() >= 3500) {
                log.warn("Parameter value to long: " + value);
                value = StringUtils.substring((String)value, (int)0, (int)3500);
            }
            parameter.setParameterValue(value);
            keyword.addParameter(parameter);
        }
    }

    private void addErrorDetails(ITestResultPO keyword, TestResultNode node) {
        if (node.getStatus() == 2 || node.getStatus() == 7) {
            String value;
            TestErrorEvent event = node.getEvent();
            keyword.setStatusType(I18n.getString((String)event.getId(), (boolean)true));
            Map eventProps = event.getProps();
            String descriptionKey = (String)eventProps.get("guidancerErrorDescription");
            if (descriptionKey != null) {
                Object[] args = (Object[])eventProps.get("guidancerErrorParameter");
                keyword.setStatusDescription(String.valueOf(I18n.getString((String)descriptionKey, (Object[])args)));
            }
            if (eventProps.containsKey("guidancerOperator")) {
                value = String.valueOf(eventProps.get("guidancerOperator"));
                keyword.setStatusOperator(value);
            }
            if (eventProps.containsKey("guidancerPattern")) {
                value = String.valueOf(eventProps.get("guidancerPattern"));
                keyword.setExpectedValue(value);
            }
            if (eventProps.containsKey("guidancerActualValue")) {
                value = String.valueOf(eventProps.get("guidancerActualValue"));
                keyword.setActualValue(value);
            }
        }
    }

    public void setCommentTitleAndDetails(ITestResultSummaryPO selectedSummary, String newTitle, String newDetails) {
        Persistor persistor = Persistor.instance();
        EntityManager sess = persistor.openSession();
        try {
            try {
                EntityTransaction tx = persistor.getTransaction(sess);
                ITestResultSummaryPO summary = (ITestResultSummaryPO)sess.merge((Object)selectedSummary);
                summary.setCommentTitle(newTitle);
                summary.setCommentDetail(newDetails);
                persistor.commitTransaction(sess, tx);
                DataEventDispatcher.getInstance().fireTestresultSummaryChanged(summary, DataEventDispatcher.DataState.StructureModified);
            }
            catch (PMException e) {
                throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
            catch (ProjectDeletedException e) {
                throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
            }
        }
        finally {
            persistor.dropSession(sess);
        }
    }

    public static TestresultSummaryBP getInstance() {
        if (instance == null) {
            instance = new TestresultSummaryBP();
        }
        return instance;
    }

    public void setRelevance(ITestResultSummaryPO selectedSummary, boolean newRelevance) {
        if (selectedSummary != null) {
            Persistor persistor = Persistor.instance();
            EntityManager sess = persistor.openSession();
            try {
                try {
                    EntityTransaction tx = persistor.getTransaction(sess);
                    ITestResultSummaryPO msummary = (ITestResultSummaryPO)sess.merge((Object)selectedSummary);
                    msummary.setTestsuiteRelevant(newRelevance);
                    persistor.commitTransaction(sess, tx);
                    DataEventDispatcher.getInstance().fireTestresultSummaryChanged(msummary, DataEventDispatcher.DataState.StructureModified);
                }
                catch (PMException e) {
                    throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
                }
                catch (ProjectDeletedException e) {
                    throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
                }
            }
            finally {
                persistor.dropSession(sess);
            }
        }
    }

    public void setALMReportStatus(ITestResultSummaryPO selectedSummary, ITestResultSummaryPO.AlmReportStatus reportStatus) {
        if (selectedSummary != null) {
            Persistor persistor = Persistor.instance();
            EntityManager sess = persistor.openSession();
            try {
                try {
                    EntityTransaction tx = persistor.getTransaction(sess);
                    ITestResultSummaryPO msummary = (ITestResultSummaryPO)sess.merge((Object)selectedSummary);
                    msummary.setAlmReportStatus(reportStatus);
                    persistor.commitTransaction(sess, tx);
                    DataEventDispatcher.getInstance().fireTestresultSummaryChanged(msummary, DataEventDispatcher.DataState.StructureModified);
                }
                catch (PMException e) {
                    throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
                }
                catch (ProjectDeletedException e) {
                    throw new JBFatalException(Messages.StoringOfMetadataFailed, (Throwable)e, MessageIDs.E_PROJECT_NOT_FOUND);
                }
            }
            finally {
                persistor.dropSession(sess);
            }
        }
    }
}

