/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.internal.buildpath.LuaExecutionEnvironmentManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityListener;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityPatternBinding;

public final class LuaExecutionEnvironmentUIManager {
    public static final String EE_EXTENTION_POINT_ID = "org.eclipse.ldt.executionEnvironment";

    private LuaExecutionEnvironmentUIManager() {
    }

    public static List<LuaExecutionEnvironment> getAvailableExecutionEnvironments() {
        List executionEnvironments = LuaExecutionEnvironmentManager.getAvailableExecutionEnvironments();
        ArrayList<LuaExecutionEnvironment> newExecutionEnvironments = new ArrayList<LuaExecutionEnvironment>();
        newExecutionEnvironments.addAll(executionEnvironments);
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        Set activities = activityManager.getDefinedActivityIds();
        for (String activityId : activities) {
            IActivity activity = activityManager.getActivity(activityId);
            Set bindings = activity.getActivityPatternBindings();
            if (activity.isEnabled()) continue;
            for (IActivityPatternBinding binding : bindings) {
                if (!binding.getString().contains(EE_EXTENTION_POINT_ID)) continue;
                for (LuaExecutionEnvironment luaExecutionEnvironment : executionEnvironments) {
                    if (!luaExecutionEnvironment.isEmbedded() || !binding.getString().endsWith(luaExecutionEnvironment.getEEIdentifier())) continue;
                    newExecutionEnvironments.remove(luaExecutionEnvironment);
                }
            }
        }
        return newExecutionEnvironments;
    }

    public static Set<IActivity> addListenerToEERelatedActivity(IActivityListener activityListener) {
        HashSet<IActivity> activitiesWatched = new HashSet<IActivity>();
        IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        Set activities = activityManager.getDefinedActivityIds();
        for (String activityId : activities) {
            IActivity activity = activityManager.getActivity(activityId);
            Set bindings = activity.getActivityPatternBindings();
            for (IActivityPatternBinding binding : bindings) {
                if (!binding.getString().contains(EE_EXTENTION_POINT_ID)) continue;
                activitiesWatched.add(activity);
                activity.addActivityListener(activityListener);
            }
        }
        return activitiesWatched;
    }
}

