/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.eclipse.net4j.internal.util.bundle.AbstractBundle;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.om.OSGiBundle;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class OSGiActivator
implements BundleActivator {
    private OMBundle omBundle;
    protected BundleContext bundleContext;

    public OSGiActivator(OMBundle omBundle) {
        this.omBundle = omBundle;
    }

    public final OMBundle getOMBundle() {
        return this.omBundle;
    }

    public final void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        OSGiActivator.traceStart(context);
        if (this.omBundle == null) {
            throw new IllegalStateException("bundle == null");
        }
        try {
            this.setBundleContext(context);
            ((AbstractBundle)this.omBundle).start();
            this.doStart();
        }
        catch (Error error) {
            this.omBundle.logger().error(error);
            throw error;
        }
        catch (Exception ex) {
            this.omBundle.logger().error(ex);
            throw ex;
        }
    }

    public final void stop(BundleContext context) throws Exception {
        OSGiActivator.traceStop(context);
        if (this.omBundle == null) {
            throw new IllegalStateException("bundle == null");
        }
        try {
            this.doStop();
            ((AbstractBundle)this.omBundle).stop();
            this.setBundleContext(null);
        }
        catch (Error error) {
            this.omBundle.logger().error(error);
            throw error;
        }
        catch (Exception ex) {
            this.omBundle.logger().error(ex);
            throw ex;
        }
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final String toString() {
        return super.toString();
    }

    protected final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    private void setBundleContext(BundleContext context) {
        this.omBundle.setBundleContext(context);
    }

    public static void start(OMBundle bundle) throws Exception {
        ((AbstractBundle)bundle).start();
    }

    public static void stop(OMBundle bundle) throws Exception {
        ((AbstractBundle)bundle).stop();
    }

    public static void traceStart(BundleContext context) {
        try {
            if (OM.TRACER.isEnabled()) {
                OM.TRACER.format("Starting bundle {0}", context.getBundle().getSymbolicName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void traceStop(BundleContext context) {
        try {
            if (OM.TRACER.isEnabled()) {
                OM.TRACER.format("Stopping bundle {0}", context.getBundle().getSymbolicName());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static abstract class StateHandler {
        private OSGiBundle bundle;

        public StateHandler(OMBundle bundle) {
            this.bundle = (OSGiBundle)bundle;
        }

        public final void start() throws Exception {
            Object state;
            block6: {
                state = null;
                File stateFile = this.getStateFile();
                if (stateFile.exists()) {
                    FileInputStream fis = null;
                    try {
                        try {
                            fis = new FileInputStream(stateFile);
                            ObjectInputStream ois = new ObjectInputStream(fis){

                                @Override
                                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                                    String className = desc.getName();
                                    return StateHandler.this.bundle.getAccessor().getClassLoader().loadClass(className);
                                }
                            };
                            state = ois.readObject();
                            IOUtil.close(ois);
                        }
                        catch (Exception ex) {
                            OM.LOG.error(ex);
                            IOUtil.close(fis);
                            fis = null;
                            stateFile.delete();
                            IOUtil.close(fis);
                            break block6;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(fis);
                        throw throwable;
                    }
                    IOUtil.close(fis);
                }
            }
            this.startWithState(state);
        }

        public final void stop() throws Exception {
            FileOutputStream fos = null;
            try {
                Object state = this.stopWithState();
                File stateFile = this.getStateFile();
                fos = new FileOutputStream(stateFile);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(state);
                IOUtil.close(oos);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
            IOUtil.close(fos);
        }

        private File getStateFile() {
            return new File(this.bundle.getStateLocation(), "state.bin");
        }

        protected abstract void startWithState(Object var1) throws Exception;

        protected abstract Object stopWithState() throws Exception;
    }

    public static abstract class WithState
    extends OSGiActivator {
        private StateHandler handler = new StateHandler(this.getOMBundle()){

            protected void startWithState(Object state) throws Exception {
                WithState.this.doStartWithState(state);
            }

            protected Object stopWithState() throws Exception {
                return WithState.this.doStopWithState();
            }
        };

        public WithState(OMBundle bundle) {
            super(bundle);
        }

        protected final void doStart() throws Exception {
            this.handler.start();
        }

        protected final void doStop() throws Exception {
            this.handler.stop();
        }

        protected abstract void doStartWithState(Object var1) throws Exception;

        protected abstract Object doStopWithState() throws Exception;
    }
}

