/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.clipboard;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.clipboard.ICopierFactory;

class DefaultConfigurator
implements ICopierFactory.Configurator {
    private static final String REFERENCE_FILTER = "referenceFilter";
    private static final String REFERENCE_URI = "referenceURI";
    private static final String OWNER_TYPE_URI = "ownerTypeURI";
    private final Collection<ICopierFactory.Configurator> configurationRules = new ArrayList<ICopierFactory.Configurator>();

    @Override
    public void configureCopier(ICopierFactory.Configuration copierConfiguration) {
        this.configurationRules.forEach(rule -> rule.configureCopier(copierConfiguration));
    }

    boolean readElement(IConfigurationElement element) {
        String referenceURI;
        boolean result = false;
        if (REFERENCE_FILTER.equals(element.getName()) && !Strings.isNullOrEmpty((String)(referenceURI = element.getAttribute(REFERENCE_URI)))) {
            result = true;
            String ownerTypeURI = element.getAttribute(OWNER_TYPE_URI);
            try {
                this.configurationRules.add(this.referenceFilter(referenceURI, ownerTypeURI));
            }
            catch (Exception e) {
                Activator.log.warn(String.format("Invalid fopier reference filter extension in %s: %s", element.getContributor().getName(), e.getMessage()));
            }
        }
        return result;
    }

    private <T extends EModelElement> Optional<T> getEcoreElement(String uriString, Class<T> metaclass) {
        EObject result = null;
        URI uri = URI.createURI((String)uriString, (boolean)true);
        EPackage epackage = EPackage.Registry.INSTANCE.getEPackage(uri.trimFragment().toString());
        if (epackage != null) {
            result = epackage.eResource().getEObject(uri.fragment());
        }
        return Optional.ofNullable(result).map(metaclass::cast);
    }

    private ICopierFactory.Configurator referenceFilter(String referenceURI, String ownerTypeURI) {
        EReference reference = this.getEcoreElement(referenceURI, EReference.class).orElseThrow(() -> new IllegalArgumentException("missing or invalid reference URI"));
        EClass ownerType = this.getEcoreElement(ownerTypeURI, EClass.class).orElse(reference.getEContainingClass());
        return config -> config.filterReferences((ref, owner) -> ref == reference && ownerType.isInstance(owner));
    }
}

