/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;

public abstract class AbstractDirectedRelationshipReorientCommand<R extends DirectedRelationship, S extends Element, T extends Element>
extends EditElementCommand {
    protected final int reorientDirection;
    protected final EObject oldEnd;
    protected final EObject newEnd;

    public AbstractDirectedRelationshipReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof DirectedRelationship)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected abstract boolean canReorientSource();

    protected abstract boolean canReorientTarget();

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected abstract CommandResult reorientSource() throws ExecutionException;

    protected abstract CommandResult reorientTarget() throws ExecutionException;

    protected R getLink() {
        DirectedRelationship elementToEdit = (DirectedRelationship)this.getElementToEdit();
        return (R)elementToEdit;
    }

    protected S getOldSource() {
        return (S)((Element)this.oldEnd);
    }

    protected S getNewSource() {
        return (S)((Element)this.newEnd);
    }

    protected T getOldTarget() {
        return (T)((Element)this.oldEnd);
    }

    protected T getNewTarget() {
        return (T)((Element)this.newEnd);
    }
}

