/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public class TypeScope
extends ApiElement
implements IApiTypeContainer {
    private IApiComponent fComponent;
    private Map<String, Set<IReferenceTypeDescriptor>> fPackageToTypes;

    public TypeScope(IApiComponent component, IReferenceTypeDescriptor[] types) {
        super(component, 3, null);
        this.fComponent = component;
        this.fPackageToTypes = new HashMap<String, Set<IReferenceTypeDescriptor>>();
        IReferenceTypeDescriptor[] iReferenceTypeDescriptorArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IReferenceTypeDescriptor type = iReferenceTypeDescriptorArray[n2];
            String name = type.getPackage().getName();
            Set<IReferenceTypeDescriptor> set = this.fPackageToTypes.get(name);
            if (set == null) {
                set = new HashSet<IReferenceTypeDescriptor>();
                this.fPackageToTypes.put(name, set);
            }
            set.add(type);
            ++n2;
        }
    }

    @Override
    public String[] getPackageNames() throws CoreException {
        Set<String> pkgs = this.fPackageToTypes.keySet();
        Object[] result = new String[pkgs.size()];
        pkgs.toArray(result);
        Arrays.sort(result);
        return result;
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this.fComponent)) {
            for (Map.Entry<String, Set<IReferenceTypeDescriptor>> entry : this.fPackageToTypes.entrySet()) {
                String pkg = entry.getKey();
                if (visitor.visitPackage(pkg)) {
                    for (IReferenceTypeDescriptor type : entry.getValue()) {
                        IApiTypeRoot classFile = this.fComponent.findTypeRoot(type.getQualifiedName());
                        if (classFile == null) continue;
                        visitor.visit(pkg, classFile);
                        visitor.end(pkg, classFile);
                    }
                }
                visitor.endVisitPackage(pkg);
            }
        }
        visitor.end(this.fComponent);
    }

    @Override
    public void close() throws CoreException {
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        IReferenceTypeDescriptor descriptor = Factory.typeDescriptor(qualifiedName);
        Set<IReferenceTypeDescriptor> types = this.fPackageToTypes.get(descriptor.getPackage().getName());
        if (types != null && types.contains(descriptor)) {
            return this.fComponent.findTypeRoot(qualifiedName);
        }
        return null;
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        if (this.fComponent.getSymbolicName().equals(id)) {
            return this.findTypeRoot(qualifiedName);
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("*** Type Search Scope ***\n");
        buffer.append("Component: ").append(this.fComponent);
        if (this.fPackageToTypes != null) {
            for (Map.Entry<String, Set<IReferenceTypeDescriptor>> entry : this.fPackageToTypes.entrySet()) {
                buffer.append("Package: ").append(entry.getKey()).append("\n");
                buffer.append("Types: ").append(entry.getValue().toString()).append("\n");
            }
        }
        return buffer.toString();
    }

    @Override
    public int getContainerType() {
        return 4;
    }
}

