/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ClassName;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.logic.AbstractRename;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;

public class RenameTrait
extends AbstractRename {
    private static final String RENAME_CLASS = PHPRefactoringCoreMessages.getString("RenameClassName.0");
    private ASTNode originalDeclaration;
    private IType[] types;

    public RenameTrait(IFile file, @Nullable ASTNode originalNode, String oldName, String newName, boolean searchTextual, @Nullable IType[] types) {
        super(file, oldName, newName, searchTextual);
        if (originalNode != null) {
            this.originalDeclaration = RefactoringUtility.getTypeOrClassInstance(originalNode);
        }
        this.types = types;
    }

    public boolean visit(StaticConstantAccess staticDispatch) {
        Expression className = staticDispatch.getClassName();
        Identifier identifier = null;
        if (className instanceof Variable) {
            identifier = (Identifier)((Variable)className).getName();
        }
        if (className instanceof Identifier) {
            identifier = (Identifier)className;
        }
        if (identifier != null) {
            this.checkIdentifier(identifier);
        }
        return false;
    }

    public boolean visit(StaticFieldAccess staticDispatch) {
        this.checkIdentifier((Identifier)staticDispatch.getClassName());
        return false;
    }

    public boolean visit(StaticMethodInvocation staticDispatch) {
        this.checkIdentifier((Identifier)staticDispatch.getClassName());
        return false;
    }

    public boolean visit(ClassName className) {
        if (className.getName() instanceof Identifier) {
            NamespaceName namespaceName;
            Identifier identifier = (Identifier)className.getName();
            if (identifier instanceof NamespaceName && (namespaceName = (NamespaceName)identifier).segments() != null && namespaceName.segments().size() > 0) {
                identifier = (Identifier)namespaceName.segments().get(namespaceName.segments().size() - 1);
            }
            this.checkIdentifier(identifier);
        }
        return false;
    }

    public boolean visit(TraitDeclaration classDeclaration) {
        ITypeBinding originalType = null;
        if (this.originalDeclaration != null) {
            if (this.originalDeclaration instanceof TraitDeclaration) {
                originalType = ((TraitDeclaration)this.originalDeclaration).resolveTypeBinding();
            } else if (this.originalDeclaration instanceof NamespaceName) {
                originalType = ((NamespaceName)this.originalDeclaration).resolveTypeBinding();
            }
        }
        ITypeBinding currType = classDeclaration.resolveTypeBinding();
        if (this.originalDeclaration == null || this.originalDeclaration.getStart() == classDeclaration.getStart() || originalType != null && originalType.equals((Object)currType) || originalType != null && originalType.isSubTypeCompatible(currType)) {
            this.checkIdentifier(classDeclaration.getName());
        }
        return true;
    }

    public boolean visit(TraitUseStatement part) {
        for (NamespaceName namespace : part.getTraitList()) {
            if (!(namespace instanceof Identifier)) continue;
            this.checkIdentifier((Identifier)namespace);
        }
        return true;
    }

    public boolean visit(TraitPrecedenceStatement tps) {
        if (tps.getPrecedence().getMethodReference().getClassName() instanceof Identifier) {
            this.checkIdentifier((Identifier)tps.getPrecedence().getMethodReference().getClassName());
        }
        for (NamespaceName namespace : tps.getPrecedence().getTrList()) {
            if (!(namespace instanceof Identifier)) continue;
            this.checkIdentifier((Identifier)namespace);
        }
        return false;
    }

    public boolean visit(TraitAliasStatement tas) {
        FullyQualifiedTraitMethodReference reference;
        int type = tas.getAlias().getTraitMethod().getType();
        if (type == 73 && (reference = (FullyQualifiedTraitMethodReference)tas.getAlias().getTraitMethod()).getClassName() instanceof Identifier) {
            this.checkIdentifier((Identifier)reference.getClassName());
        }
        return false;
    }

    protected void checkIdentifier(Identifier identifier) {
        if (this.checkForNameEquality(identifier)) {
            if (this.types == null || this.types.length == 0) {
                this.addChange(identifier);
                return;
            }
            try {
                IModelElement[] elements = identifier.getProgramRoot().getSourceModule().codeSelect(identifier.getStart(), 0);
                int i = 0;
                while (i < elements.length) {
                    int j = 0;
                    while (j < this.types.length) {
                        if (elements[i] instanceof IType && elements[i].equals(this.types[j])) {
                            this.addChange(identifier);
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
    }

    private boolean checkForNameEquality(Identifier identifier) {
        return identifier != null && identifier.getName() != null && identifier.getName().equalsIgnoreCase(this.oldName);
    }

    @Override
    public String getRenameDescription() {
        return RENAME_CLASS;
    }
}

