/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.generator.egf.xwt.tools;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.fix.CodeFormatCleanUp;
import org.eclipse.jdt.internal.ui.fix.ImportsCleanUp;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.formatter.XMLFormatterFormatProcessor;

public class CleanUpUtils {
    private CleanUpUtils() {
    }

    public static void cleanUp(Shell shell, IProject project) {
        if (shell == null || project == null) {
            return;
        }
        CleanUpUtils.cleanUpJava(shell, project);
        CleanUpUtils.cleanUpXWT(shell, project);
    }

    private static void cleanUpXWT(Shell shell, IProject project) {
        if (shell == null || project == null) {
            return;
        }
        final HashSet<IFile> xwtFiles = new HashSet<IFile>();
        CleanUpUtils.collectXWTFiles(project, xwtFiles);
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Preferences preferences = XMLCorePlugin.getDefault().getPluginPreferences();
                preferences.setValue("clearAllBlankLines", true);
                XMLFormatterFormatProcessor processor = new XMLFormatterFormatProcessor();
                for (IFile file : xwtFiles) {
                    try {
                        processor.formatFile(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static void collectXWTFiles(Object element, HashSet<IFile> xwtFiles) {
        if (element instanceof IFile) {
            if ("xwt".equals(((IFile)element).getFileExtension())) {
                xwtFiles.add((IFile)element);
            }
        } else if (element instanceof IContainer) {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = ((IContainer)element).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource = iResourceArray[n2];
                    CleanUpUtils.collectXWTFiles(iResource, xwtFiles);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static void cleanUpJava(final Shell shell, IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        HashSet<IJavaElement> result = new HashSet<IJavaElement>();
        CleanUpUtils.collectCompilationUnits(javaProject, result);
        final ICompilationUnit[] units = result.toArray(new ICompilationUnit[result.size()]);
        Hashtable<String, String> settings = new Hashtable<String, String>();
        settings.put("cleanup.format_source_code", "true");
        CodeFormatCleanUp codeFormatCleanUp = new CodeFormatCleanUp(settings);
        settings = new Hashtable();
        settings.put("cleanup.organize_imports", "true");
        ImportsCleanUp importsCleanUp = new ImportsCleanUp(settings);
        final ICleanUp[] cleanUps = new ICleanUp[]{codeFormatCleanUp, importsCleanUp};
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    RefactoringExecutionStarter.startCleanupRefactoring((ICompilationUnit[])units, (ICleanUp[])cleanUps, (boolean)false, (Shell)shell, (boolean)false, (String)"Format Java Codes");
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void collectCompilationUnits(Object element, Collection<IJavaElement> result) {
        block19: {
            try {
                if (element instanceof IJavaElement) {
                    IJavaElement elem = (IJavaElement)element;
                    if (!elem.exists()) break block19;
                    switch (elem.getElementType()) {
                        case 7: {
                            if (elem.getParent().getElementType() == 5) {
                                result.add(elem.getParent());
                                break;
                            }
                            break block19;
                        }
                        case 5: {
                            result.add(elem);
                            break;
                        }
                        case 12: {
                            result.add(elem.getParent());
                            break;
                        }
                        case 4: {
                            CleanUpUtils.collectCompilationUnits((IPackageFragment)elem, result);
                            break;
                        }
                        case 3: {
                            CleanUpUtils.collectCompilationUnits((IPackageFragmentRoot)elem, result);
                            break;
                        }
                        case 2: {
                            IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                            int k = 0;
                            while (k < roots.length) {
                                CleanUpUtils.collectCompilationUnits(roots[k], result);
                                ++k;
                            }
                            break block1;
                        }
                    }
                    break block19;
                }
                if (element instanceof LogicalPackage) {
                    IPackageFragment[] packageFragments = ((LogicalPackage)element).getFragments();
                    int k = 0;
                    while (k < packageFragments.length) {
                        IPackageFragment pack = packageFragments[k];
                        if (pack.exists()) {
                            CleanUpUtils.collectCompilationUnits(pack, result);
                        }
                        ++k;
                    }
                } else if (element instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)element;
                    IAdaptable[] elements = workingSet.getElements();
                    int j = 0;
                    while (j < elements.length) {
                        CleanUpUtils.collectCompilationUnits(elements[j], result);
                        ++j;
                    }
                }
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block19;
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    private static void collectCompilationUnits(IPackageFragment pack, Collection<IJavaElement> result) throws JavaModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private static void collectCompilationUnits(IPackageFragmentRoot root, Collection<IJavaElement> result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                CleanUpUtils.collectCompilationUnits((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }
}

