/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.editor.ISiriusEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.editor.Messages;
import org.eclipse.sirius.ui.editor.SessionEditorPlugin;
import org.eclipse.sirius.ui.editor.api.pages.AbstractSessionEditorPage;
import org.eclipse.sirius.ui.editor.api.pages.PageProviderRegistry;
import org.eclipse.sirius.ui.editor.api.pages.PageUpdateCommandBuilder;
import org.eclipse.sirius.ui.editor.internal.pages.PageProviderListener;
import org.eclipse.sirius.ui.editor.internal.pages.RemovePageCommand;
import org.eclipse.sirius.ui.editor.internal.pages.RenameTabLabelCommand;
import org.eclipse.sirius.ui.editor.internal.pages.ReorderPageCommand;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.IModelExplorerView;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SessionEditor
extends SharedHeaderFormEditor
implements ITabbedPropertySheetPageContributor,
IModelExplorerView,
SessionListener,
ISiriusEditor,
PageProviderListener {
    public static final String EDITOR_ID = "org.eclipse.sirius.ui.editor.session";
    private Session session;
    private TabbedPropertySheetPage propertySheetPage;
    private CommandStackListener listener;
    private int choice = 3;
    private PageProviderRegistry pageRegistry;
    private SessionResourceSetListener resourceSetListener;

    protected void addPages() {
        this.updatePages(null);
    }

    private void updatePages(ResourceSetChangeEvent event) {
        if (this.pageRegistry == null) {
            return;
        }
        List<AbstractSessionEditorPage> newOrderedPages = this.pageRegistry.getPagesOrdered(this, this.session, this.pages.stream().filter(AbstractSessionEditorPage.class::isInstance).map(AbstractSessionEditorPage.class::cast).collect(Collectors.toList()), event);
        CTabFolder cTabF = (CTabFolder)this.getContainer();
        IFormPage lastActivePage = this.getActivePageInstance();
        int i = 0;
        while (i < newOrderedPages.size()) {
            AbstractSessionEditorPage page = newOrderedPages.get(i);
            int pageIndex = this.pages.indexOf((Object)page);
            if (pageIndex != -1) {
                if (pageIndex != i) {
                    this.updatePageTabPosition(cTabF, page, pageIndex, i);
                }
            } else {
                try {
                    this.addPage(i, (IFormPage)page);
                }
                catch (PartInitException e) {
                    String errorMessage = MessageFormat.format(Messages.UI_SessionEditor_page_loading_error_message, new Object[0]);
                    SessionEditorPlugin.getPlugin().error(errorMessage, (Exception)((Object)e));
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)errorMessage, (String)e.getMessage(), (IStatus)e.getStatus());
                }
            }
            ++i;
        }
        if (newOrderedPages.size() < this.pages.size()) {
            i = newOrderedPages.size();
            while (i < this.pages.size()) {
                if (lastActivePage.equals(this.pages.get(i))) {
                    lastActivePage = null;
                }
                this.removePage(i);
                ++i;
            }
        }
        cTabF.getParent().layout();
        if (this.getActivePageInstance() == null && lastActivePage != null) {
            this.setActivePage(lastActivePage);
        }
    }

    public List<IFormPage> getPages() {
        return this.pages.stream().filter(IFormPage.class::isInstance).map(IFormPage.class::cast).collect(Collectors.toList());
    }

    private void updatePageTabPosition(CTabFolder cTabF, AbstractSessionEditorPage page, int originalPositionIndex, int targetPositionIndex) {
        cTabF.getItem(originalPositionIndex).dispose();
        this.pages.remove(originalPositionIndex);
        CTabItem item = new CTabItem(cTabF, 0, targetPositionIndex);
        item.setText(page.getTitle());
        item.setControl(page.getPartControl());
        this.pages.add(targetPositionIndex, page);
        this.updatePageIndices(0);
    }

    private void updatePageIndices(int start) {
        int i = start;
        while (i < this.pages.size()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage) {
                IFormPage fpage = (IFormPage)page;
                fpage.setIndex(i);
            }
            ++i;
        }
    }

    public void setActivePage(IFormPage activePage) {
        if (activePage != null) {
            int activePageIndex = this.pages.indexOf(activePage);
            if (activePageIndex != -1) {
                this.setActivePage(activePageIndex);
            } else {
                SessionEditorPlugin.getPlugin().error(MessageFormat.format(Messages.SessionEditor_PageActivation_Failure, activePage.getClass().getName()), null);
            }
        }
    }

    public void setActivePage(int pageIndex) {
        Object pageToSelect = this.pages.get(pageIndex);
        if (pageToSelect instanceof AbstractSessionEditorPage) {
            AbstractSessionEditorPage theSelectedPage = (AbstractSessionEditorPage)((Object)pageToSelect);
            Optional<PageUpdateCommandBuilder.PageUpdateCommand> selectedPageCommand = theSelectedPage.pageChanged(true);
            ArrayList<Runnable> commandsToExecute = new ArrayList<Runnable>();
            commandsToExecute.addAll(this.prepareUpdateCommands(theSelectedPage, selectedPageCommand));
            for (Object page : this.pages) {
                AbstractSessionEditorPage sessionEditorPage;
                if (!(page instanceof AbstractSessionEditorPage) || (sessionEditorPage = (AbstractSessionEditorPage)((Object)page)).getIndex() == theSelectedPage.getIndex()) continue;
                Optional<PageUpdateCommandBuilder.PageUpdateCommand> pageCommand = sessionEditorPage.pageChanged(false);
                commandsToExecute.addAll(this.prepareUpdateCommands(sessionEditorPage, pageCommand));
            }
            commandsToExecute.stream().forEach(Runnable::run);
            this.getContainer().getParent().layout();
            int selectedPageIndex = this.pages.indexOf(pageToSelect);
            if (selectedPageIndex > -1) {
                super.setActivePage(selectedPageIndex);
            } else {
                super.setActivePage(0);
            }
        }
    }

    @Override
    public void pageProviderChanged() {
        this.updatePages(null);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IEditorInput editorInput = this.getEditorInput();
        URI sessionResourceURI = null;
        if (editorInput instanceof FileEditorInput) {
            IFile sessionResourceFile = ((FileEditorInput)editorInput).getFile();
            sessionResourceURI = URI.createPlatformResourceURI((String)sessionResourceFile.getFullPath().toOSString(), (boolean)true);
        } else if (editorInput instanceof URIEditorInput) {
            sessionResourceURI = ((URIEditorInput)editorInput).getURI();
        } else {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)MessageFormat.format(Messages.UI_SessionEditor_session_loading_error_message, new Object[0]), (String)MessageFormat.format(Messages.UI_SessionEditor_inputNotHandled_error_message, editorInput.getClass().getSimpleName()), (IStatus)Status.CANCEL_STATUS);
        }
        try {
            if (sessionResourceURI != null) {
                final URI sessionResourceURIFinal = sessionResourceURI;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(sessionResourceURIFinal.toPlatformString(true)));
                IProject project = file.getProject();
                if (ModelingProject.hasModelingProjectNature((IProject)project)) {
                    this.setPartName(sessionResourceURIFinal.segments()[1]);
                } else {
                    this.setPartName(sessionResourceURIFinal.lastSegment());
                    this.setContentDescription(sessionResourceURIFinal.toPlatformString(true));
                }
                IRunnableWithProgress exportAllRepresentationsRunnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                        subMonitor.beginTask(MessageFormat.format(Messages.UI_SessionEditor_session_loading_task_title, new Object[0]), 1);
                        SessionEditor.this.session = SessionManager.INSTANCE.openSession(sessionResourceURIFinal, (IProgressMonitor)subMonitor, SiriusEditPlugin.getPlugin().getUiCallback(), true);
                        SessionEditor.this.session.addListener((SessionListener)SessionEditor.this);
                        IEditingSession editingSession = SessionUIManager.INSTANCE.getOrCreateUISession(SessionEditor.this.session);
                        editingSession.open();
                        editingSession.attachEditor((ISiriusEditor)SessionEditor.this);
                        SessionEditor.this.resourceSetListener = new SessionResourceSetListener();
                        SessionEditor.this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)SessionEditor.this.resourceSetListener);
                        subMonitor.worked(1);
                        subMonitor.done();
                    }
                };
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                pmd.run(false, false, exportAllRepresentationsRunnable);
                this.listener = new CommandStackListener(){

                    public void commandStackChanged(EventObject event) {
                        SessionEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SessionEditor.this.firePropertyChange(257);
                                if (SessionEditor.this.propertySheetPage == null || SessionEditor.this.propertySheetPage.getControl() == null || SessionEditor.this.propertySheetPage.getControl().isDisposed()) {
                                    SessionEditor.this.propertySheetPage = null;
                                } else if (SessionEditor.this.propertySheetPage.getCurrentTab() != null) {
                                    SessionEditor.this.propertySheetPage.refresh();
                                }
                            }
                        });
                    }
                };
                this.session.getTransactionalEditingDomain().getCommandStack().addCommandStackListener(this.listener);
            }
        }
        catch (InvocationTargetException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)MessageFormat.format(Messages.UI_SessionEditor_session_loading_error_message, new Object[0]), (String)e.getMessage(), (IStatus)Status.CANCEL_STATUS);
            throw new PartInitException(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (InterruptedException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)MessageFormat.format(Messages.UI_SessionEditor_session_loading_error_message, new Object[0]), (String)e.getMessage(), (IStatus)Status.CANCEL_STATUS);
            throw new PartInitException(e.getMessage(), (Throwable)e);
        }
        this.pageRegistry = SessionEditorPlugin.getPlugin().getPageRegistry();
        this.pageRegistry.addRegistryListener(this);
    }

    public void dispose() {
        if (this.resourceSetListener != null && this.session != null && this.session.getTransactionalEditingDomain() != null) {
            this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.resourceSetListener);
            this.resourceSetListener = null;
        }
        if (this.session != null) {
            IEditingSession editingSession = SessionUIManager.INSTANCE.getUISession(this.session);
            if (editingSession != null) {
                editingSession.detachEditor((ISiriusEditor)this, this.choice == 1);
            }
            if (this.session.getTransactionalEditingDomain() != null) {
                this.session.getTransactionalEditingDomain().getCommandStack().removeCommandStackListener(this.listener);
            }
        }
        this.session = null;
        this.propertySheetPage = null;
        super.dispose();
    }

    public void close(boolean save) {
        if (this.pageRegistry != null) {
            this.pageRegistry.removeRegistryListener(this);
            this.pageRegistry = null;
        }
        super.close(save);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                Object page = this.pages.get(i);
                if (page instanceof IFormPage) {
                    ((IFormPage)page).doSave(monitor);
                }
                ++i;
            }
        }
    }

    public Object getAdapter(Class type) {
        Object result = null;
        if (type == IPropertySheetPage.class) {
            IPropertySheetPage contributedPage = SiriusEditPlugin.getPlugin().getPropertySheetPage((Object)this, this.getContributorId());
            if (contributedPage != null) {
                result = contributedPage;
            } else {
                this.propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
                result = this.propertySheetPage;
            }
        }
        if (result == null) {
            result = super.getAdapter(type);
        }
        return result;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getContributorId() {
        return "org.eclipse.sirius.ui.tools.views.model.explorer";
    }

    public void notify(int changeKind) {
        switch (changeKind) {
            case 8: {
                this.close(false);
                break;
            }
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public EditingDomain getEditingDomain() {
        return this.session.getTransactionalEditingDomain();
    }

    public Saveable[] getSaveables() {
        IEditingSession uiSession;
        if (SessionUIManager.INSTANCE != null && this.session != null && this.session.isOpen() && (uiSession = SessionUIManager.INSTANCE.getUISession(this.session)) instanceof ISaveablesSource) {
            return ((ISaveablesSource)uiSession).getSaveables();
        }
        return new Saveable[0];
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public int promptToSaveOnClose() {
        IEditingSession uiSession;
        this.choice = 3;
        if (this.session != null && this.session.isOpen() && (uiSession = SessionUIManager.INSTANCE.getUISession(this.session)) != null && uiSession.needToBeSavedOnClose((IEditorPart)this)) {
            this.choice = uiSession.promptToSaveOnClose();
        }
        return this.choice;
    }

    public Session getSession() {
        return this.session;
    }

    private List<Runnable> prepareUpdateCommands(AbstractSessionEditorPage customPage, Optional<PageUpdateCommandBuilder.PageUpdateCommand> updateCommand) {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(2);
        updateCommand.ifPresent(updateCommandTemp -> {
            boolean removeCommandExecuted = false;
            if (updateCommandTemp.getRemoveCommand() != null) {
                runnables.add(this.prepareRemoveCommand(updateCommandTemp.getRemoveCommand(), this, customPage));
                removeCommandExecuted = true;
            }
            if (!removeCommandExecuted && updateCommandTemp.getReorderCommand() != null) {
                runnables.add(this.prepareReorderCommand(updateCommandTemp.getReorderCommand(), this, customPage));
            } else if (updateCommandTemp.getReorderCommand() != null) {
                SessionEditorPlugin.getPlugin().error(MessageFormat.format(Messages.SessionEditor_PageCommand_Integrity_Error, ((Object)((Object)customPage)).getClass().getName()), null);
            }
            if (!removeCommandExecuted && updateCommandTemp.getRenameCommand() != null) {
                runnables.add(this.prepareRenameCommand(updateCommandTemp.getRenameCommand(), this, customPage));
            } else if (updateCommandTemp.getRenameCommand() != null) {
                SessionEditorPlugin.getPlugin().error(MessageFormat.format(Messages.SessionEditor_PageCommand_Integrity_Error, ((Object)((Object)customPage)).getClass().getName()), null);
            }
        });
        return runnables;
    }

    private Runnable prepareReorderCommand(ReorderPageCommand pageUpdateCommand, SessionEditor editor, AbstractSessionEditorPage page) {
        return () -> {
            Composite container = editor.getContainer();
            if (container instanceof CTabFolder) {
                CTabFolder tabFolder = (CTabFolder)editor.getContainer();
                int targetPageIndex = -1;
                String targetPageId = pageUpdateCommand.getTargetPageId();
                for (Object object : this.pages) {
                    if (!(object instanceof AbstractSessionEditorPage) || !targetPageId.equals(((AbstractSessionEditorPage)((Object)((Object)object))).getId())) continue;
                    targetPageIndex = ((AbstractSessionEditorPage)((Object)((Object)object))).getIndex();
                    break;
                }
                int commandingPageIndex = this.pages.indexOf((Object)page);
                if (commandingPageIndex != -1 && targetPageIndex != -1) {
                    switch (pageUpdateCommand.getPositioningKind()) {
                        case AFTER: {
                            if (targetPageIndex + 1 == commandingPageIndex) break;
                            this.updatePageTabPosition(tabFolder, page, commandingPageIndex, targetPageIndex);
                            break;
                        }
                        case BEFORE: {
                            if (commandingPageIndex + 1 == targetPageIndex) break;
                            this.updatePageTabPosition(tabFolder, page, commandingPageIndex, targetPageIndex);
                            break;
                        }
                        case REPLACE: {
                            editor.removePage(targetPageIndex);
                            commandingPageIndex = this.pages.indexOf((Object)page);
                            int targetPageIndexAfterRemoval = targetPageIndex > 0 && targetPageIndex >= this.pages.size() ? targetPageIndex - 1 : targetPageIndex;
                            this.updatePageTabPosition(tabFolder, page, commandingPageIndex, targetPageIndexAfterRemoval);
                            break;
                        }
                    }
                }
            }
        };
    }

    private Runnable prepareRemoveCommand(RemovePageCommand pageUpdateCommand, SessionEditor editor, AbstractSessionEditorPage page) {
        return () -> {
            int pageToRemoveIndex = sessionEditor.pages.indexOf((Object)page);
            if (pageToRemoveIndex != -1) {
                editor.removePage(pageToRemoveIndex);
            }
        };
    }

    private Runnable prepareRenameCommand(RenameTabLabelCommand pageUpdateCommand, SessionEditor editor, AbstractSessionEditorPage page) {
        return () -> {
            Vector pages;
            int index;
            Composite container = editor.getContainer();
            if (container instanceof CTabFolder && (index = (pages = sessionEditor.pages).indexOf((Object)page)) != -1) {
                CTabFolder tabFolder = (CTabFolder)container;
                CTabItem tabItem = tabFolder.getItem(index);
                tabItem.setText(pageUpdateCommand.getNewLabel());
            }
        };
    }

    private final class SessionResourceSetListener
    extends ResourceSetListenerImpl {
        private SessionResourceSetListener() {
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            int pageCount = SessionEditor.this.getPageCount();
            ArrayList commandsToExecute = new ArrayList();
            int i = 0;
            while (i < pageCount) {
                Object page = SessionEditor.this.pages.get(i);
                if (page instanceof AbstractSessionEditorPage) {
                    AbstractSessionEditorPage customPage = (AbstractSessionEditorPage)((Object)page);
                    Optional<NotificationFilter> notificationFilter = customPage.getFilterForPageRequesting();
                    boolean reactToNotification = event.getNotifications().stream().anyMatch(notification -> notificationFilter.isPresent() ? true : ((NotificationFilter)notificationFilter.get()).matches(notification));
                    if (reactToNotification) {
                        Optional<PageUpdateCommandBuilder.PageUpdateCommand> updateCommand = customPage.resourceSetChanged(event);
                        commandsToExecute.addAll(SessionEditor.this.prepareUpdateCommands(customPage, updateCommand));
                    }
                }
                ++i;
            }
            if (commandsToExecute.size() > 0) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    commandsToExecute.stream().forEach(Runnable::run);
                    SessionEditor.this.updatePages(event);
                });
            }
        }

        public boolean isPostcommitOnly() {
            return true;
        }
    }
}

