/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.hover;

import java.util.Map;
import org.eclipse.cdt.debug.ui.editors.AbstractDebugTextHover;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.cdt.ui.hover.ExpressionInformationControlCreator;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFNumberFormat;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;

public class TCFDebugTextHover
extends AbstractDebugTextHover
implements ITextHoverExtension2 {
    private TCFNode node;
    private boolean running;

    public IInformationControlCreator getHoverControlCreator() {
        if (this.useExpressionExplorer()) {
            return this.createExpressionInformationControlCreator();
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    private IInformationControlCreator createExpressionInformationControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    protected boolean useExpressionExplorer() {
        return true;
    }

    private boolean getNode(TCFNode selection, Runnable done) {
        this.node = null;
        this.running = false;
        TCFNodeStackFrame frame = null;
        TCFNodeExecContext exe = null;
        if (selection instanceof TCFNodeStackFrame) {
            frame = (TCFNodeStackFrame)selection;
            exe = (TCFNodeExecContext)frame.getParent();
        } else if (selection instanceof TCFNodeExecContext) {
            exe = (TCFNodeExecContext)selection;
        } else {
            return true;
        }
        TCFDataCache state_cache = exe.getState();
        if (!state_cache.validate(done)) {
            return false;
        }
        TCFContextState state_data = (TCFContextState)state_cache.getData();
        if (state_data == null || !state_data.is_suspended) {
            if (exe.getModel().getHoverWhileRunning()) {
                this.running = true;
                this.node = exe;
            }
        } else {
            if (frame == null) {
                TCFChildrenStackTrace stack = exe.getStackTrace();
                if (!stack.validate(done)) {
                    return false;
                }
                frame = stack.getTopFrame();
            }
            if (frame != null && !frame.isEmulated()) {
                this.node = frame;
            }
        }
        return true;
    }

    protected boolean canEvaluate() {
        IAdaptable context = this.getSelectionAdaptable();
        if (context == null) {
            return false;
        }
        final TCFNode selection = (TCFNode)context.getAdapter(TCFNode.class);
        if (selection == null) {
            return false;
        }
        try {
            return (Boolean)new TCFTask<Boolean>(selection.getChannel()){

                public void run() {
                    if (!TCFDebugTextHover.this.getNode(selection, (Runnable)((Object)this))) {
                        return;
                    }
                    this.done(TCFDebugTextHover.this.node != null);
                }
            }.get();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object getHoverInfo2(ITextViewer viewer, IRegion region) {
        if (!this.useExpressionExplorer()) {
            return this.getHoverInfo(viewer, region);
        }
        IAdaptable context = this.getSelectionAdaptable();
        if (context == null) {
            return null;
        }
        final TCFNode selection = (TCFNode)context.getAdapter(TCFNode.class);
        if (selection == null) {
            return null;
        }
        final String text = this.getExpressionText(viewer, region);
        if (text == null || text.length() == 0) {
            return null;
        }
        try {
            return new TCFTask<Object>(selection.getChannel()){

                public void run() {
                    if (!TCFDebugTextHover.this.getNode(selection, (Runnable)((Object)this))) {
                        return;
                    }
                    if (TCFDebugTextHover.this.node != null) {
                        TCFChildren cache = TCFDebugTextHover.this.node.getModel().getHoverExpressionCache(TCFDebugTextHover.this.node, text);
                        if (!cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        Map nodes = (Map)cache.getData();
                        if (nodes != null) {
                            boolean ok = false;
                            for (TCFNode n : nodes.values()) {
                                TCFDataCache value;
                                TCFNodeExpression expr = (TCFNodeExpression)n;
                                if (TCFDebugTextHover.this.running) {
                                    expr.update((Object)this);
                                }
                                if (!(value = expr.getValue()).validate((Runnable)((Object)this))) {
                                    return;
                                }
                                if (value.getData() == null) continue;
                                ok = true;
                            }
                            if (ok) {
                                this.done(TCFDebugTextHover.this.node);
                                return;
                            }
                        }
                    }
                    this.done(null);
                }
            }.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String evaluateExpression(final String expression) {
        IAdaptable context = this.getSelectionAdaptable();
        if (context == null) {
            return null;
        }
        final TCFNode selection = (TCFNode)context.getAdapter(TCFNode.class);
        if (selection == null) {
            return null;
        }
        final IChannel channel = selection.getChannel();
        return (String)new TCFTask<String>(channel){

            public void run() {
                final IExpressions service = (IExpressions)channel.getRemoteService(IExpressions.class);
                if (!TCFDebugTextHover.this.getNode(selection, (Runnable)((Object)this))) {
                    return;
                }
                if (service != null && TCFDebugTextHover.this.node != null) {
                    service.create(TCFDebugTextHover.this.node.getID(), null, expression, new IExpressions.DoneCreate(){

                        public void doneCreate(IToken token, Exception error, final IExpressions.Expression context) {
                            if (error == null) {
                                service.evaluate(context.getID(), new IExpressions.DoneEvaluate(){

                                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                                        this.done(error == null && value != null ? TCFDebugTextHover.getValueText(value) : null);
                                        service.dispose(context.getID(), new IExpressions.DoneDispose(){

                                            public void doneDispose(IToken token, Exception error) {
                                            }
                                        });
                                    }
                                });
                            } else {
                                this.done(null);
                            }
                        }
                    });
                } else {
                    this.done(null);
                }
            }
        }.getE();
    }

    private static String getValueText(IExpressions.Value value) {
        byte[] data = value.getValue();
        if (data == null) {
            return "N/A";
        }
        switch (value.getTypeClass()) {
            case integer: {
                return TCFNumberFormat.toBigInteger((byte[])data, (boolean)value.isBigEndian(), (boolean)true).toString();
            }
            case real: {
                return TCFNumberFormat.toFPString((byte[])data, (boolean)value.isBigEndian());
            }
            case complex: {
                return TCFNumberFormat.toComplexFPString((byte[])data, (boolean)value.isBigEndian());
            }
        }
        return "0x" + TCFNumberFormat.toBigInteger((byte[])data, (boolean)value.isBigEndian(), (boolean)false).toString(16);
    }
}

