/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards.pages;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.interfaces.IExportPersistenceService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.views.navigator.DelegatingLabelProvider;
import org.eclipse.ui.progress.UIJob;

public class PeerExportWizardPage
extends WizardPage {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String OVERWRITE = "overwrite";
    private static final String OLD_PATH = "oldpath";
    CheckboxTableViewer fViewer;
    Text fDestinationField;
    private Button fDestinationButton;
    private Button fOverwrite;
    private IStructuredSelection fSelection;

    public PeerExportWizardPage(IStructuredSelection selection) {
        super(Messages.PeerExportWizard_title);
        this.setTitle(Messages.PeerExportWizard_title);
        this.setMessage(Messages.PeerExportWizard_message);
        this.fSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createPeersGroup(composite);
        this.createDestinationGroup(composite);
        ArrayList<IPeerNode> elements = new ArrayList<IPeerNode>();
        for (Object element : this.fSelection) {
            IPeerNode peerNode = (IPeerNode)Platform.getAdapterManager().getAdapter(element, IPeerNode.class);
            if (peerNode == null) continue;
            elements.add((IPeerNode)element);
        }
        this.fViewer.setCheckedElements(elements.toArray());
        this.setPageComplete(this.isComplete());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    private final void createPeersGroup(Composite parent) {
        Composite resourcesGroup = new Composite(parent, 0);
        resourcesGroup.setLayout((Layout)new GridLayout());
        resourcesGroup.setLayoutData((Object)new GridData(1808));
        resourcesGroup.setFont(parent.getFont());
        new Label(resourcesGroup, 0).setText(Messages.PeerExportWizardPage_peers_label);
        Table table = new Table(resourcesGroup, 2080);
        table.setLayoutData((Object)new GridData(1808));
        this.fViewer = new CheckboxTableViewer(table);
        this.fViewer.setContentProvider((IContentProvider)new ITreePathContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IPeerModel) {
                    IPeerNode[] nodes = ((IPeerModel)inputElement).getPeerNodes();
                    ArrayList<IPeerNode> filteredNodes = new ArrayList<IPeerNode>();
                    IPeerNode[] iPeerNodeArray = nodes;
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPeerNode node = iPeerNodeArray[n2];
                        if (node.isVisible()) {
                            filteredNodes.add(node);
                        }
                        ++n2;
                    }
                    return filteredNodes.toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(TreePath parentPath) {
                return null;
            }

            public boolean hasChildren(TreePath path) {
                return false;
            }

            public TreePath[] getParents(Object element) {
                return null;
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DelegatingLabelProvider());
        ICheckStateListener checkListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PeerExportWizardPage.this.setPageComplete(PeerExportWizardPage.this.isComplete());
            }
        };
        this.fViewer.addCheckStateListener(checkListener);
        this.fViewer.setInput((Object)ModelManager.getPeerModel());
        Composite buttonComposite = new Composite(resourcesGroup, 0);
        buttonComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        Button selectButton = this.createButton(buttonComposite, 18, Messages.PeerExportWizardPage_selectAll, false);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeerExportWizardPage.this.fViewer.setAllChecked(true);
                PeerExportWizardPage.this.setPageComplete(PeerExportWizardPage.this.isComplete());
            }
        });
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.PeerExportWizardPage_deselectAll, false);
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeerExportWizardPage.this.fViewer.setAllChecked(false);
                PeerExportWizardPage.this.setPageComplete(PeerExportWizardPage.this.isComplete());
            }
        });
    }

    private Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = new Button(parent, 8);
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)id);
        button.setText(label);
        button.setFont(parent.getFont());
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        this.setButtonLayoutData(button);
        return button;
    }

    private void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        destinationSelectionGroup.setLayout((Layout)new GridLayout(3, false));
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(Messages.PeerExportWizardPage_destination_label);
        destinationLabel.setFont(font);
        this.fDestinationField = new Text(destinationSelectionGroup, 2048);
        this.fDestinationField.setFont(font);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 250;
        this.fDestinationField.setLayoutData((Object)gd);
        if (this.getDialogSettings().get(OLD_PATH) != null) {
            this.fDestinationField.setText(this.getDialogSettings().get(OLD_PATH));
        }
        this.fDestinationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PeerExportWizardPage.this.setPageComplete(PeerExportWizardPage.this.isComplete());
            }
        });
        this.fDestinationButton = this.createButton(destinationSelectionGroup, 18, Messages.PeerExportWizardPage_destination_button, false);
        this.fDestinationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(PeerExportWizardPage.this.getContainer().getShell());
                dd.setText(Messages.PeerExportWizardPage_destination_label);
                String file = dd.open();
                if (file != null) {
                    Path path = new Path(file);
                    PeerExportWizardPage.this.fDestinationField.setText(path.toOSString());
                    PeerExportWizardPage.this.setPageComplete(PeerExportWizardPage.this.isComplete());
                }
            }
        });
        this.fOverwrite = new Button(destinationSelectionGroup, 32);
        this.fOverwrite.setText(Messages.PeerExportWizardPage_overwrite_button);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fOverwrite.setLayoutData((Object)gd);
        this.fOverwrite.setSelection(this.getDialogSettings().getBoolean(OVERWRITE));
    }

    protected boolean isComplete() {
        Object[] elements = this.fViewer.getCheckedElements();
        boolean selected = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IPeerNode) {
                selected = true;
                break;
            }
            ++n2;
        }
        if (elements.length < 1 || !selected) {
            this.setErrorMessage(Messages.PeerExportWizardPage_peersMissing_error);
            return false;
        }
        String path = this.fDestinationField.getText().trim();
        if (path.length() == 0) {
            this.setErrorMessage(Messages.PeerExportWizardPage_destinationMissing_error);
            return false;
        }
        File dir = new File(path);
        if (dir.isFile()) {
            this.setErrorMessage(Messages.PeerExportWizardPage_destinationIsFile_error);
            return false;
        }
        if (!dir.isAbsolute()) {
            this.setErrorMessage(Messages.PeerExportWizardPage_destinationMissing_error);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.PeerExportWizard_message);
        return true;
    }

    public boolean finish() {
        final Object[] configs = this.fViewer.getCheckedElements();
        final boolean overwrite = this.fOverwrite.getSelection();
        final String path = this.fDestinationField.getText().trim();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(OVERWRITE, overwrite);
        settings.put(OLD_PATH, path);
        UIJob exportjob = new UIJob(this.getContainer().getShell().getDisplay(), Messages.PeerExportWizard_title){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Path destpath;
                File destfolder;
                boolean exist;
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                if (!(exist = (destfolder = (destpath = new Path(path)).toFile()).exists())) {
                    exist = destfolder.mkdirs();
                }
                if (exist) {
                    monitor.beginTask(Messages.PeerExportWizard_title, configs.length);
                    boolean toggleState = false;
                    int toggleResult = -1;
                    Object[] objectArray = configs;
                    int n = configs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block10: {
                            Object config = objectArray[n2];
                            IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(config, IExportPersistenceService.class);
                            if (service == null) {
                                service = (IURIPersistenceService)ServiceManager.getInstance().getService(config, IURIPersistenceService.class);
                            }
                            if (service != null) {
                                try {
                                    URI uri = service.getURI(config);
                                    File defaultFile = new File(uri.normalize());
                                    defaultFile = new Path(defaultFile.toString()).removeFileExtension().toFile();
                                    File file = destpath.append(defaultFile.getName()).addFileExtension("peer").toFile();
                                    if (file.exists() && !overwrite) {
                                        if (!toggleState || toggleResult < 0) {
                                            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)PeerExportWizardPage.this.getShell(), null, (String)NLS.bind((String)Messages.PeerExportWizardPage_overwriteDialog_message, (Object)file.toString()), (String)Messages.PeerExportWizardPage_overwriteDialogToggle_message, (boolean)toggleState, null, null);
                                            toggleState = dialog.getToggleState();
                                            toggleResult = dialog.getReturnCode();
                                        }
                                        if (toggleResult != 2) break block10;
                                    }
                                    service.write(config, file.toURI());
                                }
                                catch (Exception exception) {}
                            }
                            monitor.worked(1);
                        }
                        ++n2;
                    }
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        exportjob.schedule();
        return true;
    }
}

