/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density;

import java.text.Format;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.BaseMouseProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density.Messages;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;

public class SimpleTooltipProvider
extends BaseMouseProvider
implements MouseTrackListener {
    private static final Format FORMAT = new SubSecondTimeWithUnitFormat();

    public SimpleTooltipProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        super(densityViewer);
        this.register();
    }

    @Override
    public final void register() {
        this.getChart().getPlotArea().addMouseTrackListener((MouseTrackListener)this);
    }

    @Override
    public final void deregister() {
        if (!this.getChart().isDisposed()) {
            this.getChart().getPlotArea().removeMouseTrackListener((MouseTrackListener)this);
        }
    }

    public void mouseEnter(@Nullable MouseEvent e) {
    }

    public void mouseExit(@Nullable MouseEvent e) {
    }

    public void mouseHover(@Nullable MouseEvent e) {
        if (e == null || this.getChart().getAxisSet().getXAxes().length == 0 || this.getChart().getAxisSet().getYAxes().length == 0 || this.getDensityViewer().getControl().getSeriesSet().getSeries().length == 0) {
            return;
        }
        ISeries series = this.getDensityViewer().getControl().getSeriesSet().getSeries()[0];
        this.getChart().getPlotArea().setToolTipText(null);
        if (series instanceof IBarSeries) {
            IBarSeries barSeries = (IBarSeries)series;
            Rectangle[] bounds = barSeries.getBounds();
            if (barSeries.getXSeries().length < 2) {
                return;
            }
            double delta = barSeries.getXSeries()[1] - barSeries.getXSeries()[0];
            int i = 0;
            while (i < bounds.length) {
                Rectangle rec = bounds[i];
                if (rec != null) {
                    int start = rec.x;
                    int end = start + rec.width;
                    if (e.x >= start && e.x <= end) {
                        long x1 = (long)barSeries.getXSeries()[i];
                        long x2 = (long)((double)x1 + delta);
                        IAxis yAxis = this.getChart().getAxisSet().getYAxes()[0];
                        long y = Math.round(yAxis.getDataCoordinate(rec.y)) - 1L;
                        if (y <= 0L) break;
                        String toolTipText = MessageFormat.format(Messages.SimpleTooltipProvider_toolTipText, FORMAT.format(x1), FORMAT.format(x2), y);
                        this.getChart().getPlotArea().setToolTipText(toolTipText);
                        break;
                    }
                }
                ++i;
            }
        }
    }
}

