/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.segmentstore.core.IContentSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class TmfXmlPatternSegment
implements INamedSegment,
IContentSegment {
    private static final long serialVersionUID = 3556323761465412078L;
    private static final byte TYPE_NULL = -1;
    private static final byte TYPE_INTEGER = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_LONG = 2;
    private final long fStart;
    private final long fEnd;
    private final @NonNull String fSegmentName;
    private transient @NonNull Map<@NonNull String, @NonNull ITmfStateValue> fContent;
    public static final @NonNull IHTIntervalReader<@NonNull ISegment> READER = buffer -> {
        long start = buffer.getLong();
        long end = buffer.getLong();
        buffer.getInt();
        String segmentName = buffer.getString();
        int contentSize = buffer.getInt();
        HashMap<@NonNull String, @NonNull ITmfStateValue> content = new HashMap<String, ITmfStateValue>();
        int i = 0;
        while (i < contentSize) {
            TmfStateValue value;
            String name = buffer.getString().intern();
            Byte type = buffer.get();
            switch (type) {
                case -1: {
                    value = TmfStateValue.nullValue();
                    break;
                }
                case 0: {
                    value = TmfStateValue.newValueInt((int)buffer.getInt());
                    break;
                }
                case 2: {
                    value = TmfStateValue.newValueLong((long)buffer.getLong());
                    break;
                }
                case 1: {
                    value = TmfStateValue.newValueString((String)buffer.getString().intern());
                    break;
                }
                default: {
                    value = TmfStateValue.nullValue();
                    Activator.logError("Read segment failed : Invalid data, value will be set to null");
                }
            }
            content.put(name, (ITmfStateValue)value);
            ++i;
        }
        return new TmfXmlPatternSegment(start, end, segmentName, content);
    };

    public TmfXmlPatternSegment(long start, long end, String segmentName, @NonNull Map<@NonNull String, @NonNull ITmfStateValue> fields) {
        this.fStart = start;
        this.fEnd = end;
        this.fSegmentName = String.valueOf(segmentName);
        this.fContent = Collections.unmodifiableMap(fields);
    }

    public Map<@NonNull String, @NonNull ITmfStateValue> getContent() {
        return this.fContent;
    }

    public String getName() {
        return this.fSegmentName;
    }

    public int compareTo(@NonNull ISegment o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        return this.toString().compareTo(o.toString());
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", [fTimestampStart=" + this.getStart() + ", fTimestampEnd=" + this.getEnd() + ", duration= " + this.getLength() + ", fName=" + this.getName() + ", fContent=" + this.getContent() + "]";
    }

    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.fStart);
        buffer.putLong(this.fEnd);
        buffer.putInt(0);
        buffer.putString(this.fSegmentName);
        buffer.putInt(this.fContent.size());
        for (Map.Entry<String, ITmfStateValue> entry : this.fContent.entrySet()) {
            buffer.putString(entry.getKey());
            ITmfStateValue value = entry.getValue();
            byte type = TmfXmlPatternSegment.getByteFromType(value.getType());
            buffer.put(type);
            switch (type) {
                case -1: {
                    break;
                }
                case 0: {
                    buffer.putInt(value.unboxInt());
                    break;
                }
                case 2: {
                    buffer.putLong(value.unboxLong());
                    break;
                }
                case 1: {
                    @NonNull String string = value.unboxStr();
                    buffer.putString(string);
                    break;
                }
                default: {
                    Activator.logError("Write object failed : Invalid data");
                }
            }
        }
    }

    public int getSizeOnDisk() {
        int size = 20 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.fSegmentName) + 4;
        for (Map.Entry<String, ITmfStateValue> entry : this.fContent.entrySet()) {
            size += SafeByteBufferFactory.getStringSizeInBuffer((String)entry.getKey());
            ITmfStateValue value = entry.getValue();
            byte type = TmfXmlPatternSegment.getByteFromType(value.getType());
            ++size;
            switch (type) {
                case -1: {
                    break;
                }
                case 0: {
                    size += 4;
                    break;
                }
                case 2: {
                    size += 8;
                    break;
                }
                case 1: {
                    @NonNull String string = value.unboxStr();
                    size += SafeByteBufferFactory.getStringSizeInBuffer((String)string);
                    break;
                }
                default: {
                    Activator.logError("get segment size on disk failed : Invalid data");
                }
            }
        }
        return size;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.fContent.size());
        for (Map.Entry<String, ITmfStateValue> entry : this.fContent.entrySet()) {
            out.writeInt(entry.getKey().length());
            out.writeBytes(entry.getKey());
            ITmfStateValue value = entry.getValue();
            byte type = TmfXmlPatternSegment.getByteFromType(value.getType());
            out.writeByte(type);
            switch (type) {
                case -1: {
                    break;
                }
                case 0: {
                    out.writeInt(value.unboxInt());
                    break;
                }
                case 2: {
                    out.writeLong(value.unboxLong());
                    break;
                }
                case 1: {
                    @NonNull String string = value.unboxStr();
                    out.writeInt(string.length());
                    out.writeBytes(string);
                    break;
                }
                default: {
                    throw new IOException("Write object failed : Invalid data");
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int contentSize = in.readInt();
        HashMap<@NonNull String, @NonNull ITmfStateValue> content = new HashMap<String, ITmfStateValue>();
        int i = 0;
        while (i < contentSize) {
            TmfStateValue value;
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.read(bytes, 0, length);
            String name = new String(bytes).intern();
            Byte type = in.readByte();
            switch (type) {
                case -1: {
                    value = TmfStateValue.nullValue();
                    break;
                }
                case 0: {
                    value = TmfStateValue.newValueInt((int)in.readInt());
                    break;
                }
                case 2: {
                    value = TmfStateValue.newValueLong((long)in.readLong());
                    break;
                }
                case 1: {
                    length = in.readInt();
                    bytes = new byte[length];
                    in.read(bytes, 0, length);
                    value = TmfStateValue.newValueString((String)new String(bytes).intern());
                    break;
                }
                default: {
                    throw new IOException("Read object failed : Invalid data");
                }
            }
            content.put(name, (ITmfStateValue)value);
            ++i;
        }
        this.fContent = content;
    }

    private static byte getByteFromType(ITmfStateValue.Type type) {
        switch (type) {
            case NULL: {
                return -1;
            }
            case INTEGER: {
                return 0;
            }
            case STRING: {
                return 1;
            }
            case LONG: {
                return 2;
            }
        }
        throw new IllegalStateException("Data type " + type + " not supported");
    }
}

