/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.util;

import com.google.common.base.Joiner;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public final class TimeGraphStyleUtil {
    private static final char SEPARATOR = '.';
    private static final String PREFIX = "view.";

    private TimeGraphStyleUtil() {
    }

    public static void loadValue(ITimeGraphPresentationProvider presentationProvider, StateItem stateItem) {
        RGBAColor prefRgba;
        IPreferenceStore store = TimeGraphStyleUtil.getStore();
        String fillColorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, ITimeEventStyleStrings.fillColor());
        String heightFactorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, ITimeEventStyleStrings.heightFactor());
        Map<String, Object> styleMap = stateItem.getStyleMap();
        String prefRgbColor = store.getString(fillColorKey);
        if (!prefRgbColor.isEmpty() && (prefRgba = RGBAColor.fromString((String)store.getString(fillColorKey))) != null) {
            styleMap.put(ITimeEventStyleStrings.fillColor(), prefRgba.toInt());
        }
        store.setDefault(heightFactorKey, -1.0f);
        float prefHeightFactor = store.getFloat(heightFactorKey);
        if (prefHeightFactor != -1.0f) {
            styleMap.put(ITimeEventStyleStrings.heightFactor(), Float.valueOf(prefHeightFactor));
        }
    }

    private static @Nullable Object getItemProperty(StateItem stateItem) {
        return stateItem.getStyleMap().get(ITimeEventStyleStrings.itemTypeProperty());
    }

    public static String getPreferenceName(ITimeGraphPresentationProvider presentationProvider, StateItem stateItem, String styleKey) {
        return Joiner.on((char)'.').skipNulls().join((Object)(PREFIX + String.valueOf(presentationProvider.getPreferenceKey())), TimeGraphStyleUtil.getItemProperty(stateItem), new Object[]{stateItem.getStateString(), styleKey});
    }

    public static void loadValues(ITimeGraphPresentationProvider presentationProvider) {
        StateItem[] stateItemArray = presentationProvider.getStateTable();
        int n = stateItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            StateItem stateItem = stateItemArray[n2];
            TimeGraphStyleUtil.loadValue(presentationProvider, stateItem);
            ++n2;
        }
    }

    public static IPreferenceStore getStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

