/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.gef.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartFactory;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.events.IEditPartClickListener;
import org.eclipse.wb.internal.draw2d.events.EventTable;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.core.IRootContainer;

public abstract class AbstractEditPartViewer
implements IEditPartViewer {
    private IRootContainer m_rootEditPart;
    private EditDomain m_domain;
    private IEditPartFactory m_factory;
    private final Map<Object, EditPart> m_modelToEditPart = Maps.newHashMap();
    private MenuManager m_contextMenu;
    private List<EditPart> m_selectionList = Lists.newArrayList();
    private EventTable m_eventTable;
    private EditPart m_selecting;

    @Override
    public IRootContainer getRootContainer() {
        return this.m_rootEditPart;
    }

    protected final void setRootEditPart(IRootContainer rootEditPart) {
        Assert.isTrue((this.m_rootEditPart == null ? 1 : 0) != 0);
        this.m_rootEditPart = rootEditPart;
    }

    @Override
    public IEditPartFactory getEditPartFactory() {
        return this.m_factory;
    }

    public void setEditPartFactory(IEditPartFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public void registerEditPart(EditPart editPart) {
        this.m_modelToEditPart.put(editPart.getModel(), editPart);
    }

    @Override
    public void unregisterEditPart(EditPart editPart) {
        Object model = editPart.getModel();
        EditPart registerPart = this.m_modelToEditPart.get(model);
        if (registerPart == editPart) {
            this.m_modelToEditPart.remove(model);
        }
    }

    @Override
    public EditPart getEditPartByModel(Object model) {
        return this.m_modelToEditPart.get(model);
    }

    @Override
    public EditDomain getEditDomain() {
        return this.m_domain;
    }

    public void setEditDomain(EditDomain domain) {
        this.m_domain = domain;
    }

    public void setInput(Object model) {
        EditPart contentEditPart = this.m_factory.createEditPart((EditPart)((Object)this.m_rootEditPart), model);
        this.m_rootEditPart.setContent(contentEditPart);
    }

    @Override
    public MenuManager getContextMenu() {
        return this.m_contextMenu;
    }

    @Override
    public void setContextMenu(MenuManager menu) {
        if (this.m_contextMenu != null && this.m_contextMenu != menu) {
            this.m_contextMenu.dispose();
        }
        this.m_contextMenu = menu;
        Control control = this.getControl();
        Menu menuWidget = this.m_contextMenu.createContextMenu(control);
        if (menuWidget.getShell() == control.getShell()) {
            control.setMenu(menuWidget);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getEnsureEventTable().addListener(ISelectionChangedListener.class, listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getEnsureEventTable().removeListener(ISelectionChangedListener.class, listener);
    }

    public ISelection getSelection() {
        EditPart content;
        if (this.m_selectionList.isEmpty() && (content = this.m_rootEditPart.getContent()) != null) {
            return new StructuredSelection((Object)content);
        }
        return new StructuredSelection(this.m_selectionList);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.setSelection(structuredSelection.toList());
        }
    }

    private void fireSelectionChanged() {
        List<ISelectionChangedListener> listeners = this.getListeners(ISelectionChangedListener.class);
        if (listeners != null && !listeners.isEmpty()) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            for (ISelectionChangedListener listener : listeners) {
                listener.selectionChanged(event);
            }
        }
    }

    @Override
    public void appendSelection(EditPart part) {
        EditPart primary;
        Assert.isNotNull((Object)part);
        if (!this.m_selectionList.isEmpty() && (primary = this.m_selectionList.get(this.m_selectionList.size() - 1)) != part) {
            try {
                this.m_selecting = part;
                primary.setSelected(1);
            }
            finally {
                this.m_selecting = null;
            }
        }
        try {
            this.m_selecting = part;
            this.m_selectionList.remove(part);
            this.m_selectionList.add(part);
            part.setSelected(2);
        }
        finally {
            this.m_selecting = null;
        }
        this.fireSelectionChanged();
    }

    @Override
    public void setSelection(List<EditPart> editParts) {
        try {
            if (!editParts.isEmpty()) {
                this.m_selecting = editParts.get(0);
            }
            this.internalDeselectAll();
            Iterator<EditPart> I = editParts.iterator();
            while (I.hasNext()) {
                EditPart part = I.next();
                Assert.isNotNull((Object)part);
                this.m_selectionList.add(part);
                this.m_selecting = part;
                if (I.hasNext()) {
                    part.setSelected(1);
                    continue;
                }
                part.setSelected(2);
            }
        }
        finally {
            this.m_selecting = null;
        }
        this.fireSelectionChanged();
    }

    @Override
    public void select(EditPart part) {
        Assert.isNotNull((Object)part);
        if (this.m_selectionList.size() != 1 || this.m_selectionList.get(0) != part) {
            try {
                this.m_selectionList.add(part);
                this.m_selecting = part;
                this.internalDeselectAll();
                this.appendSelection(part);
            }
            finally {
                this.m_selecting = null;
            }
        }
    }

    @Override
    public void deselect(EditPart part) {
        Assert.isNotNull((Object)part);
        this.m_selectionList.remove(part);
        part.setSelected(0);
        if (!this.m_selectionList.isEmpty()) {
            EditPart primary = this.m_selectionList.get(this.m_selectionList.size() - 1);
            primary.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(List<EditPart> editParts) {
        for (EditPart part : editParts) {
            Assert.isNotNull((Object)part);
            this.m_selectionList.remove(part);
            part.setSelected(0);
        }
        if (!this.m_selectionList.isEmpty()) {
            EditPart primary = this.m_selectionList.get(this.m_selectionList.size() - 1);
            primary.setSelected(2);
        }
        this.fireSelectionChanged();
    }

    @Override
    public void deselectAll() {
        this.internalDeselectAll();
        this.fireSelectionChanged();
    }

    private void internalDeselectAll() {
        List<EditPart> selectionList = this.m_selectionList;
        this.m_selectionList = Lists.newArrayList();
        for (EditPart part : selectionList) {
            part.setSelected(0);
        }
    }

    @Override
    public List<EditPart> getSelectedEditParts() {
        return this.m_selectionList;
    }

    @Override
    public EditPart getSelectingEditPart() {
        return this.m_selecting;
    }

    @Override
    public void addEditPartClickListener(IEditPartClickListener listener) {
        this.getEnsureEventTable().addListener(IEditPartClickListener.class, listener);
    }

    @Override
    public void removeEditPartClickListener(IEditPartClickListener listener) {
        this.getEnsureEventTable().removeListener(IEditPartClickListener.class, listener);
    }

    @Override
    public void fireEditPartClick(EditPart editPart) {
        List<IEditPartClickListener> listeners = this.getListeners(IEditPartClickListener.class);
        if (listeners != null && !listeners.isEmpty()) {
            for (IEditPartClickListener listener : listeners) {
                listener.clickNotify(editPart);
            }
        }
    }

    private EventTable getEnsureEventTable() {
        if (this.m_eventTable == null) {
            this.m_eventTable = new EventTable();
        }
        return this.m_eventTable;
    }

    private <T> List<T> getListeners(Class<T> listenerClass) {
        return this.m_eventTable == null ? null : this.m_eventTable.getListeners(listenerClass);
    }
}

