/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wildwebdeveloper.Activator;

public class NodeRunDebugLaunchShortcut
implements ILaunchShortcut2 {
    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getLaunchConfigurations(this.getLaunchableResource(selection));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.getLaunchConfigurations(this.getLaunchableResource(editorpart));
    }

    public IResource getLaunchableResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return null;
            }
            Object firstObject = structuredSelection.getFirstElement();
            IResource resource = (IResource)Adapters.adapt((Object)firstObject, IResource.class);
            return resource;
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        IEditorInput input = editorpart.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    public void launch(ISelection selection, String mode) {
        ILaunchConfiguration[] configurations = this.getLaunchConfigurations(selection);
        this.launch(mode, configurations);
    }

    public void launch(IEditorPart editor, String mode) {
        ILaunchConfiguration[] configurations = this.getLaunchConfigurations(editor);
        this.launch(mode, configurations);
    }

    private void launch(String mode, ILaunchConfiguration[] configurations) {
        LaunchConfigurationSelectionDialog dialog;
        if (configurations.length == 1) {
            CompletableFuture.runAsync(() -> {
                try {
                    configurations[0].launch(mode, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"error", (String)e.getMessage(), (IStatus)e.getStatus());
                }
            });
        } else if (configurations.length > 1 && (dialog = new LaunchConfigurationSelectionDialog(Display.getDefault().getActiveShell(), (Object)configurations)).open() == 0) {
            this.launch(mode, Arrays.asList(dialog.getResult()).toArray(new ILaunchConfiguration[dialog.getResult().length]));
        }
    }

    private ILaunchConfiguration[] getLaunchConfigurations(IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return new ILaunchConfiguration[0];
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebug");
        try {
            ILaunchConfiguration[] existing = (ILaunchConfiguration[])Arrays.stream(launchManager.getLaunchConfigurations(configType)).filter(launchConfig -> {
                try {
                    return launchConfig.getAttribute("program", "").equals(resource.getLocation().toFile().toString());
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                    return false;
                }
            }).toArray(ILaunchConfiguration[]::new);
            if (existing.length != 0) {
                return existing;
            }
            String configName = launchManager.generateLaunchConfigurationName(resource.getLocation().toString());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configName);
            wc.setAttribute("program", resource.getLocation().toString());
            wc.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", resource.getLocation().removeLastSegments(1).toString());
            return new ILaunchConfiguration[]{wc};
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"error", (String)e.getMessage(), (IStatus)e.getStatus());
            Activator.getDefault().getLog().log(e.getStatus());
            return null;
        }
    }
}

