/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.launch.ui;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.jsdt.js.node.internal.Messages;
import org.eclipse.wst.jsdt.js.node.internal.ui.ImageResource;
import org.eclipse.wst.jsdt.js.node.internal.util.LaunchConfigurationUtil;

public class NodeLaunchMainTab
extends AbstractLaunchConfigurationTab {
    private Text scriptText;
    private Button workspaceButton;
    private Text projectText;
    private Button browseButton;
    private Label debugPortLabel;
    private Text debugPortText;
    private Label debugHostLabel;
    private Text debugHostText;
    private Button debugAddNetworkConsoleButton;
    private Button debugBreakButton;
    private SelectionAdapter selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            NodeLaunchMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NodeLaunchMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    private VerifyListener onlyDigitsListener = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            String string = e.text;
            char[] chars = new char[string.length()];
            string.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if ('0' > chars[i] || chars[i] > '9') {
                    e.doit = false;
                    return;
                }
                ++i;
            }
        }
    };

    public void createControl(Composite parent) {
        String mode = this.getLaunchConfigurationDialog().getMode();
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        Point minSize = composite.computeSize(0, 350);
        composite.setSize(minSize);
        if (composite.getParent() instanceof ScrolledComposite) {
            ScrolledComposite sc1 = (ScrolledComposite)composite.getParent();
            sc1.setMinSize(minSize);
            sc1.setExpandHorizontal(true);
            sc1.setExpandVertical(true);
        }
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createProjectGroup(composite);
        this.createMainFileGroup(composite);
        if (mode.equals("debug")) {
            this.createDebugSpecificsGroup(composite);
        }
        this.setControl((Control)scrolledComposite);
    }

    private void createDebugSpecificsGroup(Composite parent) {
        Group connectionGroup = new Group(parent, 0);
        connectionGroup.setText(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_CONNECTION_TEXT);
        GridData gd = new GridData(768);
        connectionGroup.setLayoutData((Object)gd);
        connectionGroup.setLayout((Layout)new GridLayout(1, false));
        connectionGroup.setFont(parent.getFont());
        this.debugHostLabel = new Label((Composite)connectionGroup, 0);
        this.debugHostLabel.setText(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_HOST_TEXT);
        this.debugHostText = new Text((Composite)connectionGroup, 2052);
        this.debugHostText.setLayoutData((Object)gd);
        this.debugHostText.setFont(parent.getFont());
        this.debugHostText.addModifyListener(this.modifyListener);
        this.debugPortLabel = new Label((Composite)connectionGroup, 0);
        this.debugPortLabel.setText(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_PORT_TEXT);
        this.debugPortText = new Text((Composite)connectionGroup, 2052);
        this.debugPortText.setTextLimit(5);
        this.debugPortText.setLayoutData((Object)gd);
        this.debugPortText.setFont(parent.getFont());
        this.debugPortText.addModifyListener(this.modifyListener);
        this.debugPortText.addVerifyListener(this.onlyDigitsListener);
        this.debugBreakButton = this.createCheckButton((Composite)connectionGroup, Messages.LAUNCH_CONFIGURATION_MAIN_TAB_BREAK_TEXT);
        this.debugBreakButton.addSelectionListener((SelectionListener)this.selectionListener);
        this.debugAddNetworkConsoleButton = this.createCheckButton((Composite)connectionGroup, Messages.LAUNCH_CONFIGURATION_MAIN_TAB_DEBUGGER_NETWORK_CONSOLE_TEXT);
        this.debugAddNetworkConsoleButton.addSelectionListener((SelectionListener)this.selectionListener);
    }

    private void createProjectGroup(Composite parent) {
        Group projectGroup = new Group(parent, 0);
        projectGroup.setText(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_PROJECT_TEXT);
        GridData gd = new GridData(768);
        projectGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setFont(parent.getFont());
        this.projectText = new Text((Composite)projectGroup, 2052);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.setFont(parent.getFont());
        this.projectText.addModifyListener(this.modifyListener);
        this.browseButton = this.createPushButton((Composite)projectGroup, Messages.LAUNCH_CONFIGURATION_MAIN_TAB_BROWSE_BUTTON, null);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String project = NodeLaunchMainTab.this.browseProjects(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_SELECT_PROJECT_DESCRIPTION);
                if (project != null && !project.equals("")) {
                    NodeLaunchMainTab.this.projectText.setText(project);
                    NodeLaunchMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    private void createMainFileGroup(Composite parent) {
        Group mainFileGroup = new Group(parent, 0);
        mainFileGroup.setText(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_MAIN_FILE_TEXT);
        GridData gd = new GridData(768);
        mainFileGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        mainFileGroup.setLayout((Layout)layout);
        mainFileGroup.setFont(parent.getFont());
        this.scriptText = new Text((Composite)mainFileGroup, 2052);
        this.scriptText.setLayoutData((Object)gd);
        this.scriptText.setFont(parent.getFont());
        this.scriptText.addModifyListener(this.modifyListener);
        this.workspaceButton = this.createPushButton((Composite)mainFileGroup, Messages.LAUNCH_CONFIGURATION_MAIN_TAB_WORKSPACE_BUTTON, null);
        this.workspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String script = NodeLaunchMainTab.this.browseWorkspace(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_SELECT_MAIN_FILE_DESCRIPTION);
                if (script != null && !script.equals("")) {
                    NodeLaunchMainTab.this.scriptText.setText(script);
                    String scriptLocation = null;
                    try {
                        scriptLocation = LaunchConfigurationUtil.resolveValue(script);
                    }
                    catch (CoreException coreException) {}
                    if (scriptLocation != null) {
                        IPath location = Path.fromOSString((String)scriptLocation);
                        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
                        NodeLaunchMainTab.this.projectText.setText(iFile.getProject().getName());
                    }
                }
                NodeLaunchMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private String browseProjects(String description) {
        IProject project;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getControl().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IProject project;
                return element instanceof IProject && (project = (IProject)element) != null && project.exists() && project.isOpen();
            }
        });
        dialog.setTitle(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_SELECT_PROJECT_TITLE);
        dialog.setMessage(description);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IProject) {
                    return new Status(0, "org.eclipse.wst.jsdt.js.node", 0, "", null);
                }
                return new Status(4, "org.eclipse.wst.jsdt.js.node", 4, "", null);
            }
        });
        if (dialog.open() == 0 && (project = (IProject)dialog.getFirstResult()) != null) {
            return project.getName();
        }
        return null;
    }

    private String browseWorkspace(String description) {
        IFile file;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getControl().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IProject || element instanceof IFolder || element instanceof IFile;
            }
        });
        dialog.setTitle(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_SELECT_MAIN_FILE_TITLE);
        dialog.setMessage(description);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                    return new Status(0, "org.eclipse.wst.jsdt.js.node", 0, "", null);
                }
                return new Status(4, "org.eclipse.wst.jsdt.js.node", 4, "", null);
            }
        });
        if (dialog.open() == 0 && (file = (IFile)dialog.getFirstResult()) != null) {
            return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", file.getFullPath().toString());
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projectText.setText(configuration.getAttribute("attr_app_project", ""));
            this.scriptText.setText(configuration.getAttribute("attr_app_path", ""));
            if (this.getLaunchConfigurationDialog().getMode().equals("debug")) {
                this.debugHostText.setText(configuration.getAttribute("attr_host_field", "localhost"));
                this.debugPortText.setText(configuration.getAttribute("attr_port_field", String.valueOf(5858)));
                this.debugAddNetworkConsoleButton.setSelection(configuration.getAttribute("attr_add_network_console_field", false));
                this.debugBreakButton.setSelection(configuration.getAttribute("attr_break_field", true));
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("attr_app_project", this.projectText.getText().trim());
        configuration.setAttribute("attr_app_path", this.scriptText.getText().trim());
        if (this.getLaunchConfigurationDialog().getMode().equals("debug")) {
            configuration.setAttribute("attr_host_field", this.debugHostText.getText().trim());
            configuration.setAttribute("attr_port_field", this.debugPortText.getText().trim());
            configuration.setAttribute("attr_add_network_console_field", this.debugAddNetworkConsoleButton.getSelection());
            configuration.setAttribute("attr_break_field", this.debugBreakButton.getSelection());
            LaunchConfigurationUtil.addSourceLookupAttr(configuration);
        }
        String projectName = this.projectText.getText().trim();
        configuration.setMappedResources(this.getResource(projectName));
    }

    private IResource[] getResource(String projectName) {
        IStatus status;
        if (projectName.length() > 0 && (status = ResourcesPlugin.getWorkspace().validateName(projectName, 4)).isOK()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            return new IResource[]{project};
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.validateEntries();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateEntries() {
        this.setErrorMessage(null);
        String projectName = this.projectText.getText().trim();
        if (projectName.length() <= 0) {
            this.setErrorMessage(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_ERROR_SPECIFY_PROJECT);
            return false;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists() || !project.isOpen()) {
            this.setErrorMessage(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_ERROR_PROJECT_DOES_NOT_EXIST);
            return false;
        }
        String scriptFile = this.scriptText.getText().trim();
        if (scriptFile.length() <= 0) {
            this.setErrorMessage(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_ERROR_SPECIFY_MAIN_FILE);
            return false;
        }
        try {
            scriptFile = LaunchConfigurationUtil.resolveValue(scriptFile);
        }
        catch (CoreException coreException) {}
        File file = null;
        if (scriptFile != null) {
            file = new File(scriptFile);
        }
        if (file == null || !file.exists() || file.isDirectory()) {
            this.setErrorMessage(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_ERROR_MAIN_FILE_DOES_NOT_EXIST);
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile ifile = workspace.getRoot().getFileForLocation(location);
        if (ifile == null || !ifile.getProject().getName().equals(projectName)) {
            this.setErrorMessage(NLS.bind((String)Messages.LAUNCH_CONFIGURATION_MAIN_TAB_ERROR_MAIN_FILE_NOT_IN_PROJECT, (Object)projectName));
            return false;
        }
        if (this.getLaunchConfigurationDialog().getMode().equals("debug")) {
            String host = this.debugHostText.getText();
            if (host.length() <= 0) {
                this.setErrorMessage(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_ERROR_SPECIFY_HOST);
                return false;
            }
            String port = this.debugPortText.getText();
            int portNumber = 0;
            if (!port.isEmpty()) {
                portNumber = Integer.valueOf(port);
            }
            if (port.length() <= 0 || portNumber < 1024 || portNumber > 65535) {
                this.setErrorMessage(Messages.LAUNCH_CONFIGURATION_MAIN_TAB_ERROR_INVALID_PORT);
                return false;
            }
        }
        return true;
    }

    public Image getImage() {
        return ImageResource.getImage("node_16.png");
    }

    public String getName() {
        return Messages.LAUNCH_CONFIGURATION_MAIN_TAB;
    }
}

