/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.editors;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Column;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ConnectionMetaData;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.ConnectionMetaDataManager;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Schema;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Table;
import org.eclipse.birt.report.data.oda.jdbc.utils.ISQLSyntax;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JdbcSQLContentAssistProcessor
implements IContentAssistProcessor,
ISQLSyntax {
    private transient ConnectionMetaData metaData = null;
    private transient ICompletionProposal[] lastProposals = null;
    private long timeout;

    public JdbcSQLContentAssistProcessor(long milliseconds) {
        this.timeout = milliseconds;
    }

    public void setDataSourceHandle(DataSourceDesign dataSourceHandle) {
        if (this.metaData != null) {
            this.metaData.clearCache();
            this.metaData = null;
        }
        String driverClass = dataSourceHandle.getPublicProperties().findProperty("odaDriverClass").getValue();
        String url = dataSourceHandle.getPublicProperties().findProperty("odaURL").getValue();
        String user = dataSourceHandle.getPublicProperties().findProperty("odaUser").getValue();
        String password = dataSourceHandle.getPublicProperties().findProperty("odaPassword").getValue();
        this.metaData = ConnectionMetaDataManager.getInstance().getMetaData(driverClass, url, user, password, this.getConnectionProperties(dataSourceHandle), this.timeout);
    }

    private Properties getConnectionProperties(DataSourceDesign dataSourceDesign) {
        try {
            return DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)dataSourceDesign);
        }
        catch (OdaException odaException) {
            return null;
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            if (offset > viewer.getTopIndexStartOffset()) {
                char ch = viewer.getDocument().getChar(offset - 1);
                if (ch == '.') {
                    this.lastProposals = this.getTableOrColumnCompletionProposals(viewer, offset);
                    return this.lastProposals;
                }
                return this.getRelevantProposals(viewer, offset);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private ICompletionProposal[] getTableOrColumnCompletionProposals(ITextViewer viewer, int offset) {
        if (offset > viewer.getTopIndexStartOffset() + 2) {
            try {
                String tableName = this.stripQuotes(this.findWord(viewer, offset - 2));
                String schemaName = null;
                int startOffset = offset - tableName.length() - 2;
                if (startOffset > viewer.getTopIndexStartOffset() && viewer.getDocument().getChar(startOffset) == '.') {
                    schemaName = this.findWord(viewer, startOffset - 1);
                }
                if (schemaName == null) {
                    Schema schema2 = this.metaData.getSchema(tableName);
                    if (schema2 != null) {
                        return this.convertTablesToCompletionProposals(schema2.getTables(), offset);
                    }
                    ArrayList schemas = this.metaData.getSchemas();
                    for (Schema schema2 : schemas) {
                        Table table = schema2.getTable(tableName);
                        if (table == null) continue;
                        return this.convertColumnsToCompletionProposals(table.getColumns(), offset);
                    }
                } else {
                    Table table;
                    Schema schema = this.metaData.getSchema(schemaName = this.stripQuotes(schemaName));
                    if (schema != null && (table = schema.getTable(tableName)) != null) {
                        return this.convertColumnsToCompletionProposals(table.getColumns(), offset);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    private ICompletionProposal[] getRelevantProposals(ITextViewer viewer, int offset) throws BadLocationException {
        if (this.lastProposals != null) {
            ArrayList<CompletionProposal> relevantProposals = new ArrayList<CompletionProposal>(10);
            String word = this.findWord(viewer, offset - 1).toLowerCase();
            int n = 0;
            while (n < this.lastProposals.length) {
                if (this.stripQuotes(this.lastProposals[n].getDisplayString().toLowerCase()).startsWith(word)) {
                    CompletionProposal proposal = new CompletionProposal(this.lastProposals[n].getDisplayString(), offset - word.length(), word.length(), this.lastProposals[n].getDisplayString().length());
                    relevantProposals.add(proposal);
                }
                ++n;
            }
            if (relevantProposals.size() > 0) {
                return relevantProposals.toArray(new ICompletionProposal[0]);
            }
        }
        return null;
    }

    private ICompletionProposal[] convertColumnsToCompletionProposals(ArrayList columns, int offset) {
        if (columns.size() > 0) {
            ICompletionProposal[] proposals = new ICompletionProposal[columns.size()];
            Iterator iter = columns.iterator();
            int n = 0;
            while (iter.hasNext()) {
                Column column = (Column)iter.next();
                proposals[n++] = new CompletionProposal(this.addQuotes(column.getName()), offset, 0, column.getName().length());
            }
            return proposals;
        }
        return null;
    }

    private ICompletionProposal[] convertTablesToCompletionProposals(ArrayList tables, int offset) {
        if (tables.size() > 0) {
            ICompletionProposal[] proposals = new ICompletionProposal[tables.size()];
            Iterator iter = tables.iterator();
            int n = 0;
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                proposals[n++] = new CompletionProposal(this.addQuotes(table.getName()), offset, 0, table.getName().length());
            }
            return proposals;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private String findWord(ITextViewer viewer, int offset) throws BadLocationException {
        block4: {
            ch = viewer.getDocument().getChar(offset);
            startOffset = offset;
            if (!this.isClosingQuoteChar(ch)) ** GOTO lbl16
            --startOffset;
            quoteChar = ch;
            if (quoteChar != '\'' || quoteChar != '\"') {
                quoteChar = this.getOpeningQuoteChar();
            }
            while (startOffset > viewer.getTopIndexStartOffset()) {
                ch = viewer.getDocument().getChar(startOffset);
                if (ch != quoteChar) {
                    --startOffset;
                    continue;
                }
                break block4;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                --startOffset;
lbl16:
                // 2 sources

                ** while (startOffset >= viewer.getTopIndexStartOffset() && viewer.getDocument().getChar((int)startOffset) != '.' && viewer.getDocument().getChar((int)startOffset) != ' ')
            }
lbl17:
            // 1 sources

            ++startOffset;
        }
        return viewer.getDocument().get(startOffset, offset - startOffset + 1);
    }

    private String stripQuotes(String string) {
        if (string.length() > 0 && this.isOpeningQuoteChar(string.charAt(0)) && this.isClosingQuoteChar(string.charAt(string.length() - 1))) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private String addQuotes(String string) {
        try {
            if (string.indexOf(32) != -1) {
                if ("ACCESS".equalsIgnoreCase(this.metaData.getDatabaseProductName())) {
                    return "[" + string + "]";
                }
                return "\"" + string + "\"";
            }
        }
        catch (Exception exception) {}
        return string;
    }

    private boolean isOpeningQuoteChar(char ch) {
        try {
            if ("ACCESS".equalsIgnoreCase(this.metaData.getDatabaseProductName())) {
                return ch == '[';
            }
            return ch == '\'' || ch == '\"';
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isClosingQuoteChar(char ch) {
        try {
            if ("ACCESS".equalsIgnoreCase(this.metaData.getDatabaseProductName())) {
                return ch == ']';
            }
            return ch == '\'' || ch == '\"';
        }
        catch (Exception exception) {
            return false;
        }
    }

    private char getOpeningQuoteChar() {
        try {
            if ("ACCESS".equalsIgnoreCase(this.metaData.getDatabaseProductName())) {
                return '[';
            }
        }
        catch (Exception exception) {}
        return '\"';
    }
}

