/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.eclipse.birt.report.designer.internal.ui.util.RTFDocumentHandler;

public class RTFHTMLHandler
implements RTFDocumentHandler {
    private HTMLNode rootNode;
    private HTMLNode parentNode;
    private HTMLNode currentNode;
    private Stack<HTMLNode> nodeStack = new Stack();

    public RTFHTMLHandler() {
        this.rootNode = this.parentNode = new HTMLNode().name("div");
    }

    @Override
    public void startElement(String name, AttributeSet attributeSet) {
        Object bold;
        Object underline;
        Object italic;
        this.currentNode = new HTMLNode().name(name.equalsIgnoreCase("paragraph") ? "div" : name);
        this.currentNode.parent(this.parentNode);
        this.nodeStack.add(this.currentNode);
        this.parentNode = this.currentNode;
        Object fontfamily = attributeSet.getAttribute(StyleConstants.FontFamily);
        Object fontsize = attributeSet.getAttribute(StyleConstants.FontSize);
        Object fontcolor = attributeSet.getAttribute(StyleConstants.Foreground);
        if (fontfamily != null || fontsize != null || fontcolor != null) {
            HTMLNode fontnode = new HTMLNode().name("font");
            if (fontfamily != null) {
                fontnode.attribute("face", fontfamily.toString());
            }
            if (fontcolor != null) {
                Color color = (Color)fontcolor;
                fontnode.attribute("color", this.makeColorString(color));
            }
            if (fontsize != null) {
                int size = (Integer)fontsize;
                fontnode.attribute("size", String.valueOf(size / 4));
            }
            this.currentNode = this.currentNode.child(fontnode);
        }
        if ((italic = attributeSet.getAttribute(StyleConstants.Italic)) != null && ((Boolean)italic).booleanValue()) {
            this.currentNode = this.currentNode.child(new HTMLNode().name("i"));
        }
        if ((underline = attributeSet.getAttribute(StyleConstants.Underline)) != null && ((Boolean)underline).booleanValue()) {
            this.currentNode = this.currentNode.child(new HTMLNode().name("u"));
        }
        if ((bold = attributeSet.getAttribute(StyleConstants.Bold)) != null && ((Boolean)bold).booleanValue()) {
            this.currentNode = this.currentNode.child(new HTMLNode().name("b"));
        }
    }

    @Override
    public void content(String content) {
        content = content.replaceAll("\\t", this.getSpaceTab(8));
        content = content.replaceAll("\\n", "<br/>");
        this.currentNode.content(content);
    }

    @Override
    public void endElement(String name) {
        this.parentNode = this.nodeStack.pop().parent;
    }

    private String makeColorString(Color color1) {
        String s = Long.toString(color1.getRGB() & 0xFFFFFF, 16);
        if (s.length() < 6) {
            StringBuffer stringbuffer = new StringBuffer();
            int i = s.length();
            while (i < 6) {
                stringbuffer.append("0");
                ++i;
            }
            stringbuffer.append(s);
            s = stringbuffer.toString();
        }
        return s;
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        this.trimRootNode(this.rootNode);
        this.unionRootNode(this.rootNode);
        this.serializeHTMLNode(this.rootNode, sb, 0);
        return sb.toString();
    }

    private void trimRootNode(HTMLNode rootNode) {
        List<HTMLNode> nodes = rootNode.getChildren();
        ArrayList<HTMLNode> temps = new ArrayList<HTMLNode>(nodes);
        int i = 0;
        while (i < nodes.size()) {
            HTMLNode node = nodes.get(i);
            if (this.isBlankNode(node)) {
                temps.remove(node);
            }
            ++i;
        }
        rootNode.setChildNodes(temps);
        nodes = rootNode.getChildren();
        i = 0;
        while (i < temps.size()) {
            nodes.get(i);
            this.trimRootNode(nodes.get(i));
            ++i;
        }
    }

    private boolean isBlankNode(HTMLNode node) {
        boolean bool = false;
        bool = node.getChildren().size() == 0 ? true : (node.getChildren().size() == 1 ? this.isBlankNode(node.getChildren().get(0)) : false);
        return node.getAttributes().size() == 0 && node.getContent() == null && bool;
    }

    private void unionRootNode(HTMLNode rootNode) {
        List<HTMLNode> nodes = rootNode.getChildren();
        if (nodes.size() == 1) {
            HTMLNode first = nodes.get(0);
            if (rootNode.getAttributes().size() == 0 && rootNode.getContent() == null && rootNode.name.equals(first.name)) {
                List<HTMLNode> temp = first.getChildren();
                rootNode.delete(first);
                int i = 0;
                while (i < temp.size()) {
                    rootNode.child(temp.get(i));
                    ++i;
                }
                this.unionRootNode(rootNode);
            }
        }
        nodes = rootNode.getChildren();
        int i = 0;
        while (i < nodes.size()) {
            this.unionRootNode(nodes.get(i));
            ++i;
        }
    }

    private void serializeHTMLNode(HTMLNode node, StringBuffer sb, int indent) {
        if (node.name.equals("content")) {
            if (node.childNodes.size() == 0 && node.content != null) {
                if (indent > 0) {
                    sb.append("\n");
                }
                int i = 0;
                while (i < indent) {
                    sb.append("\t");
                    ++i;
                }
                sb.append(node.content);
            }
            for (HTMLNode childNode : node.childNodes) {
                this.serializeHTMLNode(childNode, sb, indent);
            }
            return;
        }
        if (indent > 0) {
            sb.append("\n");
        }
        int i = 0;
        while (i < indent) {
            sb.append("\t");
            ++i;
        }
        sb.append("<").append(node.name);
        for (String key : node.attributes.keySet()) {
            sb.append(" ").append(key).append("=\"").append((String)node.attributes.get(key)).append("\"");
        }
        sb.append(">");
        for (HTMLNode childNode : node.childNodes) {
            this.serializeHTMLNode(childNode, sb, indent + 1);
        }
        if (node.content != null) {
            sb.append(node.content);
        }
        if (node.name.equals("div")) {
            sb.append("\n");
            i = 0;
            while (i < indent) {
                sb.append("\t");
                ++i;
            }
        }
        sb.append("</").append(node.name).append(">");
    }

    private String getSpaceTab(int i) {
        StringBuffer stringbuffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            stringbuffer.append("&nbsp;");
            ++j;
        }
        return stringbuffer.toString();
    }

    private static class HTMLNode {
        private String name;
        private String content;
        private HashMap<String, String> attributes = new HashMap();
        private List<HTMLNode> childNodes = new ArrayList<HTMLNode>();
        private HTMLNode parent;

        private HTMLNode() {
        }

        public HTMLNode name(String name) {
            this.name = name;
            return this;
        }

        public String getContent() {
            return this.content;
        }

        public HTMLNode attribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public HTMLNode content(String content) {
            this.content = content;
            return this;
        }

        public void setChildNodes(List<HTMLNode> childNodes) {
            this.childNodes = childNodes;
        }

        public HTMLNode parent(HTMLNode parent) {
            parent.child(this);
            return parent;
        }

        public HTMLNode child(HTMLNode child) {
            child.parent = this;
            this.childNodes.add(child);
            return child;
        }

        public HTMLNode delete(HTMLNode child) {
            this.childNodes.remove(child);
            return child;
        }

        public List<HTMLNode> getChildren() {
            return Collections.unmodifiableList(this.childNodes);
        }

        public HashMap<String, String> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return this.name;
        }
    }
}

