/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.figures;

import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.ui.editparts.ScopeEditPart;
import org.eclipse.bpel.ui.editparts.borders.ScopeBorder;
import org.eclipse.bpel.ui.figures.HandlerLinkerAdapter;
import org.eclipse.bpel.ui.figures.ManhattanConnectionRouterEx;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Ray;

public class ScopeHandlerLinker
extends HandlerLinkerAdapter {
    private ScopeEditPart scope;

    public ScopeHandlerLinker(ScopeEditPart scopeEditPart) {
        super(scopeEditPart);
        this.scope = scopeEditPart;
    }

    @Override
    protected CompensationHandler getCompensationHandler() {
        return this.scope.getCompensationHandler();
    }

    @Override
    protected EventHandler getEventHandler() {
        return this.scope.getEventHandler();
    }

    @Override
    protected FaultHandler getFaultHandler() {
        return this.scope.getFaultHandler();
    }

    @Override
    protected int getEHTargetAnchorLoc() {
        if (!this.isHorizontalLayout()) {
            if (this.getFaultHandler() != null && this.getCompensationHandler() != null && this.getTerminationHandler() != null) {
                return 2;
            }
            return 0;
        }
        return super.getEHTargetAnchorLoc();
    }

    @Override
    protected boolean isShowCH() {
        return this.scope.getShowCompensationHandler();
    }

    @Override
    protected boolean isShowEH() {
        return this.scope.getShowEventHandler();
    }

    @Override
    protected boolean isShowFH() {
        return this.scope.getShowFaultHandler();
    }

    @Override
    protected int getTHTargetAnchorLoc() {
        return this.isHorizontalLayout() ? 2 : 0;
    }

    @Override
    protected TerminationHandler getTerminationHandler() {
        return this.scope.getTerminationHandler();
    }

    @Override
    protected boolean isShowTH() {
        return this.scope.getShowTerminationHandler();
    }

    @Override
    protected Ray getTHRoutingEndConstraint() {
        return this.isHorizontalLayout() ? ManhattanConnectionRouterEx.LEFT : ManhattanConnectionRouterEx.UP;
    }

    @Override
    protected IFigure getCHFigure() {
        return ((ScopeBorder)this.scope.getContentPane().getBorder()).getCompensationImageFigure();
    }

    @Override
    protected IFigure getEHFigure() {
        return ((ScopeBorder)this.scope.getContentPane().getBorder()).getEventImageFigure();
    }

    @Override
    protected IFigure getFHFigure() {
        return ((ScopeBorder)this.scope.getContentPane().getBorder()).getFaultImageFigure();
    }

    @Override
    protected IFigure getTHFigure() {
        return ((ScopeBorder)this.scope.getContentPane().getBorder()).getTerminationImageFigure();
    }
}

