/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.lane;

import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.features.containers.lane.MoveLaneFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class MoveFromLaneToLaneFeature
extends MoveLaneFeature {
    public MoveFromLaneToLaneFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        Lane targetLane = this.getTargetLane((ITargetContext)context);
        if (targetLane.getFlowNodeRefs() != null && targetLane.getFlowNodeRefs().size() > 0) {
            return false;
        }
        Lane movedLane = this.getMovedLane(context);
        return targetLane.getChildLaneSet() == null || !targetLane.getChildLaneSet().getLanes().contains(movedLane);
    }

    @Override
    protected void internalMove(IMoveShapeContext context) {
        Lane movedLane = this.getMovedLane(context);
        Lane targetLane = this.getTargetLane((ITargetContext)context);
        Lane sourceLane = this.getSourceLane(context);
        this.modifyModelStructure(sourceLane, targetLane, movedLane);
        this.layoutPictogramElement((PictogramElement)context.getSourceContainer());
        this.layoutPictogramElement((PictogramElement)context.getTargetContainer());
    }

    private void modifyModelStructure(Lane sourceLane, Lane targetLane, Lane movedLane) {
        if (targetLane.getChildLaneSet() == null) {
            LaneSet newLaneSet = this.createLaneSet();
            targetLane.setChildLaneSet(newLaneSet);
        }
        Process sourceProcess = this.getProcess(sourceLane);
        Process targetProcess = this.getProcess(targetLane);
        this.moveLane(movedLane, sourceProcess, targetProcess);
        targetLane.getChildLaneSet().getLanes().add(movedLane);
        sourceLane.getChildLaneSet().getLanes().remove(movedLane);
        if (sourceLane.getChildLaneSet().getLanes().isEmpty()) {
            sourceLane.setChildLaneSet(null);
        }
    }
}

